/*****************************************************************************/

/*
 *      filechooser.cpp is part of SoftBots.
 *
 *      Copyright (C) 2008  Atul Sowani (sowani@gmail.com)
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 *      02110-1301 USA
 *
 *
 */

/*****************************************************************************/

#include "filechooser.h"

myFileChooser::myFileChooser (QWidget *parent, const char *name)
        : QWidget ( parent, name ), md ( File ), filter ( "*.*" )
{
    QHBoxLayout *layout = new QHBoxLayout (this);
    layout->setMargin (0);

    lineEdit = new QLineEdit ( this, "filechooser_lineedit" );
    layout->addWidget (lineEdit);

    connect ( lineEdit, SIGNAL (textChanged (const QString &)),
              this, SIGNAL (fileNameChanged (const Qstring &)) );

    button = new QPushButton ( "...", this, "filechooser_button" );
    button->setFixedWidth ( button->fontMetrics().width ( "..." ) );
    layout->addWidget ( button );

    connect ( button, SIGNAL ( clicked() ),
              this, SLOT ( chooseFile() ) );
    setFocusProxy ( lineEdit );
}

void myFileChooser::setFileName ( const QString &fn )
{
    lineEdit->setText ( fn );
}

QString myFileChooser::fileName() const
{
    return lineEdit->text();
}

void myFileChooser::setMode (Mode m)
{
    md = m;
}

myFileChooser::Mode myFileChooser::mode() const
{
    return md;
}

void myFileChooser::setFilter ( const QString& flt )
{
    filter = flt;
}

void myFileChooser::chooseFile()
{
    QString fn;
    if ( mode() == File )
        fn = QFileDialog::getOpenFileName ( lineEdit->text(),
                                            filter, this,
                                            "Open File Dialog",
                                            "Choose a file to open" );
    else
        fn = QFileDialog::getExistingDirectory ( lineEdit->text(), this );

    if ( !fn.isEmpty() )
    {
        lineEdit->setText (fn);
        emit fileNameChanged ( fn );
    }
}
