// $Id$
//
// Copyright (C) 2003 Alan Grosskurth
//
// This file is part of Spatter.
//
// Spatter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Spatter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Spatter; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#include "spotlist.hpp"
#include "tabdelimtextfile.hpp"

//
// Spot
//

Spot::Spot(const lti::point& origin, const lti::imatrix& mask)
    : m_origin(origin), m_mask(mask)
{   
}

const lti::point&
Spot::origin() const
{
    return m_origin;
}

const lti::imatrix&
Spot::mask() const
{
    return m_mask;
}

const lti::point
Spot::size() const
{
    return lti::point(m_mask.rows(), m_mask.columns());
}

const lti::point
Spot::center() const
{
    return m_origin + size()/2;
}

//
// SpotList
//

SpotList::SpotList()
{
}

SpotList::SpotList(const char* fname)
{
    DelimTextFileReader tab_file(fname);

    std::vector< std::string > data;

    // Read each spot
    while (tab_file.read_line(data) != -1) {
        lti::point origin(StringParser::parse_int(data[0]),
                          StringParser::parse_int(data[1]));

        lti::point size(StringParser::parse_int(data[2]),
                        StringParser::parse_int(data[3]));

        lti::imatrix mask(StringParser::parse_matrix(data[4],
                                                     size[0], size[1]));

        data.clear();

        spots.push_back(Spot(origin, mask));
    }
}

void
SpotList::save(const char* fname)
{
    DelimTextFileWriter tab_file(fname);

    // Write each spot
    for (int i = 0; i < spots.size(); ++i) {
        std::vector< std::string > data;

        data.push_back(StringParser::unparse_int(spots[i].origin()[0]));
        data.push_back(StringParser::unparse_int(spots[i].origin()[1]));

        data.push_back(StringParser::unparse_int(spots[i].mask().rows()));
        data.push_back(StringParser::unparse_int(spots[i].mask().columns()));

        data.push_back(StringParser::unparse_matrix(spots[i].mask()));

        tab_file.write_line(data);
    }
}
