// $Id$
//
// Copyright (C) 2003 Alan Grosskurth
//
// This file is part of Spatter.
//
// Spatter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Spatter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Spatter; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#ifndef INCLUDED_TABDELIMTEXTFILE_HPP
#define INCLUDED_TABDELIMTEXTFILE_HPP

#include <fstream>
#include <string>
#include <vector>

#include <ltiTypes.h>
#include <ltiMatrix.h>

class StringParser {
  public:
    static int parse_int(const std::string& str);    
    static double parse_double(const std::string& str);
    static lti::ubyte* parse_int_array(const char* s, unsigned int len);
    static lti::imatrix parse_matrix(const std::string& str,
                                     int rows, int columns);

    static std::string unparse_int(int x);
    static std::string unparse_double(double x);
    static std::pair< std::string, std::string >
    unparse_point(lti::point point);

    static std::string unparse_matrix(lti::imatrix mat);
};

class DelimTextFileReader {
  public:
    DelimTextFileReader(const char* fname);
    ~DelimTextFileReader();
    int read_line(std::vector< std::string >& data);

  private:
    std::ifstream m_fs;
};

class DelimTextFileWriter {
  public:
    DelimTextFileWriter(const char* fname);
    ~DelimTextFileWriter();
    int write_line(std::vector< std::string >& data);

  private:
    std::ofstream m_fs;
};

#if 0
void
save_tab_delim_text_file(const char* fname,
                             std::vector< std::vector< std::string > >& data);

std::vector< std::vector< std::string > >
load_tab_delim_text_file(const char* fname);

void
save_spots(const char* fname, const std::vector< Spot > spots);

std::pair< Geometry, Geometry >
load_geometry(const char* fname);

Grid
load_grid(const char* fname, const Geometry& geo, const Geometry& subgeo);

void
save_grid(const char* fname, const Grid& grid);
#endif

#endif // INCLUDED_TABDELIMTEXTFILE_HPP
