#!/usr/bin/env python
#
# $Id$
#
# Copyright (C) 2003 Alan Grosskurth
#
# This file is part of Spatter.
#
# Spatter is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Spatter is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Spatter; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

import Image, ImageChops
import sys, os, os.path
import numarray
import arrayutils

def go(resolver):
    print 'Generating combined image...'
    cy3 = Image.open(resolver.cy3_fname)
    cy5 = Image.open(resolver.cy5_fname)
    a3 = arrayutils.image2array(cy3)
    a5 = arrayutils.image2array(cy5)
    aout = numarray.sqrt(a3).astype(numarray.UInt8) \
           + numarray.sqrt(a5).astype(numarray.UInt8)
    out = arrayutils.array2image(aout)
    out.save(resolver.jpg_image_fname)
    print 'Combined image saved as', resolver.jpg_image_fname

def print_usage(argv):
    print 'Usage:', argv[0], 'cy3file cy5file imagefile'

def main():
    if len(sys.argv) < 4:
        print_usage()
    else:
        go(argv[1], argv[2], argv[3])

if __name__ == '__main__':
    main()
