#!/usr/bin/env python
#
# $Id$
#
# Copyright (C) 2003 Alan Grosskurth
#
# This file is part of Spatter.
#
# Spatter is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Spatter is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Spatter; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

import combiner
import quantifier

import os, sys

class FilenameResolver:
    def __init__(self, cy3_fname, cy5_fname, geo_fname, output_dir):
        def fix_ending(fname):
            import re
            r = re.compile('(.+)(_|-)+(Cy|cy)*$')
            m = r.search(fname)
            if m:
                new_fname = m.group(1)
            else:
                new_fname = fname
            return new_fname

        self.cy3_fname = cy3_fname
        self.cy5_fname = cy5_fname
        self.geo_fname = geo_fname
        self.output_dir = output_dir
        root_string = fix_ending(os.path.commonprefix([cy3_fname, cy5_fname]))
        (root_dir, root_fname) = os.path.split(root_string)
        root_fname = output_dir + root_fname

        # Check output directory exists
        if not os.path.isdir(output_dir):
            print "Directory %s does not exist" % output_dir
            sys.exit()
        if not os.path.isfile(cy3_fname):
            print "Image file %s does not exist" % cy3_fname
            sys.exit()
        if not os.path.isfile(cy5_fname):
            print "Image file %s does not exist" % cy3_fname
            sys.exit()
        if not os.path.isfile(geo_fname):
            print "Geometry file %s does not exist" % geo_fname
            sys.exit()

        self.jpg_image_fname = root_fname + '.jpg'
        self.grid_fname = root_fname + '.grid'
        self.grid_image_fname = root_fname + '-grid.jpg'
        self.spot_fname = root_fname + '.spot'
        self.spot_image_fname = root_fname + '-spot.jpg'
        self.data_fname = root_fname + '.dat'

def gridder(resolver):
    command = '../gridder'
    args = [command,
            resolver.jpg_image_fname,
            resolver.geo_fname,
            resolver.grid_fname]
    print 'Spawning gridder...'
    os.spawnv(os.P_WAIT, command, args) #, os.environ.get('PATH') + ':..')

def gridviewer(resolver):
    command = '../gridviewer'
    args = [command,
            resolver.jpg_image_fname,
            resolver.grid_fname,
            resolver.grid_image_fname]
    print 'Spawning gridviewer...'
    os.spawnv(os.P_WAIT, command, args) #, os.environ.get('PATH') + ':..')

def segmenter(resolver):
    command = '../segmenter'
    args = [command,
            resolver.jpg_image_fname,
            resolver.grid_fname,
            resolver.spot_fname]
    print 'Spawning segmenter...'
    os.spawnv(os.P_WAIT, command, args) #, os.environ.get('PATH') + ':..')

def spotviewer(resolver):
    command = '../spotviewer'
    args = [command,
            resolver.jpg_image_fname,
            resolver.spot_fname,
            resolver.spot_image_fname]
    print 'Spawning spotviewer...'
    os.spawnv(os.P_WAIT, command, args) #, os.environ.get('PATH') + ':..')   

def main():
    if len(sys.argv) < 5:
        print_usage()
    else:
        resolver = FilenameResolver(sys.argv[1], sys.argv[2],
                                    sys.argv[3], sys.argv[4]);
        
        combiner.go(resolver)
        gridder(resolver)
        gridviewer(resolver)
        segmenter(resolver)
        spotviewer(resolver)
        #quantifier.go(resolver)

def print_usage():
    print "Usage:", sys.argv[0], "cy3file cy5file geometryfile outputdir"

if __name__ == '__main__':
    main()
