// $Id: dsvfile.cpp,v 1.1 2005/02/18 10:26:43 grosskur Exp $
//
// Copyright (C) 2003 Alan Grosskurth
//
// This file is part of Spatter.
//
// Spatter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Spatter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Spatter; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#include "dsvfile.hpp"

#include <sstream>
#include <fstream>


DsvFileReader::DsvFileReader(std::istream& in, const char delim)
    : m_fs(in), m_delim(delim)
{
}

DsvFileReader::~DsvFileReader()
{
//    if (m_fs.is_open()) {
//        m_fs.close();
//    }
}

int
DsvFileReader::read_line(std::vector< std::string >& data)
{
    //assert(m_fs.is_open());

    std::string line;

    if (!std::getline(m_fs, line).eof()) {
        std::string::size_type beg_idx = line.find_first_not_of(m_delim);

        while (beg_idx != std::string::npos) {
            std::string::size_type end_idx =
                line.find_first_of(m_delim, beg_idx);

            if (end_idx == std::string::npos) {
                end_idx = line.length();
            }

            data.push_back(line.substr(beg_idx, end_idx-beg_idx));

            beg_idx = line.find_first_not_of(m_delim, end_idx);
        }
    } else {
        return -1;
    }

    return 0;
}

DsvFileWriter::DsvFileWriter(std::ostream& out, const char delim)
    : m_fs(out), m_delim(delim)
{
}


DsvFileWriter::~DsvFileWriter()
{
//    if (m_fs.is_open()) {
//        m_fs.close();
//    }
}


int
DsvFileWriter::write_line(std::vector< std::string >& data)
{
    assert(m_fs.is_open());

    std::vector< std::string >::const_iterator elem;
    for (elem = data.begin(); elem + 1 != data.end(); ++elem) {
        m_fs << *elem << m_delim;
    }
    m_fs << *elem << std::endl;

    return 0;
}
