// $Id: grid.hpp,v 1.1 2005/02/18 10:26:43 grosskur Exp $
//
// Copyright (C) 2003 Alan Grosskurth
//
// This file is part of Spatter.
//
// Spatter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Spatter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Spatter; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#ifndef INCLUDED_GRID_HPP
#define INCLUDED_GRID_HPP

#include <fstream>
#include <vector>
#include <ltiPoint.h>

class Grid {
  public:
    // Constructor
    Grid();

    Grid(const lti::point& size, const lti::dpoint& delta,
         const lti::point& subgrid_size, const lti::dpoint& subgrid_delta);

    Grid(std::istream& in);

    // Destructor
    virtual ~Grid();

    const lti::point size() const;

    const lti::dpoint delta() const;

    const lti::point subgrid_size() const;

    const lti::dpoint subgrid_delta() const;

    const lti::point& origin() const;

    const lti::point pixel_size() const;

    void move(const lti::point& dist);

    // SUBGRID METHODS

    const lti::point subgrid_pixel_size() const;

    const lti::point subgrid_origin(int row, int column) const;

    const lti::point subgrid_node(int row, int column,
                                  const lti::point& coord) const;

    const lti::point subgrid_node(int row, int column,
                                  int subgrid_row, int subgrid_column) const;

    void subgrid_move(int row, int column, const lti::point& dist);

    int subgrid_count() const;

    // SPOT METHODS

    const lti::point spot_center(int row, int column,
                                 int subgrid_row, int subgrid_column) const;

    const lti::point spot_origin(int row, int column,
                                 int subgrid_row, int subgrid_column) const;

    const lti::point spot_origin(int index) const;

    int spot_count() const;

    void load(std::istream& in);

    void save(std::ostream& out) const;
 
  private:
    lti::point m_size;
    lti::dpoint m_delta;

    lti::point m_subgrid_size;
    lti::dpoint m_subgrid_delta;

    lti::point m_origin;

    std::vector< lti::point > m_subgrid_origins;
};

#endif // INCLUDED_GRID_HPP
