// $Id: gridder-adjustcoarse.cpp,v 1.1 2005/02/18 10:26:43 grosskur Exp $
//
// Copyright (C) 2003 Alan Grosskurth
//
// This file is part of Spatter.
//
// Spatter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Spatter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Spatter; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#include "grid.hpp"
#include "gridder.hpp"

#include <ltiSplitImageTorgI.h>
#include <ltiMaskFunctors.h>
#include <limits>

static lti::channel8
get_grid_image(const Grid& grid)
{
    lti::channel8 grid_mat(grid.pixel_size()[0],
                           grid.pixel_size()[1],
                           (lti::ubyte)0);

    // Generate the grid pattern
    for (int i = 0; i < grid.size()[0]; ++i) {
        for (int j = 0; j < grid.size()[1]; ++j) {
            int from_row = (int)(i * grid.delta()[0]);
            int from_col = (int)(j * grid.delta()[1]);
            int to_row = from_row + grid.subgrid_pixel_size()[0];
            int to_col = from_col + grid.subgrid_pixel_size()[1];
#if 0
            std::cerr << "(" << i << "," << j << ")" << std::endl;
            std::cerr << "  (" << from_row << "," << from_col << ")"
                      << std::endl;
            std::cerr << "  (" << to_row << "," << to_col << ")"
                      << std::endl;
#endif
            grid_mat.fill(1, from_row, from_col, to_row, to_col);
        }
    }

    return grid_mat;
}


namespace spatter {

void
grid_adjust_coarse(const lti::image& im,
                  Grid& grid)
{
    std::cerr << "Coarse-tuning subgrid origins..." << std::endl;

    lti::channel8 im8;    
    lti::splitImageTorgI splitter;
    splitter.getIntensity(im, im8);

    lti::channel8 grid_mat = get_grid_image(grid);

    lti::point im_size = lti::point(im8.size().y, im8.size().x);
    lti::point move_distance = im_size - grid.pixel_size();

    // Iterate over possible positions
    lti::channel8 region(grid.pixel_size()[0],
                         grid.pixel_size()[1],
                         (lti::ubyte)0);

    lti::channel8 inv_region(grid.pixel_size()[0],
                             grid.pixel_size()[1],
                             (lti::ubyte)0);

    int max_val = std::numeric_limits<int>::min();
    lti::point max_point(0,0);

    std::cerr << move_distance << std::endl;

    for (int i = 0;
         i < move_distance[0];
         i += (int)grid.subgrid_delta()[0]) {
        for (int j = 0;
             j < move_distance[1];
             j += (int)grid.subgrid_delta()[1]) {
            region.fill(im8,
                        0, 0, grid.pixel_size()[0], grid.pixel_size()[1],
                        i, j);

            lti::maskFunctor<lti::channel8::value_type> masker;

            masker.multiply(grid_mat, region);

            //region.emultiply(grid_mat);

            int curr_val = region.sumOfElements();

//            std::cerr << lti::point(i, j) << ": " << curr_val << std::endl;

            if (curr_val > max_val) {
                max_val = curr_val;
                max_point = lti::point(i, j);
            }
        }
        std::cerr << i << " rows completed" << std::endl;
    }

//    std::cerr << max_point << " " << max_val << std::endl;

    // Move the grid
    grid.move(max_point);
}

} // namespace spatter
