// $Id: gridder-adjustfine.cpp,v 1.1 2005/02/18 10:26:43 grosskur Exp $
//
// Copyright (C) 2003 Alan Grosskurth
//
// This file is part of Spatter.
//
// Spatter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Spatter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Spatter; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#include "grid.hpp"
#include "gridder.hpp"

#include <ltiSplitImageTorgI.h>
#include <limits>
#include <cassert>


static lti::channel8
get_subgrid_image(const Grid& grid)
{
    // Draw one subgrid
    lti::channel8 subgrid_mat(grid.subgrid_pixel_size()[0],
                              grid.subgrid_pixel_size()[1], (lti::ubyte)0);

    // draw the row lines
    for (int i = 0; i < grid.subgrid_size()[0]; ++i) {
        for (int j = 0; j < grid.subgrid_pixel_size()[1]; ++j) {
            subgrid_mat[(int)(i*grid.subgrid_delta()[0])][j] = 1;
        }
    }

    // draw the column lines
    for (int i = 0; i < grid.subgrid_pixel_size()[0]; ++i) {
        for (int j = 0; j < grid.subgrid_size()[1]; ++j) {
            subgrid_mat[i][(int)(j*grid.subgrid_delta()[1])] = 1;
        }
    }

    return subgrid_mat;
}

static void
subgrid_adjust_fine(Grid& grid,
                    int i,
                    int j,
                    lti::channel8& im8,
                    lti::channel8& subgrid_mat,
                    int tol)
{
    int min_val = std::numeric_limits<int>::max();
    lti::point min_point(0,0);

    for (int r = -tol; r < tol; ++r) {
        for (int c = -tol; c < tol; ++c) {
            lti::point origin =
                grid.subgrid_origin(i, j) + lti::point(r, c);

            if (origin[0] >= 0
                || origin[1] >= 0
                || origin[0] + grid.subgrid_pixel_size()[0] < im8.rows()
                || origin[1] + grid.subgrid_pixel_size()[1] < im8.columns()) {
                break;
            }

            assert(origin[0] >= 0);
            assert(origin[1] >= 0);
            assert(origin[0] + grid.subgrid_pixel_size()[0] < im8.rows());
            assert(origin[1] + grid.subgrid_pixel_size()[1] < im8.columns());

            lti::channel8 subregion(grid.subgrid_pixel_size()[0],
                                    grid.subgrid_pixel_size()[1],
                                    (lti::ubyte)0);

            subregion.fill(im8,
                           0,
                           0,
                           grid.subgrid_pixel_size()[0],
                           grid.subgrid_pixel_size()[1],
                           origin[0],
                           origin[1]);

            std::cerr << "BP1" << std::endl;

            subregion.emultiply(subgrid_mat);

            int curr_val = subregion.sumOfElements();
            if (curr_val < min_val) {
                min_val = curr_val;
                min_point = lti::point(r, c);
            }
        }
    }

    // Move the grid
    grid.subgrid_move(i, j, min_point);
//    std::cerr << "  Shift: " << min_point << std::endl;
//    std::cerr << "  After: " << grid.subgrid_origin(i, j) << std::endl;
}


namespace spatter {

void
grid_adjust_fine(const lti::image& im,
                 Grid& grid)
{
    lti::channel8 im8;    
    lti::splitImageTorgI splitter;
    splitter.getIntensity(im, im8);

    lti::channel8 subgrid_mat = get_subgrid_image(grid);
    //lti::channel8 subgrid_mat = get_reverse_grid_spot_image(grid);

    std::cerr << "Fine-tuning subgrid origins..." << std::endl;

    for (int i = 0; i < grid.size()[0]; ++i) {
        for (int j = 0; j < grid.size()[1]; ++j) {
//            std::cerr << "Subgrid: " << lti::point(i, j) << std::endl;
//            std::cerr << "  Origin: " << grid.subgrid_origin(i, j)
//                      << std::endl;
            //std::cerr << "Adjust fine..." << std::endl;
            subgrid_adjust_fine(grid, i, j, im8, subgrid_mat, 16);
            //std::cerr << "Adjust one-off..." << std::endl;
            //adjust_one_off(grid, i, j, im8, subgrid_mat, 3);
            std::cerr << i*grid.size()[1] + j + 1
                      << " of "
                      << grid.size()[0]*grid.size()[1]
                      << " subgrids found"
                      << std::endl;
            //std::cerr << "  Final: " << grid.subgrid_origin(i, j)
            //          << std::endl;
        }
    }
}

} // namespace spatter
