// $Id: stringparser.hpp,v 1.1 2005/02/18 10:26:43 grosskur Exp $
//
// Copyright (C) 2003 Alan Grosskurth
//
// This file is part of Spatter.
//
// Spatter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Spatter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Spatter; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#ifndef INCLUDED_STRINGPARSER_HPP
#define INCLUDED_STRINGPARSER_HPP

#include <ltiTypes.h>
#include <ltiMatrix.h>

typedef std::pair<std::string, std::string> pair_string;

namespace spatter {
    int parse_int(const std::string& str);    
    double parse_double(const std::string& str);
    lti::ubyte* parse_int_array(const char* s, unsigned int len);
    lti::imatrix parse_matrix(const std::string& str,
                              int rows, int columns);

    std::string unparse_int(int x);
    std::string unparse_double(double x);
    pair_string unparse_point(lti::point point);

    std::string unparse_matrix(lti::imatrix mat);
}

#endif // INCLUDED_STRINGPARSER_HPP
