// $Id: arraygeometry.cpp,v 1.2 2005/02/25 12:22:15 grosskur Exp $
//
// Copyright (C) 2003 Alan Grosskurth
//
// This file is part of Spatter.
//
// Spatter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Spatter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Spatter; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#include "arraygeometry.hpp"
#include "dsvfile.hpp"
#include "stringparser.hpp"

ArrayGeometry::ArrayGeometry() {}

ArrayGeometry::ArrayGeometry(std::istream& in)
{
    load(in);
}

void
ArrayGeometry::load(std::istream& in)
{
    DsvFileReader tab_file(in, ':');

    std::vector< std::string > data;

    // Read the array geometry
    tab_file.read_line(data);

    if (data.size() != 8) {
        std::cout << "Invalid geometry file" << std::endl;
        return;
    }

    size = lti::ipoint(spatter::parse_int(data[0]),
                      spatter::parse_int(data[1]));
    delta = lti::dpoint(spatter::parse_double(data[2]),
                        spatter::parse_double(data[3]));
    
    subgrid_size = lti::ipoint(spatter::parse_int(data[4]),
                              spatter::parse_int(data[5]));
    subgrid_delta = lti::dpoint(spatter::parse_double(data[6]),
                                spatter::parse_double(data[7]));
}
