// $Id: dsvfile.hpp,v 1.1 2005/02/18 10:26:43 grosskur Exp $
//
// Copyright (C) 2003 Alan Grosskurth
//
// This file is part of Spatter.
//
// Spatter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Spatter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Spatter; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#ifndef INCLUDED_DSVFILE_HPP
#define INCLUDED_DSVFILE_HPP

#include <fstream>
#include <string>
#include <vector>

class DsvFileReader {
  public:
    DsvFileReader(std::istream& in, const char delim);
    ~DsvFileReader();
    int read_line(std::vector< std::string >& data);

  private:
    std::istream& m_fs;
    const char m_delim;
};

class DsvFileWriter {
  public:
    DsvFileWriter(std::ostream& out, const char delim);
    ~DsvFileWriter();
    int write_line(std::vector< std::string >& data);

  private:
    std::ostream& m_fs;
    const char m_delim;
};

#endif // INCLUDED_DSVFILE_HPP
