// $Id: grid.hpp,v 1.2 2005/02/25 12:22:16 grosskur Exp $
//
// Copyright (C) 2003 Alan Grosskurth
//
// This file is part of Spatter.
//
// Spatter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Spatter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Spatter; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#ifndef INCLUDED_GRID_HPP
#define INCLUDED_GRID_HPP

#include <fstream>
#include <vector>
#include <ltiPoint.h>

class Grid {
  public:
    // Constructor
    Grid();

    Grid(const lti::ipoint& size, const lti::dpoint& delta,
         const lti::ipoint& subgrid_size, const lti::dpoint& subgrid_delta);

    Grid(std::istream& in);

    // Destructor
    virtual ~Grid();

    const lti::ipoint size() const;

    const lti::dpoint delta() const;

    const lti::ipoint subgrid_size() const;

    const lti::dpoint subgrid_delta() const;

    const lti::ipoint& origin() const;

    const lti::ipoint pixel_size() const;

    void move(const lti::ipoint& dist);

    // SUBGRID METHODS

    const lti::ipoint subgrid_pixel_size() const;

    const lti::ipoint subgrid_origin(int row, int column) const;

    const lti::ipoint subgrid_node(int row, int column,
                                  const lti::ipoint& coord) const;

    const lti::ipoint subgrid_node(int row, int column,
                                  int subgrid_row, int subgrid_column) const;

    void subgrid_move(int row, int column, const lti::ipoint& dist);

    int subgrid_count() const;

    // SPOT METHODS

    const lti::ipoint spot_center(int row, int column,
                                 int subgrid_row, int subgrid_column) const;

    const lti::ipoint spot_origin(int row, int column,
                                 int subgrid_row, int subgrid_column) const;

    const lti::ipoint spot_origin(int index) const;

    int spot_count() const;

    void load(std::istream& in);

    void save(std::ostream& out) const;
 
  private:
    lti::ipoint m_size;
    lti::dpoint m_delta;

    lti::ipoint m_subgrid_size;
    lti::dpoint m_subgrid_delta;

    lti::ipoint m_origin;

    std::vector< lti::ipoint > m_subgrid_origins;
};

#endif // INCLUDED_GRID_HPP
