// $Id: hexconverter.cpp,v 1.1 2005/02/18 10:26:43 grosskur Exp $
//
// Copyright (C) 2003 Alan Grosskurth
//
// This file is part of Spatter.
//
// Spatter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Spatter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Spatter; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#include "hexconverter.hpp"

#include <string>
#include <sstream>
#include <algorithm>


static char
binarygroup_to_hexdigit(const std::string& group)
{
    char result;

    if (group == "0000") result = '0';
    else if (group == "0001") result = '1';
    else if (group == "0010") result = '2';
    else if (group == "0011") result = '3';
    else if (group == "0100") result = '4';
    else if (group == "0101") result = '5';
    else if (group == "0110") result = '6';
    else if (group == "0111") result = '7';
    else if (group == "1000") result = '8';
    else if (group == "1001") result = '9';
    else if (group == "1010") result = 'a';
    else if (group == "1011") result = 'b';
    else if (group == "1100") result = 'c';
    else if (group == "1101") result = 'd';
    else if (group == "1110") result = 'e';
    else if (group == "1111") result = 'f';
    else result = 'x';

    return result;    
}


static std::string
hexdigit_to_binarygroup(char digit)
{
    std::string result;

    if (digit == '0') result = "0000";
    else if (digit == '1') result = "0001";
    else if (digit == '2') result = "0010";
    else if (digit == '3') result = "0011";
    else if (digit == '4') result = "0100";
    else if (digit == '5') result = "0101";
    else if (digit == '6') result = "0110";
    else if (digit == '7') result = "0111";
    else if (digit == '8') result = "1000";
    else if (digit == '9') result = "1001";
    else if (digit == 'a') result = "1010";
    else if (digit == 'b') result = "1011";
    else if (digit == 'c') result = "1100";
    else if (digit == 'd') result = "1101";
    else if (digit == 'e') result = "1110";
    else if (digit == 'f') result = "1111";
    else result = "xxxx";

    return result;
}


namespace spatter {

std::string
binary_to_hex(const std::string& str)
{
    std::string result;
    int offset = str.length() % 4;
    int padding = 4 - offset;

    std::string first_group;
    for (int i = 0; i < padding; ++i) {
        first_group += "0";
    }
    first_group += str.substr(0, offset);
    result += binarygroup_to_hexdigit(first_group);

    for (unsigned int i = offset; i < str.length(); i += 4) {
        result += binarygroup_to_hexdigit(str.substr(i, 4));
    }

    return result;
}

std::string
hex_to_binary(const std::string& str)
{
    std::string result;

    for (std::string::const_iterator pos = str.begin();
         pos != str.end(); ++pos) {    
        result += hexdigit_to_binarygroup(*pos);
    }

    return result;
}

} // namespace spatter
