// $Id: spatter-grid-adjustcoarse.cpp,v 1.1 2005/02/18 10:26:43 grosskur Exp $
//
// Copyright (C) 2003 Alan Grosskurth
//
// This file is part of Spatter.
//
// Spatter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Spatter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Spatter; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#include <iostream>
#include <string>
#include <limits>

#include <ltiALLFunctor.h>
#include <ltiImage.h>

#include "arraygeometry.hpp"
#include "grid.hpp"
#include "gridder.hpp"
#include "spattertool.hpp"


int
main(int argc, char** argv)
{
    SpatterTool tool("spatter-grid-adjustcoarse",
                     "geometryfile",
                     "gridfile",
                     "imagefile");

    if (!tool.parse_arguments(argc, argv)) {
        return 0;
    }

    // Load the input data
    ArrayGeometry geo;
    if (tool.input_fname().empty()) {
        geo.load(std::cin);
    } else {
        std::ifstream in(tool.input_fname().c_str());
        geo.load(in);
    }
    Grid grid(geo.size, geo.delta, geo.subgrid_size, geo.subgrid_delta);

    try {
        // Load the image data
        lti::loadImage loader;
        lti::image img;
        loader.load(tool.image_fname(), img);

        // Run the tool
        spatter::grid_adjust_coarse(img, grid);
    } catch (lti::exception& exp) {
        std::cerr << "An lti::exception was thrown: "
                  << exp.what() << std::endl;
        return 1;
    } catch (std::exception& exp) {
        std::cerr << "std::exception was thrown: "
                  << exp.what() << std::endl;
        return 1;
    } catch (...) {
        std::cerr << "Unknown exception thrown!"
                  << std::endl;
        return 1;
    }

    // Save the output data
    if (tool.output_fname().empty()) {
        grid.save(std::cout);
    } else {
        std::ofstream out(tool.output_fname().c_str());
        grid.save(out);
    }

    return 0;
}
