// $Id: spatter-spotviewer.cpp,v 1.1 2005/02/18 10:26:43 grosskur Exp $
//
// Copyright (C) 2003 Alan Grosskurth
//
// This file is part of Spatter.
//
// Spatter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Spatter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Spatter; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#include <iostream>
#include <string>
#include <limits>

#include <ltiALLFunctor.h>
#include <ltiImage.h>
#include <ltiRGBPixel.h>

#include "spotlist.hpp"
#include "spotviewer.hpp"
#include "spattertool.hpp"


int
main(int argc, char** argv)
{
    SpatterTool tool("spatter-spotviewer",
                     "spotlistfile",
                     "spotimagefile",
                     "imagefile");

    if (!tool.parse_arguments(argc, argv)) {
        return 0;
    }

    // Load the input data
    SpotList spot_list;
    if (tool.input_fname().empty()) {
        spot_list.load(std::cin);
    } else {
        std::ifstream in(tool.input_fname().c_str());
        spot_list.load(in);
    }

    try {
        // Load the image data
        lti::loadImage loader;
        lti::image img;
        loader.load(tool.image_fname(), img);

        // Run the tool
        SpotViewer spotviewer(lti::rgbPixel(0,255,0));
        spotviewer.apply(spot_list, img);

        // Save the output data
        std::string spotimage_fname(tool.output_fname());
        if (tool.output_fname().empty()) {
            spotimage_fname = tool.image_fname();
            std::string::size_type pos
                = spotimage_fname.find_last_of(".");
            spotimage_fname.insert(pos, "-spot");
        }
        lti::saveImage saver;
        saver.save(spotimage_fname, img);
    } catch (lti::exception& exp) {
        std::cerr << "An lti::exception was thrown: "
                  << exp.what() << std::endl;
        return 1;
    } catch (std::exception& exp) {
        std::cerr << "std::exception was thrown: "
                  << exp.what() << std::endl;
    } catch (...) {
        std::cerr << "Unknown exception thrown!"
                  << std::endl;
    }

    return 0;
}
