// $Id: spattertool.hpp,v 1.1 2005/02/18 10:26:43 grosskur Exp $
//
// Copyright (C) 2003 Alan Grosskurth
//
// This file is part of Spatter.
//
// Spatter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Spatter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Spatter; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#ifndef INCLUDED_SPATTERTOOL_HPP
#define INCLUDED_SPATTERTOOL_HPP

#include <string>

class SpatterTool {
  public:
    SpatterTool(const char* tool_name,
                const char* input_name,
                const char* output_name,
                const char* image_name);

    void print_usage() const;

    bool parse_arguments(int argc, char** argv);

    const std::string& input_fname() const;
    const std::string& image_fname() const;
    const std::string& output_fname() const;
  private:
    std::string m_tool_name;
    std::string m_input_name;
    std::string m_output_name;
    std::string m_image_name;

    std::string m_input_fname;
    std::string m_image_fname;
    std::string m_output_fname;
};

#endif // INCLUDED_SPATTERTOOL_HPP
