// $Id: spotlist.hpp,v 1.3 2005/02/25 12:22:16 grosskur Exp $
//
// Copyright (C) 2003 Alan Grosskurth
//
// This file is part of Spatter.
//
// Spatter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Spatter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Spatter; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#ifndef INCLUDED_SPOTLIST_HPP
#define INCLUDED_SPOTLIST_HPP

#include <fstream>
#include <vector>
#include <ltiPoint.h>
#include <ltiMatrix.h>

class Spot {
  public:
    Spot(const lti::ipoint& origin, const lti::imatrix& mask);

    const lti::ipoint& origin() const;
    const lti::imatrix& mask() const;
    const lti::ipoint size() const;
    const lti::ipoint center() const;

  private:
    lti::ipoint m_origin;
    lti::imatrix m_mask;
};

class SpotList {
  public:
    SpotList();
    SpotList(std::istream& in);

    void load(std::istream& in);
    void save(std::ostream& out);

    std::vector< Spot > spots;
};

#endif // INCLUDED_SPOTLIST_HPP
