// $Id: spotter.cpp,v 1.2 2005/02/25 11:42:48 grosskur Exp $
//
// Copyright (C) 2003 Alan Grosskurth
//
// This file is part of Spatter.
//
// Spatter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Spatter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Spatter; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#include "grid.hpp"
#include "spotlist.hpp"
#include "spotter.hpp"

#include <ltiMeanShiftSegmentation.h>
#include <ltiKMeansSegmentation.h>
#include <ltiCsPresegmentation.h>
#include <ltiRegionGrowing.h>

#if 0
static lti::imatrix
spot_mean_shift(const lti::image& img_in)
{
    lti::image img_out;

    lti::meanShiftSegmentation mss;
    lti::meanShiftSegmentation::parameters param;
//    param.option = 0;
//    param.speedup = lti::meanShiftSegmentation::parameters::NoSpeedup;
    mss.setParameters(param);
    mss.apply(img_in, img_out);

    lti::imatrix mat_out(img_out.rows(), img_out.columns(), 0);

    for (int r = 0; r < img_out.rows(); ++r) {
        for (int c = 0; c < img_out.columns(); ++c) {
            mat_out[r][c] = img_out[r][c].getRed();
        }
    }

    int out_max = mat_out.maximum();

    for (int r = 0; r < img_out.rows(); ++r) {
        for (int c = 0; c < img_out.columns(); ++c) {
            if (mat_out[r][c] == out_max) {
                mat_out[r][c] = 1;
            } else {
                mat_out[r][c] = 0;
            }
        }
    }

    return mat_out;
}


static lti::imatrix
spot_kmeans(const lti::image& img_in)
{
    lti::image img_out;
    lti::imatrix mat_out(img_out.rows(), img_out.columns(), 0);

    lti::kMeansSegmentation kms;
    lti::kMeansSegmentation::parameters param;
    param.quantParameters.numberOfColors = 2;
    kms.setParameters(param);
    kms.apply(img_in, mat_out);

    int out_max = mat_out.maximum();

    for (int r = 0; r < img_out.rows(); ++r) {
        for (int c = 0; c < img_out.columns(); ++c) {
            if (mat_out[r][c] == out_max) {
                mat_out[r][c] = 1;
            } else {
                mat_out[r][c] = 0;
            }
        }
    }

#if 0
    if (mat_out.getRow(0).productOfElements() == 1
        || mat_out.getRow(mat_out.lastRow()).productOfElements() == 1
        || mat_out.getColumnCopy(0).productOfElements() == 1
        || mat_out.getColumnCopy(mat_out.lastColumn()).productOfElements()
        == 1) {
        lti::imatrix ones(mat_out.rows(), mat_out.columns(), 1);
        mat_out = ones.subtract(mat_out);
    }
#endif

    return mat_out;
}


static lti::imatrix
spot_cs_pre(const lti::image& img_in)
{
    lti::channel8 img_out;

    lti::csPresegmentation cs_pre;
    lti::csPresegmentation::parameters param;
    param.quantParameters.numberOfColors = 2;
    cs_pre.setParameters(param);
    cs_pre.apply(img_in, img_out);

    lti::imatrix mat_out(img_out.rows(), img_out.columns(), 0);

    for (int r = 0; r < img_out.rows(); ++r) {
        for (int c = 0; c < img_out.columns(); ++c) {
            mat_out[r][c] = img_out[r][c];
        }
    }

    int out_max = mat_out.maximum();

    for (int r = 0; r < img_out.rows(); ++r) {
        for (int c = 0; c < img_out.columns(); ++c) {
            if (mat_out[r][c] == out_max) {
                mat_out[r][c] = 1;
            } else {
                mat_out[r][c] = 0;
            }
        }
    }

    return mat_out;
}
#endif

static lti::imatrix
spot_srg(const lti::image& img_in)
{
    lti::channel8 img_out;

    lti::regionGrowing srg;
    lti::regionGrowing::parameters param;
#if 0
    param.useGaussKernel = true;            // use a gaussian kernel 5x5
    param.localStatisticsKernelSize = 5;
    param.localStatisticsKernelVariance = -1;

    param.mode = lti::regionGrowing::parameters::UseGivenThresholds;
    param.averageThresholds = trgbPixel<float>(0.05,0.05,0.05);
    param.edgesThreshold = 0.04;
#endif
    srg.setParameters(param);
    srg.apply(img_in, img_out);

    lti::imatrix mat_out(img_out.rows(), img_out.columns(), 0);

    for (int r = 0; r < img_out.rows(); ++r) {
        for (int c = 0; c < img_out.columns(); ++c) {
            mat_out[r][c] = img_out[r][c];
        }
    }

    int out_max = mat_out.maximum();

    for (int r = 0; r < img_out.rows(); ++r) {
        for (int c = 0; c < img_out.columns(); ++c) {
            if (mat_out[r][c] == out_max) {
                mat_out[r][c] = 1;
            } else {
                mat_out[r][c] = 0;
            }
        }
    }

    return mat_out;
}


namespace spatter {

void
spotlist_find(const Grid& grid,
              const lti::image& image,
              SpotList& spot_list)
{
    for (int r = 0; r < grid.size()[0]; ++r) {
        for (int c = 0; c < grid.size()[1]; ++c) {
            for (int i = 0; i < grid.subgrid_size()[0]; ++i) {
                for (int j = 0; j < grid.subgrid_size()[1]; ++j) {
                    lti::image spot_patch(
                        image,
                        grid.spot_origin(r, c, i, j)[0],
                        (int)(grid.spot_origin(r, c, i, j)[0]
                              + grid.subgrid_delta()[0] - 1),
                        grid.spot_origin(r, c, i, j)[1],
                        (int)(grid.spot_origin(r, c, i, j)[1]
                              + grid.subgrid_delta()[1] - 1));

//                    lti::imatrix spot_mask = spot_mean_shift(spot_patch);
//                    lti::imatrix spot_mask = spot_cs_pre(spot_patch);
                    lti::imatrix spot_mask = spot_srg(spot_patch);
#if 0
                    if (spot_mask.minimum() == spot_mask.maximum()) {
                        spot_mask = kmeans(spot_patch);
                    }
#endif
                    spot_list.spots.push_back(
                        Spot(grid.spot_origin(r, c, i, j), spot_mask));
                }
            }
            std::cerr << r*grid.size()[1] + c + 1
                      << " of "
                      << grid.size()[0]*grid.size()[1]
                      << " grids segmented"
                      << std::endl;
        }
    }
}

} // namespace spatter
