;; Provides a convenient way to access localized messages for this
;; application

;; Copyright (C) 2004  Sylvain Beucler
;; Copyright (C) 2004  Julien Charles
;; Copyright (C) 2004  Pierre Chtel
;; Copyright (C) 2004  Cyril Rodas

;; This file is part of SpcialK.

;; SpcialK is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2 of the License, or
;; (at your option) any later version.

;; SpcialK is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SpcialK; if not, write to the Free Software Foundation,
;; Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

(module l10n mzscheme
  (provide localized-message)
  (require (lib "29.ss" "srfi")) ; l10n
  (require (lib "file.ss"))      ; (get-preference)
  

  ;; Application name
  (define app-name 'specialk)

  ;; Convenient procedure to get localized string. Automatically
  ;; apply's (format) on the string using the optional
  ;; arguments. Defaults to english if no localization if found.
  (define (localized-message message-name . args)
    (define (get-msg)
      (let ([localized-message (localized-template app-name message-name)])
	(or localized-message
	    (let ((cur-lang (current-language)))
	      (current-language 'en)
	      (let ([localized-message (localized-template app-name message-name)])
		(current-language cur-lang)
		(or localized-message))))))
    (let ([msg (get-msg)])
      (if msg
	  (apply format (cons msg args))
	  #f)))

  ;; Checks DrScheme's language and set the default language to that value
  (current-language (case (get-preference 'plt:human-language)
		      ((spanish) 'es)
		      ((french)  'fr)
		      ((german)  'de)
		      ((dutch)   'nl)
		      ((danish)  'dk)
		      ((italian) 'it)
		      (else 'en)))

  ;; Define the translations for application "SpcialK"
  ;; To produce ASCIIzed strings (with escape sequences \ooo) just get
  ;; the result of their evaluation in DrScheme's top-level:
  ;; > "Caractere non autoris."
  ;; "Caractere non autoris\351."
  ;; This is the only portable way to get strings that works in
  ;; DrScheme v2xx and v3xx
  (let ((translations
         '([(en) .
	    (
					; Tool
	     (language-name . "Sp\351cialK")
	     (classic-name . "Sp\351cialK Classic")
	     (classic-summary . "Sp\351cialK, an anesthetizing algorithmic language")
	     (classic-options . "Sp\351cialK options")
	     (classic-executable-error-title . "Unsupported in Sp\351cialK Classic")
	     (classic-executable-error . "To create an executable, please use Sp\351cialK Light")
	     (light-name . "Sp\351cialK Light")
	     (light-summary . "Sp\351cialK, with less exec-time check")
	     (options-title . "Sp\351cialK options")
	     (option-call-internal . "jpr optimization enabled")
	     (text-mode . "Sp\351cialK mode")
					; Grammar
	     (syntaxic_error . "Syntax error before token \"~a\".") 
	     (unauthorized_char_error . "Illegal character.")
	     (fonc_args_error . "All the clauses of a function must have the same number of arguments.")
	     (fonc_name_error . "All the clauses of a function must have the same name.")
	     (internal_error . "Internal error.")
	     (invalid_pg_op_error . "Invalid operation in left part.")
	     (guard_type_error . "The guard must have a boolean type.")
	     (index_type_error . "Array subscript is not an integer.")
					; Intermediate structure
	     (_operator_ . "Operator")
	     (num_op_error . "Only applies to numerical expressions. ")
	     (int_num_op_error . "Only applies to expressions of integer type.")
	     (comp_op_error . "Only two expressions of the same type can be compared. ")
	     (bool_op_error . "Only applies to boolean expressions. ")
	     (tab_op_error . "Only applies to arrays. ")
	     (internal_error . "Erreur interne")
	     (_given_ . "Given: ")
	     (list_comp_op_error . "Only the \"==\" and \"<>\" operators can be applies to lists")
	     (tab_comp_op_error . "Only the \"==\" and \"<>\" operators can be applied to arrays")
	     (bool_comp_op_error . "Only the \"==\" and \"<>\" operators can be used on booleans")
	     (type-integer . "integer")
	     (type-real . "real")
	     (type-boolean . "boolean")
	     (type-list . "list")
	     (type-variable . "variable")
	     (type-numerical . "numerical")
	     (type-array . "array")
	     (type-string . "string")
	     (type-unknown . "unknown type")
					; Translators
	     (translator-error-bool . "~a????")
	     (translator-error-tree . "We're in troubles: error in the tree: ~a ~n")
	     (translator-undefined-function . "Function ~a/~a is undefined. Arguments were ~a.")
	     (translator-no-match . "In function ~a/~a no clause matched for ~a.")
	     (translator-non-unique-match . "In function ~a/~a ~a clauses matched for ~a.")
					; Viewers
	     (display-unknown-option . "Unknown option: ")
	     (display-bad-option . "Bad option '~a'. Should be '(<option> <number>)")
	     (display-unknown-action . "unknow action")
	     (display-unknown-message . "Unknown message: ")
	     (display-vector-title . "Vector")
	     (display-tree-title . "Tree")
	     (display-tree-error-root . "The root of any subtree must not be a list. ")
	     (process-cannot-find . "Cannot find '~a' in PATH~n")
	     (process-exit-error . "'~a' exited with an error:~n~a~n")
	     )]
	   [(fr) .
	    (
					; Tool
	     ;(language-name . "Sp\351cialK")
	     ;(classic-name . "Sp\351cialK Classic")
	     ;(classic-summary . "Sp\351cialK, an anesthetizing algorithmic language")
	     (classic-executable-error-title . "Non g\351r\351 dans Sp\351cialK Classic")
	     (classic-executable-error . "Pour cr\351er un ex\351cutable, veuillez utiliser Sp\351cialK Light")
	     ;(light-name . "Sp\351cialK Light")
	     (light-summary . "Sp\351cialK, avec moins de vrifications  l'ex\351cution")
	     (options-title . "Options de Sp\351cialK")
	     (option-call-internal . "Optimisation jpr activ\351e")
	     (text-mode . "Sp\351cialK mode")(text-mode . "Mode Sp\351cialK")
					; Grammaire
	     (syntaxic_error . "Erreur d'analyse syntaxique avant le lexme \"~a\".")
	     (unauthorized_char_error . "Caract\350re non autoris\351.")
	     (fonc_args_error . "Toutes les clauses d'une fonction doivent avoir le m\352me nombre d'arguments.")
	     (fonc_name_error . "Toutes les clauses d'une fonction doivent avoir le m\352me nom.")
	     (invalid_pg_op_error . "Op\351ration invalide en partie gauche.")
	     (guard_type_error . "La garde doit \352tre de type bool\351en.")
	     (index_type_error . "Indice d'un tableau doit \352tre de type entier.")
					; Structure intermdiaire
	     (_operator_ . "Op\351rateur")
	     (num_op_error . "Ne s'applique qu'\340 des expressions num\351riques. ")
	     (int_num_op_error . "Ne s'applique qu'\340 des expressions de type entier.")
	     (comp_op_error . "Seules deux expressions de m\352me types peuvent \352tre compar\351es. ")
	     (bool_op_error . "Ne s'applique qu'\340 des expressions bool\351ennes. ")
	     (tab_op_error . "Ne s'applique qu'\340 des tableaux. ")
	     (_given_ . "Donn\351: ")
	     (list_comp_op_error . "Seuls les op\351rateurs \"==\" et \"<>\" peuvent \352tre utilis\351s sur les listes")
	     (tab_comp_op_error . "Seuls les op\351rateurs \"==\" et \"<>\" peuvent \352tre utilis\351s sur les tableaux")
	     (bool_comp_op_error . "Seuls les op\351rateurs \"==\" et \"<>\" peuvent \352tre utilis\351s sur les bool\351ens")
	     (type-integer . "entier")
	     (type-real . "r\351el")
	     (type-boolean . "bool\351en")
	     (type-list . "liste")
	     (type-variable . "variable")
	     (type-numerical . "num\351rique")
	     (type-array . "tableau")
	     (type-string . "cha\356ne de caract\350res")
	     (type-unknown . "type inconnu")
					; Traducteurs
	     ;(translator-error-bool . "~a????")
	     (translator-error-tree . "On est mal barr\351: erreur dans l'arbre: ~a ~n")
	     (translator-undefined-function . "La fonction ~a/~a n'est pas d\351finie. Les arguments \351taient ~a.")
	     (translator-no-match . "Dans la fonction ~a/~a aucune clause ne correspond pour ~a.")
	     (translator-non-unique-match . "Dans la fonction ~a/~a ~a clauses correspondent pour ~a.")
					; Visualisateurs
	     (display-unknown-option . "option non reconnue: ")
	     (display-bad-option . "Mauvaise option '~a'. Ce devait \352tre '(<option> <nombre>)")
	     (display-unknown-action . "action non reconnue")
	     (display-unknown-message . "Message inconnu: ")
	     (display-vector-title . "Vecteur")
	     (display-tree-title . "Arbre")
	     (display-tree-error-root . "La racine d'un sous-arbre ne doit pas \352tre une liste. ")
	     (process-cannot-find . "'~a' introuvable dans le PATH~n")
	     (process-exit-error . "'~a' s'est termin par une erreur:~n~a~n")
	     )])))
    (for-each (lambda (translation)
                (let ((bundle-name (cons app-name (car translation))))
                  (declare-bundle! bundle-name (cdr translation))))
              translations))
  )

;; This file contains some code based on the example given in SRFI 29.
;; http://srfi.schemers.org/srfi-29/srfi-29.html
;; Here is the original copyright notice:

;; Copyright (C) Scott G. Miller (2002). All Rights Reserved.

;; This document and translations of it may be copied and furnished to
;; others, and derivative works that comment on or otherwise explain it
;; or assist in its implementation may be prepared, copied, published and
;; distributed, in whole or in part, without restriction of any kind,
;; provided that the above copyright notice and this paragraph are
;; included on all such copies and derivative works. However, this
;; document itself may not be modified in any way, such as by removing
;; the copyright notice or references to the Scheme Request For
;; Implementation process or editors, except as needed for the purpose of
;; developing SRFIs in which case the procedures for copyrights defined
;; in the SRFI process must be followed, or as required to translate it
;; into languages other than English.

;; The limited permissions granted above are perpetual and will not be
;; revoked by the authors or their successors or assigns.

;; This document and the information contained herein is provided on an
;; "AS IS" basis and THE AUTHOR AND THE SRFI EDITORS DISCLAIM ALL
;; WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO ANY
;; WARRANTY THAT THE USE OF THE INFORMATION HEREIN WILL NOT INFRINGE ANY
;; RIGHTS OR ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A
;; PARTICULAR PURPOSE.

