;; SpcialK optimizations

;; Copyright (C) 2004  Sylvain Beucler
;; Copyright (C) 2004  Julien Charles
;; Copyright (C) 2004  Pierre Chtel
;; Copyright (C) 2004  Cyril Rodas

;; This file is part of SpcialK.

;; SpcialK is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2 of the License, or
;; (at your option) any later version.

;; SpcialK is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SpcialK; if not, write to the Free Software Foundation,
;; Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

(module special-k-opt
 mzscheme
 ;<library stack>
 (provide factorization)
 (define pile-vide? null?)
 
 (define pile-vide '())
 
 (define (empiler x pile)
   (cons x pile)) 
 
 (define (sommet pile)
   (if (null? pile)
       (error "sommet : pile vide !")
       (car pile)))
 
 (define (depiler pile)
   (if (null? pile)
       (error "depiler : pile vide !")
       (cdr pile)))
 ;</library>
 
 (define (factorization L-guard)
   ;fusion of two binding lists
   (define (fusion assoc1 assoc2)
     (cond ((null? assoc1) assoc2)
           ((null? assoc2) assoc1)
           (else (if (member (car assoc1) assoc2)
                     (fusion (cdr assoc1) assoc2)
                     (fusion (cdr assoc1) (cons (car assoc1) assoc2))))))
   ;internal process
   (define (process current remaining association done)
     (if (null? remaining)
         ;end of process -> returns final association couples and renamed guards
         (list association (reverse (cons current done)))
         ;iterative process
         (let* ((factorized (factorize current remaining))
                (new-remaining (car factorized))
                (new-association (cadr factorized))
                (new-done (caddr factorized)))
           (process (car new-remaining) 
                    (cdr new-remaining) 
                    (fusion new-association association)
                    (cons new-done done)))))
   (if (pair? L-guard)
       (process (car L-guard) (cdr L-guard) '() '())
       '()))
 
 ;Factorize the content of "current" in "remaining" wich is a list of guards
 ;Returns a 3 element list with:
 ;-> processed remaining guards list 
 ;-> a list of new associations
 ;-> the processed guard
 (define (factorize current remaining)
   (define (get-ss-arbres A)
     (define (internal generator bindings)
       (let ((new (generator)))
         (if (null? new)
             bindings
             (let ((deja-vu (assoc new bindings)))
               (if deja-vu
                   (internal generator bindings)
                   (internal generator (cons (list new (gensym)) bindings)))))))
     (internal (make-gen-ss-arbre A) '()))
   
   (let ((ss-arbres (get-ss-arbres current))
         (associations '())
         (new-remaining '()))
     
     ;returns the modified guard
     (define (process-guard another-guard)
       (if (pair? another-guard)
           (let ((binding (assoc another-guard ss-arbres)))
             (if binding
                 (begin (if (not (member binding associations))
                            (set! associations (cons binding associations)))
                        (cadr binding))
                 (cons (process-guard (car another-guard)) (process-guard (cdr another-guard)))))
           another-guard))
     
     (define (process-guards remaining)  
       (if (null? remaining)
           ;final result
           (list (reverse new-remaining) associations (replace-all associations current))
           ;process the next guard
           (begin (set! new-remaining (cons (process-guard (car remaining)) new-remaining))
                  (process-guards (cdr remaining)))))
     
     (process-guards remaining)))
 
 
 
 
 ;returns the modified guard (in-this)
 (define (replace-all that in-this)
   (if (pair? in-this)
       (let ((temp (assoc in-this that)))
         (if temp
             (cadr temp)
             (cons (replace-all that (car in-this)) (replace-all that (cdr in-this)))))
       in-this))
 
 (define (make-gen-ss-arbre A)
   (let ((P (empiler A pile-vide)))
     (define (gen-ss-arbre)
       (if (pile-vide? P)
           null
           (let ((temp (sommet P)))
             (set! P (depiler P))
             (if (list? temp)
                 (begin
                   (map (lambda(x) (set! P (empiler x P)) x) (reverse (cdr temp)))
                   temp)
                 (gen-ss-arbre)))))
     gen-ss-arbre)))
 
; (factorize '(* 2 (* 3 4) (foo (* 3 4)) (bar x)) 
;            '((* 5 (bar (- (foo (* 3 4)) 3)) (bar x) (foo (* 3 4))) (/ (foo (* 3 4)) a)))

;(require special-k-opt)
;(factorization '( (* 2 (* 3 4) (foo (* 3 4)) (bar x)) (/ (foo (* 3 4)) (* 2 a)) (* 2 a) ))
;((((* 2 a) g609) ((foo (* 3 4)) g606)) ((* 2 (* 3 4) g606 (bar x)) (/ g606 g609) g609))
