#!/usr/bin/python -O
# -*- coding: iso-8859-15 -*-

##    Copyright 2012, Momme Winkelnkemper <specmate@posteo.de>
##
##    This file is part of SpecMate.
##
##    SpecMate is free software: you can redistribute it and/or modify
##    it under the terms of the GNU General Public License as published by
##    the Free Software Foundation, either version 3 of the License, or
##    (at your option) any later version.
##
##    Specmate is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##    GNU General Public License for more details.
##
##    You should have received a copy of the GNU General Public License
##    along with SpecMate.  If not, see <http://www.gnu.org/licenses/>.

"""
This Module implements the the popup windows of the "SpecMate" application.
"""

#----------------------------------------------------------------------------
# packages to import
#----------------------------------------------------------------------------
import sys,os
import copy
import time
try:
	import wx#,wxmpl
except:
	print "Please install wxPython"# and wxmpl packages!"
	sys.exit(1)
try:
	import numpy as na
except:
	print "Please install numpy!"
	sys.exit(1)
#try:
#	from matplotlib.backends.backend_wx import NavigationToolbar2Wx
#except:
#	print "Please install matplotlib package!"
#	sys.exit(1)

from specmate_datasets import specmate_singleDataset
#from specmate_menubar import specmate_menubar
from specmate_globals import *
from specmate_settings import *
#----------------------------------------------------------------------------
#----------------------------------------------------------------------------

##-----------------------------------------------------------------------------------------
## begin class "specmate_popupBaseclass"
##-----------------------------------------------------------------------------------------
#class specmate_popupBaseclass(wx.Frame):
#	"""
#	Implements basic features of "popup" windows.
#	"""
#
#	#--------------------------------------------------------------------------------
#	#--------------------------------------------------------------------------------
#	def _onOK(self,event):
#		self.parent.openPopups.pop(self.popupID)
#		self.Destroy()
#	#--------------------------------------------------------------------------------
#	#--------------------------------------------------------------------------------
#
#
#	#--------------------------------------------------------------------------------
#	#--------------------------------------------------------------------------------
#	def _onCancel(self,event):
#		self.parent.openPopups.pop(self.popupID)
#		self.Destroy()
#	#--------------------------------------------------------------------------------
#	#--------------------------------------------------------------------------------
#
#
#
#	#--------------------------------------------------------------------------------
#	#--------------------------------------------------------------------------------
#	def __init__(self,parent,id,title, **kwds):
#		"""
#		Constructor: ...
#
#		"""
#		wx.Frame.__init__(self,parent,id,title, style=wx.DEFAULT_FRAME_STYLE | wx.STAY_ON_TOP|wx.TAB_TRAVERSAL, **kwds)
#		self.Bind(wx.EVT_CLOSE,self._onCancel)
#		self.parent=parent
#		if not title in self.parent.openPopups:
#			self.parent.openPopups.append([title,self])
#		
#
#	#--------------------------------------------------------------------------------
#	#--------------------------------------------------------------------------------
##-----------------------------------------------------------------------------------------
##-----------------------------------------------------------------------------------------

#-----------------------------------------------------------------------------------------
# begin class "specmate_editNamesWindow"
#-----------------------------------------------------------------------------------------
class specmate_editNamesWindow(wx.Frame):
	"""
	Implements "popup" window to manage Name-Strings.
	"""

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onOK(self,event):
		for i in xrange(0,len(self.names)):
			self.names[i][1]=unicode(self.nameDisplays[i].GetValue())
		self.callback(self.names)
		self.parent.backend.unlock('namesAndLabels')
		self.Destroy()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------


	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onCancel(self,event):
		#self.parent.backend.restoreDataBackup()
		self.parent.backend.unlock('namesAndLabels')
		self.Destroy()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _initFrameContents(self):
		self.nameDisplays	=	[]
		horizSizers		=	[]
		mainVertSizer		= wx.BoxSizer(wx.VERTICAL)
		for i in xrange(0,len(self.names)):
			
			self.nameDisplays.append(	wx.TextCtrl(self,-1,size=(250,30),style=wx.TE_PROCESS_ENTER))#,style=wx.TE_PROCESS_ENTER)
			self.nameDisplays[i].SetValue(self.names[i][1])
			self.Bind(wx.EVT_TEXT_ENTER,self._onOK,self.nameDisplays[i])
			horizSizers.append(		wx.StaticBoxSizer(wx.StaticBox(self,label=self.names[i][0]),wx.HORIZONTAL))#|wx.ALIGN_CENTER_VERTICAL))
			horizSizers[i].Add(	self.nameDisplays[i], 1, wx.ALIGN_CENTER|wx.ALL, 5	)
			mainVertSizer.Add(horizSizers[i], 1, wx.EXPAND|wx.LEFT|wx.RIGHT, 5)
		buttonsizer = wx.BoxSizer(wx.HORIZONTAL)
  	        okbutton = wx.Button(self, wx.ID_OK, "OK")
  		cancelbutton = wx.Button(self, wx.ID_CANCEL, "Cancel")
  		buttonsizer.Add(okbutton, 0, wx.ALIGN_CENTER | wx.ALL, 5)
  		buttonsizer.Add(cancelbutton, 0, wx.ALIGN_CENTER | wx.ALL, 5)
		okbutton.Bind(wx.EVT_BUTTON, self._onOK)
 		cancelbutton.Bind(wx.EVT_BUTTON, self._onCancel)
		mainVertSizer.Add(buttonsizer)
		self.SetSizer(mainVertSizer)
		self.Fit()


	def __init__(self,parent,names,callback,id,title, **kwds):
		"""
		Constructor: ...

		"""
		self.parent=parent
		wx.Frame.__init__(self,parent,id,title, style=wx.DEFAULT_FRAME_STYLE | wx.STAY_ON_TOP|wx.TAB_TRAVERSAL, **kwds)
		self.Bind(wx.EVT_CLOSE,self._onCancel)
		self.parent.backend.lock('namesAndLabels')
		self.callback=callback
		self.names=names
		self._initFrameContents()
		self.SetTitle(title+' <'+self.parent.backend.specData.name+'>')
		self.Show()
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------

#-----------------------------------------------------------------------------------------
# begin class "specmate_exportSingleSet"
#-----------------------------------------------------------------------------------------
class specmate_exportSingleSet(wx.Frame):
	"""
	Implements "popup" window to manage Name-Strings.
	"""

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onOK(self,event):
		for i in xrange(0,len(self.names)):
			#self.names[i][1]=str(self.nameDisplays[i].GetValue())
			self.names[i][1]=unicode(self.nameDisplays[i].GetValue())
		self.callback(self.names)
		#self.parent.replot()
		#self.Destroy()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------


	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onCancel(self,event):
		self.Destroy()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _initFrameContents(self):
		self.nameDisplays	=	[]
		horizSizers		=	[]
		mainVertSizer		= wx.BoxSizer(wx.VERTICAL)
		for i in xrange(0,len(self.names)):
			#print self.names[i]	
			self.nameDisplays.append(	wx.ComboBox(self,-1,value=self.names[i][1],choices=self.names[i][2],style=wx.CB_DROPDOWN|wx.CB_READONLY))#,style=wx.TE_PROCESS_ENTER)
			#self.nameDisplays[i].SetValue(self.names[i][1])
			#self.Bind(wx.EVT_TEXT_ENTER,self._onOK,self.nameDisplays[i])
			horizSizers.append(		wx.StaticBoxSizer(wx.StaticBox(self,label=self.names[i][0]),wx.HORIZONTAL))#|wx.ALIGN_CENTER_VERTICAL))
			horizSizers[i].Add(	self.nameDisplays[i], 0, wx.ALIGN_CENTER|wx.ALL, 5	)
			mainVertSizer.Add(horizSizers[i], 1, wx.EXPAND|wx.ALL, 5)
		buttonsizer = wx.BoxSizer(wx.HORIZONTAL)
  	        okbutton = wx.Button(self, wx.ID_OK, "Export")
  		cancelbutton = wx.Button(self, wx.ID_CANCEL, "Done")
  		buttonsizer.Add(okbutton, 0, wx.ALIGN_CENTER | wx.ALL, 5)
  		buttonsizer.Add(cancelbutton, 0, wx.ALIGN_CENTER | wx.ALL, 5)
		okbutton.Bind(wx.EVT_BUTTON, self._onOK)
 		cancelbutton.Bind(wx.EVT_BUTTON, self._onCancel)
		mainVertSizer.Add(buttonsizer)
		self.SetSizer(mainVertSizer)
		self.Fit()


	def __init__(self,parent,names,callback,id,title, **kwds):
		"""
		Constructor: ...

		"""
		wx.Frame.__init__(self,parent,id,title, style=wx.DEFAULT_FRAME_STYLE | wx.STAY_ON_TOP|wx.TAB_TRAVERSAL, **kwds)
		self.Bind(wx.EVT_CLOSE,self._onCancel)
		self.callback=callback
		self.names=names
		self.parent=parent
		self._initFrameContents()
		self.SetTitle(title+' <'+self.parent.backend.specData.name+'>')
		self.Show()
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
# begin class "specmate_ComboboxWindow"
#-----------------------------------------------------------------------------------------
class specmate_comboboxWindow(wx.Frame):
	"""
	Implements "popup" window to manage Name-Strings.
	"""

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onOK(self,event):
		for i in xrange(0,len(self.names)):
			#self.names[i][1]=str(self.nameDisplays[i].GetValue())
			self.names[i][1]=unicode(self.nameDisplays[i].GetValue())
		self.callback(self.names)
		#self.parent.replot()
		#self.Destroy()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------


	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onCancel(self,event):
		self.Destroy()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _initFrameContents(self):
		self.nameDisplays	=	[]
		horizSizers		=	[]
		mainVertSizer		= wx.BoxSizer(wx.VERTICAL)
		for i in xrange(0,len(self.names)):
			#print self.names[i]	
			self.nameDisplays.append(	wx.ComboBox(self,-1,value=self.names[i][1],choices=self.names[i][2],style=wx.CB_DROPDOWN|wx.CB_READONLY))#,style=wx.TE_PROCESS_ENTER)
			#self.nameDisplays[i].SetValue(self.names[i][1])
			#self.Bind(wx.EVT_TEXT_ENTER,self._onOK,self.nameDisplays[i])
			horizSizers.append(		wx.StaticBoxSizer(wx.StaticBox(self,label=self.names[i][0]),wx.HORIZONTAL))#|wx.ALIGN_CENTER_VERTICAL))
			horizSizers[i].Add(	self.nameDisplays[i], 0, wx.ALIGN_CENTER|wx.ALL, 5	)
			mainVertSizer.Add(horizSizers[i], 1, wx.EXPAND|wx.ALL, 5)
		buttonsizer = wx.BoxSizer(wx.HORIZONTAL)
  	        okbutton = wx.Button(self, wx.ID_OK, "Export")
  		cancelbutton = wx.Button(self, wx.ID_CANCEL, "Done")
  		buttonsizer.Add(okbutton, 0, wx.ALIGN_CENTER | wx.ALL, 5)
  		buttonsizer.Add(cancelbutton, 0, wx.ALIGN_CENTER | wx.ALL, 5)
		okbutton.Bind(wx.EVT_BUTTON, self._onOK)
 		cancelbutton.Bind(wx.EVT_BUTTON, self._onCancel)
		mainVertSizer.Add(buttonsizer)
		self.SetSizer(mainVertSizer)
		self.Fit()


	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def __init__(self,parent,names,callback,id,title, **kwds):
		"""
		Constructor: ...

		"""
		wx.Frame.__init__(self,parent,id,title, style=wx.DEFAULT_FRAME_STYLE | wx.STAY_ON_TOP|wx.TAB_TRAVERSAL, **kwds)
		self.Bind(wx.EVT_CLOSE,self._onCancel)
		self.callback=callback
		self.names=names
		self.parent=parent
		self._initFrameContents()
		self.SetTitle(title+' <'+self.parent.backend.specData.name+'>')
		self.Show()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------

#-----------------------------------------------------------------------------------------
# begin class "specmate_refWindow"
#-----------------------------------------------------------------------------------------
class specmate_refWindow(wx.Frame):
	"""
	Implements "popup" window to manage the different references.
	"""

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onSomethingChanged(self,refNum=0):
		if self.coeff[refNum] > RAISE_UPPER_LIMIT_AT*self.maxCoeff[refNum]:
			self.maxCoeff[refNum]=2.0*self.coeff[refNum]	
		if self.coeff[refNum] < LOWER_UPPER_LIMIT_AT*self.maxCoeff[refNum]:
			if not self.coeff[refNum]==0.0:
				self.maxCoeff[refNum]=2.0*self.coeff[refNum]
		if float(self.coeffDisplays[refNum].GetValue())!=self.coeff[refNum]:
			self.coeffDisplays[refNum].SetValue('%.4g' % (self.coeff[refNum]))
		if (self.minCoeff[refNum]+(self.maxCoeff[refNum]-self.minCoeff[refNum])*float(self.sliders[refNum].GetValue())/SLIDER_RES)!=self.coeff[refNum]:
			self.sliders[refNum].SetValue(self.coeff[refNum]*SLIDER_RES/(self.maxCoeff[refNum]-self.minCoeff[refNum])-self.minCoeff[refNum])
		self.parent.backend.updateReference(refNum,self.coeff[refNum],self.maxCoeff[refNum],self.minCoeff[refNum],self.name[refNum],True)
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onSliderMovement(self,event):
		refNum=self.sliderIds.index(event.GetId())
		self.coeff[refNum]=self.minCoeff[refNum]+(self.maxCoeff[refNum]-self.minCoeff[refNum])*float(self.sliders[refNum].GetValue())/SLIDER_RES
		self._onSomethingChanged(refNum)
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onTextChange(self,event):
		refNum=self.coeffDisplayIds.index(event.GetId())
		self.coeff[refNum]=float(self.coeffDisplays[refNum].GetValue())
		self._onSomethingChanged(refNum)
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onRemoveButton(self,event):
		refNum=self.removeButtonIds.index(event.GetId())
        	dial = wx.MessageDialog(None, 'Sure to remove reference spectrum?', 'Question', wx.YES_NO | wx.NO_DEFAULT | wx.ICON_QUESTION)
		if dial.ShowModal()==wx.ID_YES:
			self.parent.backend.deleteReference(refNum)
			self.parent.backend.unlock('references')
			self.Destroy()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onSubstractButton(self,event):
		refNum=self.substractButtonIds.index(event.GetId())
		self.parent.backend.dataBackup(['spectrum','references'])
		self.parent.backend.substractFromSpectrum('reference',refNum)
		self.parent.backend.deleteReference(refNum)
        	dial = wx.MessageDialog(None, 'Do you like the result?', 'Question', wx.YES_NO | wx.NO_DEFAULT | wx.ICON_QUESTION)
		if dial.ShowModal()==wx.ID_NO:
			self.parent.backend.restoreDataBackup()
		else:
			self.parent.backend.unlock('references')
			self.Destroy()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onOK(self,event):
		self._onSomethingChanged()
		self.parent.backend.unlock('references')
		self.Destroy()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onCancel(self,event):
		self.parent.backend.restoreDataBackup()
		self.parent.backend.unlock('references')
		self.Destroy()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _initFrameContents(self):
		#self.spinButtons	=	[]
		self.sliders		=	[]
		self.coeffDisplays	=	[]
		boxSizers		=	[]
		horizSizers		=	[]
		horizButtonSizers	=	[]
		vertSizers		=	[]
		self.removeButtons		=	[]
		self.substractButtons		=	[]
		self.removeButtonIds=[]	
		self.substractButtonIds=[]	
		self.coeffDisplayIds=[]	
		self.sliderIds=[]	
		self.substractButtonIds=[]	
		mainVertSizer		= wx.BoxSizer(wx.VERTICAL)
		for i in xrange(0,len(self.coeff)):
			self.sliders.append(		wx.Slider(self,-1,self.coeff[i]*SLIDER_RES,0,SLIDER_RES,size=(400,30),style=wx.SL_HORIZONTAL | wx.SL_AUTOTICKS))
			self.sliderIds.append(self.sliders[i].GetId())
			self.coeffDisplays.append(	wx.TextCtrl(self,-1,size=(70,30),style=wx.TE_PROCESS_ENTER))#,style=wx.TE_PROCESS_ENTER)
			self.coeffDisplayIds.append(self.coeffDisplays[i].GetId())
			self.coeffDisplays[i].SetValue("%.3f" % (self.coeff[i]))
			self.substractButtons.append(wx.Button(self,wx.ID_ANY,'Substract from Spectrum'))
			self.removeButtons.append(wx.Button(self,wx.ID_ANY,'Delete Reference'))
			self.removeButtonIds.append(self.removeButtons[i].GetId())
			self.substractButtonIds.append(self.substractButtons[i].GetId())

			self.Bind(wx.EVT_SCROLL_THUMBRELEASE, self._onSliderMovement,self.sliders[i])	
			self.Bind(wx.EVT_TEXT_ENTER,self._onTextChange,self.coeffDisplays[i])
			self.Bind(wx.EVT_BUTTON,self._onRemoveButton,self.removeButtons[i])
			self.Bind(wx.EVT_BUTTON,self._onSubstractButton,self.substractButtons[i])

			boxSizers.append(		wx.StaticBoxSizer(wx.StaticBox(self,label="Ref. Spec. %d: %s" % (i+1,self.name[i])),wx.VERTICAL|wx.ALIGN_LEFT))#|wx.ALIGN_CENTER_VERTICAL))
			horizSizers.append(		wx.BoxSizer(wx.HORIZONTAL))#|wx.ALIGN_CENTER_VERTICAL))
			horizButtonSizers.append(		wx.BoxSizer(wx.HORIZONTAL))#|wx.ALIGN_CENTER_VERTICAL))
			horizSizers[i].Add(	self.sliders[i], 1, wx.ALIGN_CENTER|wx.EXPAND|wx.ALL, 5	)
			horizSizers[i].Add(	self.coeffDisplays[i], 0, wx.ALIGN_CENTER|wx.ALL, 5	)
			horizButtonSizers[i].Add(	self.substractButtons[i], 0, wx.ALIGN_LEFT|wx.ALL, 5	)
			horizButtonSizers[i].Add(	self.removeButtons[i], 0, wx.ALIGN_RIGHT|wx.ALL, 5	)
			boxSizers[i].Add(horizSizers[i],1,wx.ALIGN_LEFT,5)
			boxSizers[i].Add(horizButtonSizers[i],1,wx.ALIGN_LEFT,5)
			mainVertSizer.Add(boxSizers[i], 1, wx.ALIGN_LEFT|wx.LEFT|wx.RIGHT,5)
		buttonsizer = wx.BoxSizer(wx.HORIZONTAL)
  	        okbutton = wx.Button(self, wx.ID_OK, "OK")
  		cancelbutton = wx.Button(self, wx.ID_CANCEL, "Cancel")
  		buttonsizer.Add(okbutton, 0, wx.ALIGN_CENTER | wx.ALL, 5)
  		buttonsizer.Add(cancelbutton, 0, wx.ALIGN_CENTER | wx.ALL, 5)
		okbutton.Bind(wx.EVT_BUTTON, self._onOK)
 		cancelbutton.Bind(wx.EVT_BUTTON, self._onCancel)
		mainVertSizer.Add(buttonsizer)
		self.SetSizer(mainVertSizer)
		self.Fit()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------


	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def __init__(self,parent,id,title, **kwds):
		"""
		Constructor: ...

		"""
		wx.Frame.__init__(self,parent,id,title, style=wx.DEFAULT_FRAME_STYLE | wx.STAY_ON_TOP|wx.TAB_TRAVERSAL, **kwds)
		self.parent=parent
		self.Bind(wx.EVT_CLOSE,self._onCancel)
		self.parent.backend.lock('references')

		self.coeff=[]
		self.maxCoeff=[]
		self.minCoeff=[]
		self.name=[]
		for each in self.parent.backend.refSpectra:
			self.coeff.append(each.coeff)
			self.maxCoeff.append(each.maxCoeff)
			self.minCoeff.append(each.minCoeff)
			self.name.append(each.name)
		self._initFrameContents()
		self.SetTitle(title+' <'+self.parent.backend.specData.name+'>')
		self.Show()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------

