#!/usr/bin/python -O
# -*- coding: iso-8859-15 -*-

##    Copyright 2012, Momme Winkelnkemper <specmate@posteo.de>
##
##    This file is part of SpecMate.
##
##    SpecMate is free software: you can redistribute it and/or modify
##    it under the terms of the GNU General Public License as published by
##    the Free Software Foundation, either version 3 of the License, or
##    (at your option) any later version.
##
##    Specmate is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##    GNU General Public License for more details.
##
##    You should have received a copy of the GNU General Public License
##    along with SpecMate.  If not, see <http://www.gnu.org/licenses/>.

import wx
from math import sqrt
"""
This Module implements the popup window for "Add Peak".
"""

#from glade_classes.addPeakWindow import specmate_addPeakWindow_template
from modPeakWindow_template2 import specmate_modPeakWindow_template


#------------------------------------------------------------------------------------------------------------------------
#------------------------------------------------------------------------------------------------------------------------
class specmate_modPeakWindow(specmate_modPeakWindow_template):
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def __init__(self,parent, id,title,*args, **kwds):
		"""
		Constructor: ...
		@param parent: parent window, which has to be a specmate_mainWindow-instance.
		@type parent: wx.Frame
		"""
		self.parent=parent
		specmate_modPeakWindow_template.__init__(self,parent,style=wx.DEFAULT_FRAME_STYLE | wx.STAY_ON_TOP|wx.TAB_TRAVERSAL)
		##the following lines ...
		self.choicePeak.Delete(0)
		self.choicePeak.Delete(0)
		for i in xrange(0,len(parent.backend.peakSpectra)):
			self.choicePeak.Append('Peak %d' % (i+1))
		##----------------------------
		self.peak=len(parent.backend.peakSpectra)-1
		self.loadData()
		self.setCtrls()	
		self.Bind(wx.EVT_CLOSE,self._onCancel)#we have to catch it, if someone closes the window 
		self.parent.backend.lock('peaks')
		self.SetTitle(title+' <'+self.parent.backend.specData.name+'>')
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def loadData(self):
		"""
		
		"""
		self.x0=self.parent.backend.peakSpectra[self.peak].x0
		self.y0=self.parent.backend.peakSpectra[self.peak].y0
		self.FWHM=self.parent.backend.peakSpectra[self.peak].FWHM
		self.shape=self.parent.backend.peakSpectra[self.peak].shape
		self.peakTypes=self.parent.backend.peakSpectra[self.peak].peakTypes
		self.peakType=self.parent.backend.peakSpectra[self.peak].peakType
		self.name=self.parent.backend.peakSpectra[self.peak].name
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def setCtrls(self):
		self.textCtrlPos.SetValue("%1.2e" % (self.x0))
		self.textCtrlAmp.SetValue("%1.2e" % (self.y0))
		self.textCtrlFWHM.SetValue("%1.2e" % (self.FWHM))
		self.textCtrlShape.SetValue("%1.3f" % (self.shape))
		self.textCtrlName.SetValue(self.name)
		self.choicePeakType.SetStringSelection(self.peakType)
		self.choicePeak.SetSelection(self.peak)
		self.textCtrlFWHMLorentz.SetValue("%1.2e" % (self.shape*self.FWHM))
		if self.shape>0.99999:
			self.textCtrlFWHMGauss.SetValue("%1.2e" % (0.0))
		else:
			self.textCtrlFWHMGauss.SetValue("%1.2e" % (sqrt(((self.FWHM-0.5346*self.shape*self.FWHM)**2)-0.2166*(self.shape*self.FWHM)**2)))
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onPeakSelected(self, event):  
		self.peak=self.choicePeak.GetSelection()
		self.loadData()
		self.setCtrls()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onSomethingChanged(self, event):  
		self.x0=float(self.textCtrlPos.GetValue())
		self.y0=float(self.textCtrlAmp.GetValue())
		self.FWHM=float(self.textCtrlFWHM.GetValue())
		self.shape=float(self.textCtrlShape.GetValue())
		self.name=unicode(self.textCtrlName.GetValue())
		self.peakType=self.peakTypes[self.choicePeakType.GetSelection()]
		if ((self.peakType=='gaussian') and (self.shape!=0.0)):
			self.shape=0.0
		elif ((self.peakType=='lorentzian') and (self.shape!=1.0)):
			self.shape=1.0
		elif self.shape<0.0:
			self.shape=0.0
		elif self.shape>1.0:
			self.shape=1.0
		if self.FWHM<0.0:
			self.FWHM=0.0
		self.setCtrls()
		self.parent.backend.modifyPeak(self.peak,self.x0,self.y0,self.FWHM,self.shape,self.peakType,self.name)
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def receiver(self,x,y):
	    	if self.toggleButtonGetPosAmp.GetValue()==True:
	    		self.x0=x
			self.y0=y
			#self.toggleButtonGetPosAmp.SetValue(False)
		elif self.toggleButtonGetFWHM.GetValue()==True:
			self.FWHM=2.0*abs(self.x0-x)
			#self.toggleButtonGetFWHM.SetValue(False)
		self.setCtrls()
		self.parent.backend.modifyPeak(self.peak,self.x0,self.y0,self.FWHM,self.shape,self.peakType,self.name)
		#self.parent.mouseClickReceiver="None"
	    #--------------------------------------------------------------------------------
	    #--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onGetPosButton(self, event):  # wxGlade: specmate_addPeakWindow.<event_handler>
		if self.toggleButtonGetPosAmp.GetValue()==True:
			self.toggleButtonGetFWHM.SetValue(False)
	    		self.parent.mouseClickReceiver=self.receiver
		else:
			self.parent.mouseClickReceiver="None"
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onGetFWHMButton(self, event):  # wxGlade: specmate_addPeakWindow.<event_handler>
		if self.toggleButtonGetFWHM.GetValue()==True:
			self.toggleButtonGetPosAmp.SetValue(False)
	    		self.parent.mouseClickReceiver=self.receiver
		else:
			self.parent.mouseClickReceiver="None"
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onOK(self, event):  # wxGlade: specmate_addPeakWindow.<event_handler>
		self.parent.mouseClickReceiver="None"
		self.parent.backend.unlock('peaks')
	    	self.Destroy()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onCancel(self, event):  # wxGlade: specmate_addPeakWindow.<event_handler>
		self.parent.backend.restoreDataBackup()
		self.parent.mouseClickReceiver="None"
		self.parent.backend.unlock('peaks')
		self.Destroy()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onRemove(self, event):  # wxGlade: specmate_addPeakWindow.<event_handler>
        	dial = wx.MessageDialog(None, 'Really delete this peak?', 'Question', wx.YES_NO | wx.NO_DEFAULT | wx.ICON_QUESTION)
		if dial.ShowModal()==wx.ID_YES:
			self.parent.backend.deletePeak(self.peak)
			if len(self.parent.backend.peakSpectra)>0:
				self.peak=len(self.parent.backend.peakSpectra)-1
				self.loadData()
				self.setCtrls()
			else:
				self.parent.backend.unlock('peaks')
				self.parent.mouseClickReceiver="None"
	    			self.Destroy()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onAdd(self, event):
		self.parent.backend.addPeak()
		self.peak=len(self.parent.backend.peakSpectra)-1
		self.loadData()
		self.setCtrls()
#------------------------------------------------------------------------------------------------------------------------
#------------------------------------------------------------------------------------------------------------------------
