#!/usr/bin/python -O
# -*- coding: iso-8859-15 -*-

##    Copyright 2012, Momme Winkelnkemper <specmate@posteo.de>
##
##    This file is part of SpecMate.
##
##    SpecMate is free software: you can redistribute it and/or modify
##    it under the terms of the GNU General Public License as published by
##    the Free Software Foundation, either version 3 of the License, or
##    (at your option) any later version.
##
##    Specmate is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##    GNU General Public License for more details.
##
##    You should have received a copy of the GNU General Public License
##    along with SpecMate.  If not, see <http://www.gnu.org/licenses/>.

#----------------------------------------------------------------------------
# packages to import
#----------------------------------------------------------------------------
import sys,os
import copy
import time
try:
	import wx
except:
	print "Please install wxPython!"
	sys.exit(1)

#from specmate_globals import *
from specmate_globals import appName,version,developers,description,copyright,license_long
#----------------------------------------------------------------------------
#----------------------------------------------------------------------------

#-----------------------------------------------------------------------------------------
# begin class "specmate_Menubar"
#-----------------------------------------------------------------------------------------
class specmate_menubar(wx.Frame):
	"""
	This class implements the menubar of the application without any functionality added to it, except for "Quit" and "About". To add functionality in a derived class overwrite the methods "_onMenu*(self,event)".
	"""
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuQuit(self,event):
		"""
		Ask if sure to quit, then quit.
		"""
        	dial = wx.MessageDialog(None, 'Sure to close window?\nUnsaved data will be lost!', 'Question', wx.YES_NO | wx.NO_DEFAULT | wx.ICON_QUESTION)
		if dial.ShowModal()==wx.ID_YES:
			self.Destroy()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuNew(self,event):
		print "Menu: New button pressed!"
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuDuplicate(self,event):
		print "Menu: Duplicate button pressed!"
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuNew(self,event):
		print "Menu: New button pressed!"
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuOpen(self,event):
		print "Menu: Open button pressed!"
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuSave(self,event):
		print "Menu: Save button pressed!"
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onReadSpectrum(self,event):
		print "Menu: Read Spectrum button pressed!"
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuShiftSpectrum(self,event):
		print "Menu: Shift Spectrum button pressed!"
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuExportDataset(self,event):
		print "Menu: Export Dataset pressed!"
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuExportAllDatasets(self,event):
		print "Menu: Export All dataset pressed!"
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuPrint(self,event):
		print "Menu: Print button pressed!"
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuAddRef(self,event):
		print "Menu: Add reference clicked!"
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuEditRefNames(self,event):
		print "Menu: Edit reference names clicked!"
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuManageRef(self,event):
		print "Menu: Manage references clicked!"
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuAddPeak(self,event):
		print "Menu: Add Peak clicked!"
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuManagePeaks(self,event):
		#print event.GetId()
		print "Menu: Manage Peaks clicked!"
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuAddFunction(self,event):
		print "Menu: Add Function clicked!"
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuManageFunctions(self,event):
		#print event.GetId()
		print "Menu: Manage Functions clicked!"
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuPreview(self,event):
		print "Menu: Preview button pressed!"
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuNamesAndLabels(self,event):
		print "Menu: Names and Labels button pressed!"
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuCreateBackground(self,event):
		print "Menu: Add Baseline clicked!"
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuDeleteBackground(self,event):
		print "Menu: Clear Baseline clicked!"
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuSubstractBackground(self,event):
		print "Menu: Substract Baseline clicked!"
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuExportBGPoints(self,event):
		print "Menu: Export BG Points clicked!"
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuExportBGLine(self,event):
		print "Menu: Export BG (Interpolated) clicked!"
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuImportBGPoints(self,event):
		print "Menu: Import BG Points clicked!"
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuStartFit(self,event):
		print "Menu: Start Fit not implemented, yet!"
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	##--------------------------------------------------------------------------------
	##--------------------------------------------------------------------------------
	#def _onMenuAbout(self,event):
	#	"""
	#	Display information about application"
	#	"""
	#	message_string="%s\nVersion: %s\n\n%s\n\nAuthor: %s\n<%s>\n\n%s\nLicense: %s" % (appName,version,description,author,email,copyright,license)
	#	dialog=wx.MessageBox(message_string, 'Info', 
        #    wx.OK | wx.ICON_INFORMATION)
	##--------------------------------------------------------------------------------
	##--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuAbout(self,event):
		"""
		Display information about this version of SpecMate
		"""
		dialog = wx.AboutDialogInfo()

		#dialog.SetIcon(wx.Icon('hunter.png', wx.BITMAP_TYPE_PNG))
		dialog.SetName(appName)
		dialog.SetVersion(version)
		dialog.SetDescription(description)
		dialog.SetCopyright(copyright)
		#dialog.SetWebSite('http://www.x.yy')
		#f=open('LICENSE','r')
		#license=unicode(f.readlines())
		dialog.SetLicence(license_long)
		for eachDeveloper in developers:
			dialog.AddDeveloper(eachDeveloper)
		wx.AboutBox(dialog)
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _createWindowMenu(self):
		"""
		Create the window menu.

		@return: windowMenu 
		@rtype: wx.Menu()
		"""
		
		windowMenu	=	wx.Menu()

        	windowMenu.Append(wx.ID_NEW, 'Open &New Window')
        	item_duplicateWindow=windowMenu.Append(wx.ID_ANY, 'Duplicate Window')
        	windowMenu.Append(wx.ID_EXIT, '&Close Window')

		self.Bind(wx.EVT_MENU, self._onMenuNew, id=wx.ID_NEW)
		self.Bind(wx.EVT_MENU, self._onMenuQuit, id=wx.ID_EXIT)
		self.Bind(wx.EVT_MENU, self._onMenuDuplicate, item_duplicateWindow)
		
		return(windowMenu)
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _createFileMenu(self):
		"""
		Create the file menu.

		@return: fileMenu 
		@rtype: wx.Menu()
		"""
		
		fileMenu	=	wx.Menu()

		##menuItems for fileMenu
		#item_openRef	=	fileMenu.Append(wx.ID_ANY, 'Open &Reference')
		#accel_tbl = wx.AcceleratorTable([(wx.ACCEL_CTRL,  ord('R'), ID_OPEN_REF)])
        	#self.SetAcceleratorTable(accel_tbl)
        	#item_readSpectrum	=	fileMenu.Append(wx.ID_ANY, 'Open Spectrum ...')
        	fileMenu.Append(wx.ID_OPEN, '&Open Project')
        	fileMenu.Append(wx.ID_SAVE, '&Save Project')
        	fileMenu.Append(wx.ID_NEW, 'Open &New Window')
        	item_duplicateWindow=fileMenu.Append(wx.ID_ANY, 'Duplicate Window')
        	fileMenu.Append(wx.ID_EXIT, '&Close Window')
        	item_exportDataset=fileMenu.Append(wx.ID_ANY, '&Export Single Dataset ...')
        	item_exportAllDatasets=fileMenu.Append(wx.ID_ANY, 'Export All Datasets ...')
        	#fileMenu.AppendItem(menuItemQuit)

		##Binds for fileMenu
		#self.Bind(wx.EVT_MENU, self._onMenuReadSpectrum, item_readSpectrum)
		self.Bind(wx.EVT_MENU, self._onMenuNew, id=wx.ID_NEW)
		self.Bind(wx.EVT_MENU, self._onMenuQuit, id=wx.ID_EXIT)
		self.Bind(wx.EVT_MENU, self._onMenuOpen, id=wx.ID_OPEN)
		self.Bind(wx.EVT_MENU, self._onMenuSave, id=wx.ID_SAVE)
		self.Bind(wx.EVT_MENU, self._onMenuExportDataset, item_exportDataset)
		self.Bind(wx.EVT_MENU, self._onMenuExportAllDatasets, item_exportAllDatasets)
		self.Bind(wx.EVT_MENU, self._onMenuDuplicate, item_duplicateWindow)
		return(fileMenu)
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _createSpectrumMenu(self):
		"""
		Create the 'Spectrum' menu.

		@return: specMenu 
		@rtype: wx.Menu()
		"""
		
		specMenu	=	wx.Menu()

        	item_readSpectrum	=	specMenu.Append(wx.ID_ANY, 'Open Spectrum ...')
        	item_shiftSpectrum	=	specMenu.Append(wx.ID_ANY, 'Shift X-Axis ...')
		item_namesAndLabels	=	specMenu.Append(wx.ID_ANY, 'Set Names and Labels ...', '...')
		
		self.Bind(wx.EVT_MENU, self._onMenuReadSpectrum, item_readSpectrum)
		self.Bind(wx.EVT_MENU, self._onMenuShiftSpectrum, item_shiftSpectrum)
		self.Bind(wx.EVT_MENU, self._onMenuNamesAndLabels, item_namesAndLabels)
		
		return(specMenu)
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _createRefMenu(self):
		"""
		Create the references menu.

		@return: refMenu 
		@rtype: wx.Menu()
		"""
		refMenu	=	wx.Menu()
		##menuItems for refsMenu
		item_addReference	=	refMenu.Append(wx.ID_ANY, 'Add reference spectrum ...', 'Add a new reference spectrum.')
		#item_editRefNames	=	refMenu.Append(wx.ID_ANY, 'Edit reference names ...', 'Edit names of reference spectra.')
		item_manageReference	=	refMenu.Append(wx.ID_ANY, 'Manage references ...', 'Manage reference spectra already added.')
		##Binds for refsMenu
		self.Bind(wx.EVT_MENU, self._onMenuAddRef, item_addReference)
		#self.Bind(wx.EVT_MENU, self._onMenuEditRefNames, item_editRefNames)
		self.Bind(wx.EVT_MENU, self._onMenuManageRef, item_manageReference)
		return(refMenu)
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	##--------------------------------------------------------------------------------
	##--------------------------------------------------------------------------------
	#def _createSpectrumMenu(self):
	#	"""
	#	Create the spectrum menu.

	#	@return: spectrumMenu 
	#	@rtype: wx.Menu()
	#	"""
	#	spectrumMenu	=	wx.Menu()
	#	##menuItems for refsMenu
        #	item_readSpectrum=spectrumMenu.Append(wx.ID_ANY, 'Open Spectrum ...')
	#	##Binds for refsMenu
	#	self.Bind(wx.EVT_MENU, self._onMenuReadSpectrum, item_readSpectrum)
	#	return(spectrumMenu)
	##--------------------------------------------------------------------------------
	##--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _createPeakMenu(self):
		"""
		Create the peaks menu.

		@return: peakMenu 
		@rtype: wx.Menu()
		"""
		peakMenu	=	wx.Menu()
		##menuItems for refsMenu
		item_addPeak		=	peakMenu.Append(wx.ID_ANY, 'Add Peak ...', 'Add a new peak to plot.')
		item_managePeaks	=	peakMenu.Append(wx.ID_ANY, 'Manage Peaks ...', 'Manage peaks in plot.')
		##Binds for refsMenu
		self.Bind(wx.EVT_MENU, self._onMenuAddPeak, item_addPeak)
		self.Bind(wx.EVT_MENU, self._onMenuManagePeaks, item_managePeaks)
		return(peakMenu)
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _createFunctionMenu(self):
		"""
		Create the peaks menu.

		@return: peakMenu 
		@rtype: wx.Menu()
		"""
		functionMenu	=	wx.Menu()
		##menuItems for refsMenu
		item_addFunction	=	functionMenu.Append(wx.ID_ANY, 'Add User Function ...', 'Add a new user function to plot.')
		item_manageFunctions	=	functionMenu.Append(wx.ID_ANY, 'Manage Functions ...', 'Manage user functions in plot.')
		##Binds for refsMenu
		self.Bind(wx.EVT_MENU, self._onMenuAddFunction, item_addFunction)
		self.Bind(wx.EVT_MENU, self._onMenuManageFunctions, item_manageFunctions)
		return(functionMenu)
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _createGraphMenu(self):
		"""
		Create the graph menu.

		@return: graphMenu 
		@rtype: wx.Menu()
		"""
		graphMenu	=	wx.Menu()
		##menuItems for graphMenu
		item_namesAndLabels	=	graphMenu.Append(wx.ID_ANY, 'Set Names and Labels ...', '...')
		#item_printPreview	=	graphMenu.Append(wx.ID_ANY, 'Print Preview', '...')
		#item_printGraph=graphMenu.Append(wx.ID_ANY, '&Print Graph', 'Print the Graph')
		#graphMenu.Append(wx.ID_PRINT, '&Print Graph')
		##Binds for graphMenu
		#self.Bind(wx.EVT_MENU, self._onMenuPrint, id=wx.ID_PRINT)
		#self.Bind(wx.EVT_MENU, self._onMenuPreview, item_printPreview)
		self.Bind(wx.EVT_MENU, self._onMenuNamesAndLabels, item_namesAndLabels)
		return(graphMenu)
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _createBackgroundMenu(self):
		"""
		Create the background menu.

		@return: backgroundMenu 
		@rtype: wx.Menu()
		"""
		backgroundMenu	=	wx.Menu()
		##menuItems for backgroundMenu
		item_createBackground	=	backgroundMenu.Append(wx.ID_ANY, 'Add/Edit Baseline ...', '...')
		item_deleteBackground	=	backgroundMenu.Append(wx.ID_ANY, 'Clear Baseline ...', '...')
		item_substractBackground=	backgroundMenu.Append(wx.ID_ANY, 'Substract Baseline from Spectrum ...', '...')
		item_exportBGPoints	=	backgroundMenu.Append(wx.ID_ANY, 'Export Baseline (Points) ...', '...')
		item_exportBGLine	=	backgroundMenu.Append(wx.ID_ANY, 'Export Baseline (Interpolated) ...', '...')
		item_importBGPoints	=	backgroundMenu.Append(wx.ID_ANY, 'Import Baseline (Points) ...', '...')
		##Binds for backgroundMenu
		self.Bind(wx.EVT_MENU, self._onMenuExportBGPoints, item_exportBGPoints)
		self.Bind(wx.EVT_MENU, self._onMenuImportBGPoints, item_importBGPoints)
		self.Bind(wx.EVT_MENU, self._onMenuExportBGLine, item_exportBGLine)
		self.Bind(wx.EVT_MENU, self._onMenuCreateBackground, item_createBackground)
		self.Bind(wx.EVT_MENU, self._onMenuDeleteBackground, item_deleteBackground)
		self.Bind(wx.EVT_MENU, self._onMenuSubstractBackground, item_substractBackground)
		return(backgroundMenu)
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _createFitMenu(self):
		"""
		Create the fit menu.

		@return: fitMenu 
		@rtype: wx.Menu()
		"""
		fitMenu	=	wx.Menu()
		item_startFit		=	fitMenu.Append(wx.ID_ANY, 'Start Fit ...', 'Open the fit dialog.')
		self.Bind(wx.EVT_MENU, self._onMenuStartFit, item_startFit)
		return(fitMenu)
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------


	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _createHelpMenu(self):
		"""
		Create the help menu.

		@return: helpMenu 
		@rtype: wx.Menu()
		"""
		helpMenu	=	wx.Menu()
		##menuItems for helpMenu
		item_about	=	helpMenu.Append(wx.ID_ANY, 'About...', '...')
		##Binds for helpMenu
		self.Bind(wx.EVT_MENU, self._onMenuAbout, item_about)
		return(helpMenu)
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#Constructor
	#--------------------------------------------------------------------------------
	def __init__(self,parent,id,title, **kwds):
		"""
		Constructor: create all menus, then the menubar.
		"""

		wx.Frame.__init__(self,parent,id,title, **kwds)
		
		menubar		=	wx.MenuBar()
		#menubar.Append(self._createWindowMenu(), '&Window')
		menubar.Append(self._createFileMenu(), '&File')
		menubar.Append(self._createSpectrumMenu(), '&Spectrum')
		menubar.Append(self._createPeakMenu(), '&Peaks')
		menubar.Append(self._createRefMenu(), '&References')
		menubar.Append(self._createBackgroundMenu(), '&Baseline')
		#menubar.Append(self._createFunctionMenu(), 'F&unctions')
		menubar.Append(self._createFitMenu(), 'F&it')
		#menubar.Append(self._createGraphMenu(), '&Graph')
		menubar.Append(self._createHelpMenu(), '&Help')
		self.SetMenuBar(menubar)
		self.Bind(wx.EVT_CLOSE,self._onMenuQuit)
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------

