#!/usr/bin/python -O
# -*- coding: iso-8859-15 -*-

##    Copyright 2012, Momme Winkelnkemper <specmate@posteo.de>
##
##    This file is part of SpecMate.
##
##    SpecMate is free software: you can redistribute it and/or modify
##    it under the terms of the GNU General Public License as published by
##    the Free Software Foundation, either version 3 of the License, or
##    (at your option) any later version.
##
##    Specmate is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##    GNU General Public License for more details.
##
##    You should have received a copy of the GNU General Public License
##    along with SpecMate.  If not, see <http://www.gnu.org/licenses/>.

import wx
"""
This Module implements the popup window for "Shift Spectrum".
"""

#from glade_classes.addPeakWindow import specmate_addPeakWindow_template
from shiftWindow_template import shiftXWindow
from specmate_settings import DEFAULT_EXP_FORMAT


#------------------------------------------------------------------------------------------------------------------------
#------------------------------------------------------------------------------------------------------------------------
class specmate_shiftSpectrumWindow(shiftXWindow):
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def __init__(self,parent, id,title,*args, **kwds):
		"""
		Constructor: ...
		@param parent: parent window, which has to be a specmate_mainWindow-instance.
		@type parent: wx.Frame
		"""
		self.parent=parent
		shiftXWindow.__init__(self,parent,style=wx.DEFAULT_FRAME_STYLE | wx.STAY_ON_TOP|wx.TAB_TRAVERSAL)
		self.Bind(wx.EVT_CLOSE,self._onCancel)#we have to catch it, if someone closes the window 
		self.parent.backend.lock('spectrum')
		self.SetTitle(title+' <'+self.parent.backend.specData.name+'>')
		self.shiftTextCtrl.SetValue(DEFAULT_EXP_FORMAT % (self.parent.backend.specData.xShift))
		self.parent.mouseClickReceiver=self.receiver
		self.firstClick=True
		self.startX=0.0
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	
	##--------------------------------------------------------------------------------
	##--------------------------------------------------------------------------------
	def receiver(self,x,y):
		if self.firstClick:
			self.startX=x
			self.firstClick=False
		else:
			self.parent.backend.shiftSpectrum(self.parent.backend.specData.xShift+x-self.startX)
			self.shiftTextCtrl.SetValue(DEFAULT_EXP_FORMAT % (self.parent.backend.specData.xShift))
			self.firstClick=True
	##--------------------------------------------------------------------------------
	##--------------------------------------------------------------------------------

	##--------------------------------------------------------------------------------
	##--------------------------------------------------------------------------------
    	def _onSliderChanged(self, event):  # wxGlade: shiftXWindow.<event_handler>
    	    	print "Event handler `_onSliderChanged' not implemented!"
    	    	event.Skip()
	##--------------------------------------------------------------------------------
	##--------------------------------------------------------------------------------

	##--------------------------------------------------------------------------------
	##--------------------------------------------------------------------------------
    	def _onTextChanged(self, event):  # wxGlade: shiftXWindow.<event_handler>
		try:
			newShift=float(self.shiftTextCtrl.GetValue())
		except:
			self.shiftTextCtrl.SetValue(DEFAULT_EXP_FORMAT % (self.parent.backend.specData.xShift))
			print "Couldn't process input!"
			return
		self.parent.backend.shiftSpectrum(newShift)
	##--------------------------------------------------------------------------------
	##--------------------------------------------------------------------------------
	
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onOK(self, event):  # wxGlade: specmate_addPeakWindow.<event_handler>
		self._onTextChanged(event)
		self.parent.mouseClickReceiver="None"
		self.parent.backend.unlock('spectrum')
	    	self.Destroy()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onCancel(self, event):  # wxGlade: specmate_addPeakWindow.<event_handler>
		self.parent.backend.restoreDataBackup()
		self.parent.mouseClickReceiver="None"
		self.parent.backend.unlock('spectrum')
		self.Destroy()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

#------------------------------------------------------------------------------------------------------------------------
#------------------------------------------------------------------------------------------------------------------------
