/* Sprite32 - small, cross-platform sprite library
 * Copyright (c) 1996-2003 Jeffrey T. Read
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __SPRITEIMAGE_H
#define __SPRITEIMAGE_H

typedef struct tagSpriteImage {
  unsigned int cx;
  unsigned int cy;
  unsigned int depth;
  unsigned int scan_length;
  unsigned int endian;
  void *bits;
  void *img;
} SpriteImage;

void ImageCopy(SpriteImage *,SpriteImage *,int,int,int,int,int,int,long);

void ImageCopyFlipped(SpriteImage *,SpriteImage *,int,int,int,int,int,int,long);

void ImageCopyMirrored(SpriteImage *,SpriteImage *,int,int,int,int,int,int,long);

#endif
