/* Sprite32 - small, cross-platform sprite library
 * Copyright (c) 1996-2003 Jeffrey T. Read
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <sprite32/sprite.h>
#include <X11/Xlib.h>
#include <stdio.h>
#include <stdlib.h>

/* This function is becoming frustratingly hard to decode. :) 

This is our primary blitter. Messy, isn't it? The guts of it are supposed to
work across rendering targets. Here are the params:

SpriteImage   *si1:   source image
SpriteImage   *si2:   destination image
int          sx,sy:   upper left corner of section of source image to copy
int            x,y:   upper left corner of destination rectangle
int          cx,cy:   size of rectangle
int          flags:   flags (not sure what to do with these yet)
long           key:   key color for transparency
                      (typically the upper left corner of a sprite)
*/
void ImageCopy(SpriteImage *si1,SpriteImage *si2,int sx,int sy,int x,int y,int cx,int cy,int flags, long key) {
    int startx,starty,endx,endy;
    int dx = si2->cx;
    int dy = si2->cy;
    int g = 0;
    char *s = (char *)si1->bits;
    char *d = (char *)si2->bits;
    char *p;
    char *r;
    char *q = (char *)&key;

    int i,j;
    int b = (si1->depth + 7) / 8;
    startx = sx; starty = sy;
    endx = sx + cx; endy = sy + cy;
    if(x < 0) {
      if(x+cx < 0) return;
      startx = sx - x;
    }
    if(y < 0) {
      if(y + cy < 0) return;
      starty = sy - y;
    }
    if(x + cx - 1 >= dx) {
      if(x >= dx) return;
      endx = x + cx - dx;
      endx = cx + sx - endx;
    }
    if(y + cy - 1 >= dy) {
      if(y >= dy) return;
      endy = y + cy - dy;
      endy = cy + sy - endy;
    }
#ifdef __NOT_DEFINED__
      AsmImageCopy((void *)s,(void *)d,x + startx - sx,y + starty - sy,startx,starty,endx - startx,endy - starty,b,si1->scan_length,si2->scan_length,key);
#else
      if(flags & SIMG_USE_KEY) {
	switch(b) {
	case 1:
	  for(j=starty;j<endy;j++) {
	    p = s + ((j * si1->scan_length) + startx * b);
	    r = d + (((((int)y + j - sy) * si2->scan_length) + 
		      ((startx - sx + (int)x) * b)));
	    for(i=startx;i<endx;i++) {
	      if(*((char *)p) != *((char *)q)) {
		*r = *p;
	      }
	      r++; p++;
	    }
	  }
	  break;
	case 2:
	  for(j=starty;j<endy;j++) {
	    p = s + ((j * si1->scan_length) + startx * b);
	    r = d + (((((int)y + j - sy) * si2->scan_length) + 
		      ((startx - sx + (int)x) * b)));
	    for(i=startx;i<endx;i++) {
	      if(*((short *)p) != *((short *)q)) {
		*((short *)r) = *((short *)p);
	      }
	      r++; p++;
	      r++; p++;
	    }
	  }
	  break;
	case 3:
	  for(j=starty;j<endy;j++) {
	    
	    p = s + ((j * si1->scan_length) + startx * b);
	    r = d + (((((int)y  + j - sy) * si2->scan_length) + 
		      ((startx - sx + (int)x) * b)));
	    
	    for(i=startx;i<endx;i++) {
	      if((*p != *q) && (*(p+1) != *(q+1)) && (*(p+2) != *(q+2))) {
		r[0] = p[0];
		r[1] = p[1];
		r[2] = p[2];
	      }
	      p++; r++;
	      p++; r++;
	      p++; r++;
	    }
	  }
	  break;
	case 4:
	  for(j=starty;j<endy;j++) {
	    
	    p = s + ((j * si1->scan_length) + startx * b);
	    r = d + (((((int)y  + j - sy) * si2->scan_length) + 
		      ((startx - sx + (int)x) * b)));
	    
	    for(i=startx;i<endx;i++) {
	      
	      if(*((long *)p) != *((long *)q)) {
		*((long *)r) = *((long *)p);
	      }
	      p++; r++;
	      p++; r++;
	      p++; r++;
	      p++; r++;
	    }
	  }
	  break;
	default:
	  fprintf(stderr,"error: nonstandard bpp %d\n",b);
	  exit(1);
	}
      }
      else {
	switch(b) {
	case 1:
	  for(j=starty;j<endy;j++) {
	    p = s + ((j * si1->scan_length) + startx * b);
	    r = d + (((((int)y + j - sy) * si2->scan_length) + 
		      ((startx - sx + (int)x) * b)));
	    for(i=startx;i<endx;i++) {
	      *r = *p;
	      r++; p++;
	    }
	  }
	  break;
	case 2:
	  for(j=starty;j<endy;j++) {
	    p = s + ((j * si1->scan_length) + startx * b);
	    r = d + (((((int)y + j - sy) * si2->scan_length) + 
		      ((startx - sx + (int)x) * b)));
	    for(i=startx;i<endx;i++) {
	      *((short *)r) = *((short *)p);
	      r++; p++;
	      r++; p++;
	    }
	  }
	  break;
	case 3:
	  for(j=starty;j<endy;j++) {
	    
	    p = s + ((j * si1->scan_length) + startx * b);
	    r = d + (((((int)y  + j - sy) * si2->scan_length) + 
		      ((startx - sx + (int)x) * b)));
	    
	    for(i=startx;i<endx;i++) {
	      r[0] = p[0];
	      r[1] = p[1];
	      r[2] = p[2];
	      p++; r++;
	      p++; r++;
	      p++; r++;
	    }
	  }
	  break;
	case 4:
	  for(j=starty;j<endy;j++) {
	    
	    p = s + ((j * si1->scan_length) + startx * b);
	    r = d + (((((int)y  + j - sy) * si2->scan_length) + 
		      ((startx - sx + (int)x) * b)));
	    
	    for(i=startx;i<endx;i++) {
	      
	      *((long *)r) = *((long *)p);
	      p++; r++;
	      p++; r++;
	      p++; r++;
	      p++; r++;
	    }
	  }
	  break;
	default:
	  fprintf(stderr,"error: nonstandard bpp %d\n",b);
	  exit(1);
	}
      }
#endif
}

#if 0
void ImageCopyMirrored(SpriteImage *si1,SpriteImage *si2,int sx,int sy,int x,int y,int cx,int cy,long key) {
    XImage *xi1 = (XImage *)si1->img;
    XImage *xi2 = (XImage *)si2->img;
    int startx,starty,endx,endy,_cx,_cy;
    int dx = xi2->width;
    int dy = xi2->height;
    int g = 0;
    char *s = xi1->data;
    char *d = xi2->data;
    int b = xi1->bits_per_pixel / 8;
    startx = sx; starty = sy;
    endx = sx + cx; endy = sy + cy;
    if(x < 0) {
      if(x+cx < 0) return;
      startx = sx - x;
    }
    if(y < 0) {
      if(y + cy < 0) return;
      starty = sy - y;
    }
    if(x + cx - 1 >= dx) {
      if(x >= dx) return;
      endx = x + cx + sx - dx;
      endx = cx  - endx;
    }
    if(y + cy - 1 >= dy) {
      if(y >= dy) return;
      endy = y + cy+ sy - dy;
      endy = cy - endy;
    }
    void *q = &key;
    _cx = endx - startx - 1;
    _cy = endy - starty - 1;
    switch(b) {
    case 1:
      for(int i=startx;i<endx;i++) {
	for(int j=starty;j<endy;j++) {
	  char *p = s + ((j * xi1->bytes_per_line) + (cx - 1 - i) * b);
	  if(*((char *)p) != *((char *)q))
	    memcpy(d + (((((int)y + j) * xi2->bytes_per_line) + 
			 ((i + (int)x) * b))),p,b);
	}
      }
      break;
    case 2:
      for(int i=startx;i<endx;i++) {
	for(int j=starty;j<endy;j++) {
	  char *p = s + ((j * xi1->bytes_per_line) + (cx - 1 - i) * b);
	  if(*((short *)p) != *((short *)q))
	    memcpy(d + (((((int)y + j) * xi2->bytes_per_line) + 
			 ((i + (int)x) * b))),p,b);
	}
      }
      break;
    case 4:
      for(int i=startx;i<endx;i++) {
	for(int j=starty;j<endy;j++) {
	  char *p = s + ((j * xi1->bytes_per_line) + (cx - 1 - i) * b);
	  if(*((long *)p) != *((long *)q))
	    memcpy(d + (((((int)y + j) * xi2->bytes_per_line) + 
			 ((i + (int)x) * b))),p,b);
	}
      }
      break;
    default:
      fprintf(stderr,"error: nonstandard bpp %d\n",b);
      exit(1);
    }
}

void ImageCopyFlipped(SpriteImage *si1,SpriteImage *si2,int sx,int sy,int x,int y,int cx,int cy,long key) {
    XImage *xi1 = (XImage *)si1->img;
    XImage *xi2 = (XImage *)si2->img;
    int startx,starty,endx,endy,_cx,_cy;
    int dx = xi2->width;
    int dy = xi2->height;
    int g = 0;
    char *s = xi1->data;
    char *d = xi2->data;
    int b = xi1->bits_per_pixel / 8;
    startx = sx; starty = sy;
    endx = sx + cx; endy = sy + cy;
    if(x < 0) {
      if(x+cx < 0) return;
      startx = sx - x;
    }
    if(y < 0) {
      if(y + cy < 0) return;
      starty = sy - y;
    }
    if(x + cx - 1 >= dx) {
      if(x >= dx) return;
      endx = x + cx + sx - dx;
      endx = cx  - endx;
    }
    if(y + cy - 1 >= dy) {
      if(y >= dy) return;
      endy = y + cy + sy - dy;
      endy = cy - endy;
    }
    _cx = endx - startx - 1;
    _cy = endy - starty - 1;
    void *q = &key;
    switch(b) {
    case 1:
      for(int i=startx;i<endx;i++) {
	for(int j=starty;j<endy;j++) {
	  char *p = s + ((j * xi1->bytes_per_line) + i * b);
	  if(*((char *)p) != *((char *)q))
	    memcpy(d + (((((int)y + _cy - j) * xi2->bytes_per_line) + 
			 ((i + (int)x) * b))),p,b);
	}
      }
      break;
    case 2:
      for(int i=startx;i<endx;i++) {
	for(int j=starty;j<endy;j++) {
	  char *p = s + ((j * xi1->bytes_per_line) + i * b);
	  if(*((short *)p) != *((short *)q))
	    memcpy(d + (((((int)y + _cy - j) * xi2->bytes_per_line) + 
			 ((i + (int)x) * b))),p,b);
	}
      }
      break;
    case 4:
      for(int i=startx;i<endx;i++) {
	for(int j=starty;j<endy;j++) {
	  char *p = s + ((j * xi1->bytes_per_line) + i * b);
	  if(*((long *)p) != *((long *)q))
	    memcpy(d + (((((int)y + _cy - j) * xi2->bytes_per_line) + 
			 ((i + (int)x) * b))),p,b);
	}
      }
      break;
    default:
      fprintf(stderr,"error: nonstandard bpp %d\n",b);
      exit(1);
    }
}
#endif
