/* Sprite32 - small, cross-platform sprite library
 * Copyright (c) 1996-2003 Jeffrey T. Read
 * Some functions copyright (c) 2000 Gerd Knorr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <stdio.h>
#include <sprite32/svppm.h>

#define RED8(x) ((x >> 5) << 5)
#define GRN8(x) ((x >> 5) << 2)
#define BLU8(x) (x >> 6)

#define RED15(x) ((x >> 3) << 10)
#define GRN15(x) ((x >> 3) << 5)
#define BLU15(x) (x >> 3)

#define RED16(x) ((x >> 3) << 11)
#define GRN16(x) ((x >> 2) << 5)
#define BLU16(x) (x >> 3)

#define RED32(x) (x << 16)
#define GRN32(x) (x << 8)
#define BLU32(x) (x)

void ReadPpmAsRgba(char *ppmname,int *wret,int *hret,unsigned char **rgbret) {
  FILE *fp;
  char *ppmbuf,*p,*r;
  int cx,cy,i,t;
  struct stat st;
  stat(ppmname,&st);
  fp = fopen(ppmname,"r");
  if(!fp) {
error:
    *wret = 0;
    *hret = 0;
    *rgbret = NULL;
    return;
  }
  ppmbuf = (char *)malloc(st.st_size);
  fgets(ppmbuf,st.st_size,fp);
  if(sscanf(ppmbuf,"P%d",&t) < 1) goto error;
  if(t < 5) goto error;
  for(;;) {
    fgets(ppmbuf,st.st_size,fp);
    if(ppmbuf[0] == '#' || ppmbuf[0] == '\n') continue;
    break;
  }
  sscanf((char *)ppmbuf,"%d%d",&cx,&cy);
  *wret = cx;
  *hret = cy;
  fgets(ppmbuf,st.st_size,fp);
#ifdef __LJBAD_DEBUG
  printf("%d %d\n",cx,cy);
#endif /* __LJBAD_DEBUG */
  fread(ppmbuf,3,cx*cy,fp);
  p = ppmbuf;
  r = (char *)malloc(cx * cy * 4);
  *rgbret = (unsigned char *)r;
  for(i=0;i < cx * cy;i++) {
    *r = *p;
    r++; p++;
    *r = *p;
    r++; p++;
    *r = *p;
    r++; p++;
    *r = 0xff;
    r++;
  }
  fclose(fp);
  free(ppmbuf);
}


void ReadPpmAsRgb(char *ppmname,int *wret,int *hret,unsigned char **rgbret) {
  FILE *fp;
  char *ppmbuf,*p,*r;
  int cx,cy,i,t;
  struct stat st;
  stat(ppmname,&st);
  fp = fopen(ppmname,"r");
  if(!fp) {
error:
    *wret = 0;
    *hret = 0;
    *rgbret = NULL;
    return;
  }
  ppmbuf = (char *)malloc(st.st_size);
  fgets(ppmbuf,st.st_size,fp);
  if(sscanf(ppmbuf,"P%d",&t) < 1) goto error;
  if(t < 5) goto error;
  for(;;) {
    fgets(ppmbuf,st.st_size,fp);
    if(ppmbuf[0] == '#' || ppmbuf[0] == '\n') continue;
    break;
  }
  sscanf((char *)ppmbuf,"%d%d",&cx,&cy);
  *wret = cx;
  *hret = cy;
  fgets(ppmbuf,st.st_size,fp);
#ifdef __LJBAD_DEBUG
  printf("%d %d\n",cx,cy);
#endif /* __LJBAD_DEBUG */
  fread(ppmbuf,3,cx*cy,fp);
  p = ppmbuf;
  r = (char *)malloc(cx * cy * 3);
  *rgbret = (unsigned char *)r;
  for(i=0;i < cx * cy;i++) {
    *r = *p;
    r++; p++;
    *r = *p;
    r++; p++;
    *r = *p;
    r++; p++;
  }
  fclose(fp);
  free(ppmbuf);
}

void ReadPpmRgbConverted(char *ppmname,int *wret,int *hret,unsigned char **imgret,int bpp) {
  unsigned char *rgb;
  int cx,cy;
  ReadPpmAsRgb(ppmname,wret,hret,&rgb);
  cx = *wret;
  cy = *hret;
  *imgret = TransformImage(rgb,cx,cy,0,bpp,0,wret,hret);
  free(rgb);
}

/* Cannibalized from fbi-1.7 by Gerd Knorr */
/* ---------------------------------------------------------------------- */

unsigned char *
ConvertLine(int gray, int bpp, int line, int zoom, int owidth,
	     unsigned char *dest,unsigned char *buffer)
{
    unsigned char  *ptr; 
    unsigned short *ptr2;
    unsigned long  *ptr4;
    int shift;
    unsigned char  *b;
    int in,out;

    shift = zoom + 16;
    ptr = dest;
    ptr2 = (unsigned short *)dest;
    ptr4 = (unsigned long *)dest;

    if (gray) {
      return NULL;
    } else {
	/* colors */
	switch (bpp) {
	case 8:
            b = ptr;
	    for (out = 0; out < owidth; out++) {
		in = (out << 16) >> shift;
		b[out]   = RED8(buffer[in*3]) |
		  GRN8(buffer[in*3+1]) |
		  BLU8(buffer[in*3+2]);
	    }
	    ptr += owidth;
	    return ptr;
	case 15:
	    for (out = 0; out < owidth; out++) {
		in = (out << 16) >> shift;
		ptr2[out] = RED15(buffer[in*3]) |
		    GRN15(buffer[in*3+1]) |
		    BLU15(buffer[in*3+2]);
	    }
	    ptr2 += owidth;
	    return (unsigned char*)ptr2;
	case 16:
	    for (out = 0; out < owidth; out++) {
		in = (out << 16) >> shift;
		ptr2[out] = RED16(buffer[in*3]) |
		    GRN16(buffer[in*3+1]) |
		    BLU16(buffer[in*3+2]);
	    }
	    ptr2 += owidth;
	    return (unsigned char*)ptr2;
	case 24:
	    for (out = 0; out < owidth; out++) {
		in = (out << 16) >> shift;
		ptr[3*out+2] = buffer[3*in+0];
		ptr[3*out+1] = buffer[3*in+1];
		ptr[3*out+0] = buffer[3*in+2];
	    }
	    ptr += owidth * 3;
	    return ptr;
	case 32:
	    for (out = 0; out < owidth; out++) {
		in = (out << 16) >> shift;
		ptr4[out] = RED32(buffer[in*3]) |
		    GRN32(buffer[in*3+1]) |
		    BLU32(buffer[in*3+2]);
	    }
	    ptr4 += owidth;
	    return (unsigned char*)ptr4;
	}
    }
    /* keep compiler happy */
    return NULL;
}

unsigned char *
TransformImage(unsigned char *iimage, int iwidth, int iheight, int gray,
		int bpp,
		int zoom, int *owidth, int *oheight)
{
    int in,out,inlength,outlength;
    unsigned char *ptr;
    unsigned char *image = NULL;
    int shift = zoom + 16;
    
    if (image) {
	free(image);
	image = NULL;
    }
    
    *owidth  = iwidth;
    *oheight = iheight;
    if (zoom < 0) {
	*owidth  >>= -zoom;
	*oheight >>= -zoom;
    } else {
	*owidth  <<= zoom;
	*oheight <<= zoom;
    }

    inlength  = iwidth * (gray ? 1 : 3);
    outlength = (*owidth) * ((bpp+7)/8);
    image = ptr = (unsigned char *)malloc(outlength * (*oheight));
    if (NULL != image) {
	for (out = 0; out < *oheight; out++) {
	    in = (out << 16) >> shift;
	    ptr = ConvertLine(gray, bpp, out, zoom,
			       *owidth, ptr, iimage + (in*inlength));
	}
    }
    return image;
}
