! srend_namelist.F90

! This is designed to handle cubical data volumes of dimension Vdim^3

! this file generates executable called by srend_namelist.py

! NOTE: OpenMP is optional below

! build SMP    : gfortran Srend.F90 -DSREND_NOMPI -O3 -fopenmp -c
!              : gfortran srend_namelist.F90 Srend.o -DSREND_NOMPI -O3 -fopenmp -o srend_namelist_smp

! build MPI    : mpif90 Srend.F90 -O3 -fopenmp -c
!              : gcc sleep.c -c
!              : mpif90 srend_namelist.F90 Srend.o sleep.o -O3 -fopenmp -o srend_namelist_mpi

! set threads  : export OMP_NUM_THREADS=4 ! or 1, or 2, ...

! NOTE: data generated by t_data_ipy.F90

program srend_exec_namelist

#ifdef _OPENMP
      USE OMP_LIB
#endif
      USE Srend
      
      IMPLICIT none

#ifndef SREND_NOMPI
      include 'mpif.h'
#endif

      integer :: srend_nV, srend_nV_out
      integer :: srend_Vdim
      real :: srend_E(1:3),srend_V(1:3),srend_U(1:3)
      real :: srend_Alpha,srend_Beta
      real :: srend_EyeRight
      real :: srend_clipx0,srend_clipx1,srend_clipy0
      real :: srend_clipy1,srend_clipz0,srend_clipz1
      real :: srend_pclip1
      real :: srend_pt(1:3), srend_pt_r
      real :: srend_clip0, srend_clip1
      integer :: srend_nsh
      integer :: srend_perspective, srend_srendtype
      real :: srend_dt
      character*256 :: srend_bytedata_filename ! a trailing '/' if multiple MPI blocks
      character*1,dimension(:,:,:),allocatable :: bytedata ! data array for rendering
      integer :: srend_XN, srend_YN, srend_ZN
      integer :: srend_Bd
      integer :: srend_iX, srend_iY, srend_iZ
      integer :: srend_W, srend_H
      integer :: srend_nR
      integer :: srend_cotab_offset
      character*200 :: srend_filenames
      integer :: srend_tiles_right, srend_tiles_down
!      integer,save :: srend_n_rgb_knot, srend_n_alpha_knot
!      character*256,save :: srend_alpha_knot(1:32), srend_rgb_knot(1:32)
      integer :: srend_TARGid
      
      namelist /namelist_srend/  srend_nV, srend_nV_out,   & 
            srend_Vdim, srend_E, srend_V,                  & ! Vdim^3 volume
            srend_U, srend_alpha, srend_beta,              &
            srend_eyeright,                                &
            srend_clipx0, srend_clipx1,                    &
            srend_clipy0, srend_clipy1,                    &
            srend_clipz0, srend_clipz1,                    &
            srend_pclip1, srend_pt, srend_pt_r,            &
            srend_clip0, srend_clip1,                      &
            srend_nsh, srend_perspective, srend_srendtype, &
            srend_dt,                                      &
            srend_bytedata_filename,                       &
            srend_XN, srend_YN, srend_ZN,                  & ! dimension of each block in volume, all the same
            srend_Bd,                                      & ! uniform boundary
            srend_iX, srend_iY, srend_iZ,                  & ! MPI topology: iNX*iNY*iNZ workers = MPI ranks
            srend_W, srend_H,                              &
            srend_nR, srend_cotab_offset,                  &
            srend_filenames,                               &
            srend_tiles_right, srend_tiles_down,           &
!                                srend_n_alpha_knot, srend_alpha_knot,          &
!                                srend_n_rgb_knot, srend_rgb_knot,              &
            srend_TARGid

#ifndef SREND_NOMPI
      integer :: MYer, MYid, MYn
#endif

      integer :: vdim
      integer :: xn, yn, zn, bd ! dimensions of each block and uniform boundary
      integer :: ix, iy, iz     ! workers in each direction; MYn = ix*iy*iz
      integer :: inx, iny, inz  ! offset for each block
      integer :: nx, ny, nz     ! number of blocks in each axis direction
      integer :: ibx, iby, ibz  ! starting block in each axis: 0:nx-1,0:ny-1,0:nz-1
      integer :: nbx, nby, nbz  ! number of blocks for each rank in each direction
      integer :: i,j,k          ! counters
      character*256 :: fname, fnum
      integer :: bi             ! block index
! --------------------------------------------------------------------

#ifndef SREND_NOMPI
      call MPI_INIT( MYer )
      call MPI_COMM_RANK( MPI_COMM_WORLD, MYid, MYer )
      call MPI_COMM_SIZE( MPI_COMM_WORLD, MYn, MYer )
#endif

      open(unit=20,file='namelist.srend',form='formatted',status='old',access='sequential')
      read(20,nml=namelist_srend) ! get rendering parameters
      close(20)
      
! working info for rendering
      vdim = srend_Vdim
      xn = srend_XN; yn = srend_YN; zn = srend_ZN ! dimension of block in each direction
      bd = srend_Bd                               ! boundary thickness, uniform
      ix = srend_iX; iy = srend_iY; iz = srend_iZ ! worker topology, blocks in each direction
#ifdef SREND_NOMPI
      inx = 0; iny = 0; inz = 0                     ! offsets for SMP
      ibz = 0; iby = 0; ibx = 0;
      nbz = 1; nby = 1; nbx = 1
#else
      nx = vdim/xn; ny = vdim/yn; nz = vdim/zn  ! blocks in each dimension
      nbz = nz/iz; nby = ny/iy; nbx = nx/ix     ! blocks in each axis direction per rank
      ibx = mod(MYid,ix)* nbx                   ! starting block for each dimension
      iby = (mod(MYid,ix*iy) / ix) * nby
      ibz = (MYid / (ix*iy)) * nbz
#endif
 
! allocate array to hold all blocks
      allocate( bytedata(1-bd:xn+bd,1-bd:yn+bd,1-bd:zn+bd) )
      
      do k= ibz, ibz+nbz-1
      do j= iby, iby+nby-1
      do i= ibx, ibx+nbx-1
      
! open and load data file
#ifdef SREND_NOMPI
      fname = srend_bytedata_filename ! this is ready to go
#else
      bi = k*(nx*ny) + j*(nx) + i
      write(fnum,'(I6.6)') bi
      fname = trim(srend_bytedata_filename) // trim(fnum)
      
      inz = k*zn
      iny = j*yn
      inx = i*xn
#endif
      
      open(unit=21,file=trim(fname),status='unknown',access='stream')
      read(21) bytedata
      close(21)

!$omp parallel default(shared)
      call srend_render_load(srend_nV,srend_nV_out, & ! view index: nV and nV_out
         srend_Vdim,                           & ! usually max dimension of entire volume
         srend_E,                              & ! eye
         srend_V,                              & ! Ev
         srend_U,                              & ! Up
         srend_alpha, srend_beta,              & ! alpha, beta
         srend_eyeright,                       & ! stereo right
         srend_clipx0,srend_clipx1,            & ! x plane near and far clip
         srend_clipy0,srend_clipy1,            & ! y plane near and far clip
         srend_clipz0,srend_clipz1,            & ! z plane near and far clip
         srend_pclip1,                         & ! far polar clip
         srend_pt, srend_pt_r,                 & ! center(x,y,z) and radius of sphere to clip about
         srend_clip0, srend_clip1,             & ! spherical: clip near, clip far
         srend_nsh,                            & ! nshells
         srend_perspective,srend_srendtype,    & ! perspective=1, srendtype=0
         srend_dt,                             & ! dt sampling depth in cell widths
         bytedata,                             & ! data bytes
         xn,yn,zn,                             & ! data dimensions x,y,z
         bd,                                   & ! boundary
         inx,iny,inz,                          & ! xyz offsets
         srend_W,srend_H,                      & ! W, H
         srend_nR,(/srend_cotab_offset/),      & ! number of vars to render, offsets color table
!         srend_n_alpha_knot,srend_alpha_knot,  & ! number alpha keys, and alpha keys
!         srend_n_rgb_knot,srend_rgb_knot,      & ! number rgb keys, and rgb keys
         srend_filenames,                      & ! output filenames
         srend_tiles_right,srend_tiles_down,   & ! tiling geometry
         (/srend_TARGid/) )                      ! MPI rank of target
!$omp end parallel

      end do
      end do
      end do

#ifndef SREND_NOMPI
      call srend_render_flush(srend_nV)

      if(myid == 0) call srend_finish(srend_nV_out,MYn)
      call MPI_barrier(MPI_COMM_WORLD,MYer)
      call MPI_finalize()
#else
      call srend_render_flush_write(srend_nV)
#endif


end program srend_exec_namelist


