#!/bin/bash 

# tested 2016sep27: gfortran/gcc 4.8.5 and  mpich 3.0.4/openmpi 2.0.1
#                   ifort/icc and mpich 3.0.4/openmpi 2.0.1
# This tests the "t_" test examples except for those
# that rely on external data (frog,t_python_call,orf4,t_c_call).

# >>>>>> enable Gnu or Intel choice, adjust compile flags as
# desired.  For KNL and intel, "FLAGS=-xMIC_AVX512 -O3" is one common choice.
# --- Gnu
#FC=gfortran
#CC=gcc
#FLAGS=-O3
# --- Intel
FC=ifort
CC=icc
FLAGS=-O3

# --- (MPICH || OpenMPI) && (Gnu || Intel)
# Your MPI wrappers used are in your PATH variable.  These are
# some typical locations where mpif90 and mpirun wrappers are located,
# not necessarily yours.
#   /usr/local/mpich/bin
#   /usr/local/openmpi/bin
#   /opt/intel/mpich/bin
#   /opt/intel/openmpi/bin


# increase stack size
ulimit -s unlimited

# compile Srend SMP, serial and openmp
echo :compile Srend for smp
$FC Srend.F90 -DSREND_NOMPI $FLAGS -c -o srend_smp.o
echo :compile Srend for smp and Openmp
$FC Srend.F90 -DSREND_NOMPI $FLAGS -fopenmp -c -o srend_smp_omp.o


# SMP tests
echo :build t_smp.F90 serial
$FC t_smp.F90 srend_smp.o $FLAGS -o t_smp
echo :run t_smp serial
./t_smp

echo :build t_smp.F90 openmp
$FC t_smp.F90 srend_smp_omp.o $FLAGS -fopenmp -o t_smp_omp
echo :run t_smp openmp
./t_smp_omp

echo :create data for data tests, compile t_data
$FC  t_data.F90 $FLAGS -o t_data
echo :run t_data
./t_data
echo :build t_data_smp
$FC t_data_smp.F90 srend_smp.o $FLAGS -o t_data_smp
echo :run t_data_smp
./t_data_smp

echo :build t_smp_pt
$FC t_smp_pt.F90 srend_smp.o $FLAGS -o t_smp_pt
echo :run t_smp_pt
./t_smp_pt


# MPI tests
echo :compile srend for MPI
mpif90 Srend.F90 $FLAGS -c -o srend_mpi.o
echo :compile sleep.c
$CC sleep.c -c

echo :build t_mpi_s.F90
mpif90 t_mpi_s.F90 srend_mpi.o sleep.o $FLAGS -o t_mpi_s
echo :run t_mpi_s
mpirun -np 4 ./t_mpi_s

echo :build t_mpi.F90
mpif90 t_mpi.F90 srend_mpi.o sleep.o $FLAGS -o t_mpi
echo :run t_mpi
mpirun -np 4 ./t_mpi

echo :build t_mpi_4R_1F.F90
mpif90 t_mpi_4R_1F.F90 srend_mpi.o sleep.o $FLAGS -o t_mpi_4R_1F
echo :run t_mpi_4R_1F
mpirun -np 5 ./t_mpi_4R_1F

echo :build t_mpi_4R_2C_1F.F90
mpif90 t_mpi_4R_2C_1F.F90 srend_mpi.o sleep.o $FLAGS -o t_mpi_4R_2C_1F
echo :run t_mpi_4R_2C_1F
mpirun -np 7 ./t_mpi_4R_2C_1F

# data already created for SMP test
echo :build t_data_mpi
mpif90 t_data_mpi.F90 srend_mpi.o sleep.o $FLAGS -o t_data_mpi
echo :run t_data_mpi
mpirun -np 4 ./t_data_mpi



# AMR tests
echo :compile Srend for smp-Openmp for AMRsmp tests
$FC Srend.F90 -DSREND_NOMPI -DSREND_AMR -DSREND_VALPHA="256" $FLAGS -fopenmp -c -o srend_smp_omp.o

echo :build t_AMRsmp for paramesh
$FC t_AMRsmp.F90 srend_smp_omp.o -DUSE_PARAMESH_AMR $FLAGS -fopenmp -o t_AMRsmp_paramesh
echo :run t_AMRsmp for paramesh
./t_AMRsmp_paramesh

echo :build t_AMRsmp for patch
$FC t_AMRsmp.F90 srend_smp_omp.o -DUSE_PATCH_AMR $FLAGS -fopenmp -o t_AMRsmp_patch
echo :run t_AMRsmp for patch
./t_AMRsmp_patch


echo :compile srend_tile_montage
$FC srend_tile_montage.F90 $FLAGS -o montage
echo :compile srend for MPI
mpif90 Srend.F90 -DSREND_AMR -DSREND_VALPHA="512" -DSREND_TILE_MONTAGE="0" $FLAGS -c -o srend_mpi_amr.o

echo :build t_AMRmpi for paramesh
mpif90 t_AMRmpi.F90 srend_mpi_amr.o sleep.o -DUSE_PARAMESH_AMR $FLAGS -o t_AMRmpi_paramesh
echo :run t_AMRmpi for paramesh
mpirun -np 4 ./t_AMRmpi_paramesh

echo :build t_AMRmpi for patch
mpif90 t_AMRmpi.F90 srend_mpi_amr.o sleep.o -DUSE_PATCH_AMR $FLAGS -o t_AMRmpi_patch
echo :run t_AMRmpi for patch
mpirun -np 4 ./t_AMRmpi_patch



# ATR test
echo :compile srend for MPI
mpif90 Srend.F90 -DSREND_AMR -DSREND_VALPHA="1024" -DSREND_TILE_MONTAGE="0" -DSREND_ATR -DSREND_RLE0 $FLAGS -c -o srend_mpi_atr.o
echo :build t_ATR
mpif90 t_ATR.F90 srend_mpi_atr.o sleep.o $FLAGS -o t_ATR
mpirun -np 4 ./t_ATR


# cleaup after runs, comment out exit
#exit
rm *.o
rm *.mod
rm -R Blocks000512Vdim000256
rm montage t_AMRsmp_paramesh t_AMRsmp_patch t_AMRmpi_paramesh t_AMRmpi_patch t_data_mpi t_data_smp 
rm *_1F t_mpi_s t_smp t_mpi t_smp_omp t_smp_pt t_data t_ATR
# to remove image results after runs, comment out exit
exit
rm -R r_*