! t_AMRsmp.F90
! -----------------------------------------------------------------------
! This is free and unencumbered software released into the public domain.
!
! Anyone is free to copy, modify, publish, use, compile, sell, or 
! distribute this software, either in source code form or as a compiled 
! binary, for any purpose, commercial or non-commercial, and by any 
! means.
!
! In jurisdictions that recognize copyright laws, the author or authors 
! of this software dedicate any and all copyright interest in the 
! software to the public domain. We make this dedication for the benefit 
! of the public at large and to the detriment of our heirs and 
! successors. We intend this dedication to be an overt act of 
! relinquishment in perpetuity of all present and future rights to this 
! software under copyright law.
!
! THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
! EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
! MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
! IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR 
! OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, 
! ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
! OTHER DEALINGS IN THE SOFTWARE.
!
! For more information, please refer to http://unlicense.org/
! ----------------------------------------------------------------------

! -------------------------------------------------------------------
! 1. set these definitions in Srend.F90 exactly like this (with the # in column 1):

! 2. Build t_data and run it to create a directory of data
!    files spanning a NNN^3 volume with NB^3 blocks
!    First, set these definitions here and in t_data.F90:
! define voxel dim for entire volume at coarsest level
#define NNN 256
! number blocks per dimension
#define NB 8
!    Then, build and run t_data:
!    gfortran  t_data.F90 -O3 -o t_data
!    ./t_data
!
! 3. compile then run t_data_mpi, here with 4 ranks:
!    mpif90  Srend.F90 -O3 -c
!    gcc sleep.c -c
!    mpif90 t_data_mpi.F90 Srend.o sleep.o -O3 -o t_data_mpi
!    mpirun -np 4 ./t_data_mpi
! - - - - - - - - - - - - - - - - - - - - - 
!   openmp compile flag: -fopenmp
!   shell command before running with openmp, if needed: 
! $ ulimit -s unlimited
!
!   DEBUG Options for compiling:
!   gfortran: -fbacktrace -fbounds-check -fcheck=all -g -lefence 

! ---- these will calculate the rest, leave them be ------------------
! width of data block, without boundaries
#define NN NNN/NB
! totaL NUMBER OF BLOCKS
#define NBB NB*NB*NB

! ********************************************************************
      program t_data_mpi
#ifdef _OPENMP
      USE OMP_LIB
#endif
      USE srend
      IMPLICIT NONE
      include 'mpif.h'

      character*1,dimension(:,:,:,:),allocatable :: fv ! data array
      character*60 :: fname ! output filenames
      
! string to pass for output filenames
      character*200,save :: filenames
! timing
      integer*8 it1, it2, itc, total0, total1
      real*4 rc
! flythrough parameter
      real*4, dimension(3),save :: E, E0, V
! xyz offsets
      integer*4,save :: ix,iy,iz
! loop vars
      integer*4 :: i, tt
! MPI
      integer*4 :: MYer, MYid=0, MYn
! partition of blocks to convex boxes one for each MPI rank
      integer*4 :: bpr
! ccccccccc end variable declarations cccccccccccccccccccccccccccccccc

      call system_clock(it1,itc)
      rc = 1.0 / itc

! init MPI
      call MPI_init(MYer)
      call MPI_comm_rank(MPI_COMM_WORLD, MYid, MYer)
      call MPI_comm_size(MPI_COMM_WORLD, MYn, MYer)
      call MPI_barrier(MPI_COMM_WORLD,MYer) ! all meet here

! parameters for run
      E0 = (/0.5,1.3,1.7/)  ! initial eye position
      V = -E0               ! view vector

! partition blocks; MYn had better divide NBB evenly
! bpr is the number of blocks per rank
      bpr = NBB / MYn
      
! load data created by t_data
      allocate( fv(0:NN+1,0:NN+1,0:NN+1,1:bpr) )
      do i=1,bpr
          write(fname,'("Blocks",I6.6,"Vdim",I6.6,"/",I6.6)') NBB,NNN,i+MYid*bpr
          open(unit=111,status='unknown', file=fname,access='stream')
          read(111) fv(:,:,:,i)
          close(111)
      end do
      
      call system_clock(it2)
      print *,'Prepped: span=',(it2-it1)*rc
      it1 = it2
      total0 = it2 ! for total walltime


! PPPPPPPPPPP parallel region PPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPP
! export OMP_NUM_THREADS=4 , or however many threads should be used here      
!$OMP PARALLEL default(shared) private(i,tt)
      do tt= 1,4

!$OMP MASTER
          write(filenames,'("r_data_mpi/",I6.6,".ppm,")') tt
          print *,'pass = ',tt
          call system_clock(it1)
          E = E0 * (5.0-tt)/4.0      !move eye through volume  
!$OMP END MASTER
!$OMP BARRIER

          do i=1,bpr
!OMP MASTER
            ix = mod(MYid*bpr+i-1,NB)           ! block offset in zero based form
            iy = mod(MYid*bpr+i-1,NB*NB) / NB
            iz = (MYid*bpr+i-1) / (NB*NB)
!OMP END MASTER
!sync threads for entry .. particularly after first loop
!$OMP BARRIER
            call srend_render_load( &! rendering multiple blocks
            1,2,                       &! nV, nV_out
            NNN,                       &! voxels in full volume
            E,                         &! Eye position
            V,                         &! View vector
            (/  0.0,  1.0,  0.0/),     &! Up vector
            120.0, 120.0,              &! Alpha-horz, Beta-vert
            0.0,                       &! stereo: EyeRight
            -10.0,10.0,                &! clipping planes perpendicular to axes
            -10.0,10.0,                & 
            -10.0,10.0,                &! x0,x1,y0,y1,z0,z1
            180.0,                     &! farpolar clip
            (/.5,.5,.5/),.5,           &! sphere center(x,y,z) and radius to clip around
            0.1, 10.0, 1,              &! near clip0,far clip1,nsh
            1,                         &! 0 spherical, 1 perspective
            0,                         &! 0=norm, 1=npole, 2=equator,3=spole
            0.25,                      &! sampling in cell units,(-)for out>in
            fv(:,:,:,i),                       &! data array
            NN,NN,NN,                          &! XN,YN,ZN data array passed in
            1,                                 &! Bd
            ix*NN,iy*NN,iz*NN,                 &! offset
            1024, 1024,                &! rendering Width, Height in pixels
            1,                         &! nR
            (/48/),                    &! cotab_offset(1:nR),
            filenames,                 &! output file name masks
            1,1,                       &! tiles right, tiles down: usually 1,1
            (/0/))                      ! target MPI rank    

          end do
          
!$OMP BARRIER
!$OMP MASTER
         call system_clock(it2)
         print *,'Rendered pass ',tt,' : span=',(it2-it1)*rc
         it1 = it2

         call srend_render_flush(1)

         call system_clock(it2)
         print *,'Flushed: span=',(it2-it1)*rc
         it1 = it2
!$OMP END MASTER
!$OMP BARRIER


!$OMP BARRIER
!$OMP MASTER
         call MPI_barrier(MPI_COMM_WORLD,MYer) ! all meet here
         if(MYid == 0) then
         
           call srend_finish(2,MYn)
         
         end if
!$OMP END MASTER
!$OMP BARRIER


      end do ! tt pass loop
!$OMP END PARALLEL
! pppppppppp end parallel region ppppppppppppppppppppppppppppppppppppp


      call system_clock(it2)
      total1 = it2
      print *,'total runtime (node 0) =', (total1-total0)*rc
      
      call MPI_finalize(MYer)
      
      end program t_data_mpi! program main
! ********************************************************************

