#!/usr/bin/env python

# cotabedit.py  2016jul26  wetherbee

'''
! -----------------------------------------------------------------------
! This is free and unencumbered software released into the public domain.
!
! Anyone is free to copy, modify, publish, use, compile, sell, or 
! distribute this software, either in source code form or as a compiled 
! binary, for any purpose, commercial or non-commercial, and by any 
! means.
!
! In jurisdictions that recognize copyright laws, the author or authors 
! of this software dedicate any and all copyright interest in the 
! software to the public domain. We make this dedication for the benefit 
! of the public at large and to the detriment of our heirs and 
! successors. We intend this dedication to be an overt act of 
! relinquishment in perpetuity of all present and future rights to this 
! software under copyright law.
!
! THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
! EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
! MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
! IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR 
! OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, 
! ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
! OTHER DEALINGS IN THE SOFTWARE.
!
! For more information, please refer to http://unlicense.org/
! ----------------------------------------------------------------------
'''

# This is a sample Python script calling srend.  It also does something
# useful which is exploring color table settings for data.
#
# 1. compile Srend to a shared library
# build        : gfortran Srend.F90 -O3 -DSREND_NOMPI -DSREND_COTAB_FILENAME='"cotab.txt"' -DSREND_COTAB_EACH_PASS  -fPIC -shared -o Srend.so
# check names  : nm  Srend.so   (callable subroutines are "T" entries)
#
# 2. install python 2.x and tkinter for python 2.x (usually 2.7)
#
# 3. Any data file of raw bytes with known x,y,z dimensions will do.
#    You must enter these x,y,z, spans.  The offset is from the
#    start of the data file, so usually 0.
#    You can try the 41x41x41 nucleon from this web site:
#          http://www.tc18.org/code_data_set/3D_images.html
#
# 4. Enter the Data offset, xyz spans, then press "Load Data from.."
#    button.  The dat file name should appear after it has been loaded.
#
# 5. Press "Enter cotab file" button, and enter a color table file
#    name.  The file "cotabedit.txt" should be in the working directory
#    as a sample; this script recreates it as needed, just in case.
#
# 6. Press The "Render" button to render the data.
# --------------------------------------------------------------------
# - the displayed color table is used for each rendering.  Other rendering
#   parameters must be changed in cotabedit.py

from Tkinter import *
from tkFileDialog   import askopenfilename, asksaveasfile
from ScrolledText import *
from ctypes import *
import os

# ----- open the library first
try:
	srend = CDLL("./Srend.so") #load
except (NameError,OSError): print "Srend.so not found"
else: print "loaded Srend.so"

root = Tk()

# ---- Entry variables
def init_V():
   global V_Ex,V_Ey,V_Ez,V_Vx,V_Vy,V_Vz,V_Ux,V_Uy,V_Uz
   V_Ex = StringVar(); V_Ex.set("0.5")
   V_Ey = StringVar(); V_Ey.set("0.5")
   V_Ez = StringVar(); V_Ez.set("1.5")
   V_Vx = StringVar(); V_Vx.set("0.0")
   V_Vy = StringVar(); V_Vy.set("0.0")
   V_Vz = StringVar(); V_Vz.set("-1.0")
   V_Ux = StringVar(); V_Ux.set("0.0")
   V_Uy = StringVar(); V_Uy.set("1.0")
   V_Uz = StringVar(); V_Uz.set("0.0")
   global V_alpha, V_beta
   V_alpha = StringVar(); V_alpha.set("90.0")
   V_beta = StringVar(); V_beta.set("90.0")
   global V_clipx0,V_clipx1,V_clipy0,V_clipy1,V_clipz0,V_clipz1
   V_clipx0 = StringVar(); V_clipx0.set("-10.0")
   V_clipx1 = StringVar(); V_clipx1.set("10.0")
   V_clipy0 = StringVar(); V_clipy0.set("-10.0")
   V_clipy1 = StringVar(); V_clipy1.set("10.0")
   V_clipz0 = StringVar(); V_clipz0.set("-10.0")
   V_clipz1 = StringVar(); V_clipz1.set("10.0")
   global V_clip0, V_clip1, V_pclip1
   V_clip0 = StringVar(); V_clip0.set("1.0")
   V_clip1 = StringVar(); V_clip1.set("2.0")
   V_pclip1 = StringVar(); V_pclip1.set("180.0")
   global V_perspective
   V_perspective = StringVar(); V_perspective.set("0")
   global V_dt
   V_dt = StringVar(); V_dt.set("0.5")
   global V_xn, V_yn, V_zn # data dimensions, including Bd=1
   V_xn = StringVar(); V_xn.set("41")
   V_yn = StringVar(); V_yn.set("41")
   V_zn = StringVar(); V_zn.set("41")
   global V_XN,V_YN,V_ZN # data dim.. not including boundaries of 1
   V_XN = StringVar(); V_XN.set("39")
   V_YN = StringVar(); V_YN.set("39")
   V_ZN = StringVar(); V_ZN.set("39")
   global V_Vdim
   V_Vdim = StringVar(); V_Vdim.set("39")
   global V_offset_cotab
   V_offset_cotab = StringVar(); V_offset_cotab.set("1")
   
init_V() # initialize these above

# ---- srend parameters: called during render
def set_srend_vars():
   global nV_in, nV_out
   nV_in = c_int(1)
   nV_out = c_int(1)
   global E,V,U
   VecFloat = c_float*3
   E = VecFloat(float(V_Ex.get()),float(V_Ey.get()),float(V_Ez.get()))
   V = VecFloat(float(V_Vx.get()),float(V_Vy.get()),float(V_Vz.get()))
   U = VecFloat(float(V_Ux.get()),float(V_Uy.get()),float(V_Uz.get()))
   global alpha,beta,eyeRight
   alpha = c_float(float(V_alpha.get()))
   beta = c_float(float(V_beta.get()))
   eyeRight = c_float(0.0)
   global clipx0,clipx1,clipy0,clipy1,clipz0,clipz1,pt,pt_r
   clipx0 = c_float(float(V_clipx0.get())); clipx1 = c_float(float(V_clipx1.get()))
   clipy0 = c_float(float(V_clipy0.get())); clipy1 = c_float(float(V_clipy1.get()))
   clipz0 = c_float(float(V_clipz0.get())); clipz1 = c_float(float(V_clipz1.get()))
   pt = VecFloat(0.5,0.5,0.5); pt_r = c_float(0.5) # <<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   global clip0,clip1,nsh,pclip1,perspective,srendtype,dt
   clip0 = c_float(float(V_clip0.get())); clip1 = c_float(float(V_clip1.get()))
   nsh = c_int(1)
   pclip1 = c_float(float(V_pclip1.get()))
   perspective = c_int(int(V_perspective.get()))
   srendtype = c_int(0)
   dt = c_float(float(V_dt.get()))
#   ByteArray = c_byte*( xn*yn*zn ) # set on loading
#   bytedata = ByteArray()          # set on loading
   global XN,YN,ZN,Bd,iNX,iNY,iNZ
   XN = c_int(-2+int(V_xn.get()))
   YN = c_int(-2+int(V_yn.get()))
   ZN = c_int(-2+int(V_zn.get()))
   Bd = c_int(1)
   iNX = c_int(0);iNY = c_int(0);iNZ = c_int(0)
   global Vdim
   Vdim = c_int( max(-2+int(V_xn.get()),-2+int(V_yn.get()),-2+int(V_zn.get())) )
   global W,H,nR
   W = c_int(400)
   H = c_int(400)
   nR = c_int(1)
   global offset_cotab
   offset_cotab = c_int(int(V_offset_cotab.get())) #set in render()
   global filenames
   filename_stringin = 'cotabedit.ppm, '
   filenames = c_char_p(filename_stringin) # c_type pointer for strings, not a byref
   global tiles_right, tiles_down,TARGid
   tiles_right = c_int(1)
   tiles_down = c_int(1)
   TARGid = c_int(0)

# ************ left widgets *********************

# --- data offset in file
V_file_offset = StringVar(); V_file_offset.set("0")
L_file_offset = Label(root,text="Data Offset=").grid(row=0,column=0) 
E_file_offset = Entry(root,textvariable=V_file_offset)
E_file_offset.grid(row=0,column=1)

# --- dimensions of data -------------------
L_xn = Label(root,text="X span=").grid(row=1,column=0) 
E_xn = Entry(root,textvariable=V_xn)
E_xn.grid(row=1,column=1)

L_yn = Label(root,text="Y span=").grid(row=2,column=0)
E_yn = Entry(root,textvariable=V_yn)
E_yn.grid(row=2,column=1)

L_zn = Label(root,text="Z span=").grid(row=3,column=0)
E_dn = Entry(root,textvariable=V_zn)
E_dn.grid(row=3,column=1)

# --- open data file: file widget
V_data_fname = StringVar()
def get_data_fname():
   fname = cotab_fname = askopenfilename()
   V_data_fname.set(fname)
   file_data_dim = int(V_xn.get())*int(V_yn.get())*int(V_zn.get())
   global bytedata
   ByteArray = c_byte*file_data_dim
   bytedata = ByteArray()
   fdat = open(V_data_fname.get(),"rb")
   fdat.seek(int(V_file_offset.get()))
   fdat.readinto(bytedata)
   fdat.close()
B_get_data_fname = Button(root,text="Load Data from..",command=get_data_fname)
B_get_data_fname.grid(row=4,column=0,columnspan=2)

# --- display data file name
L_data_fname = Label(root,textvariable=V_data_fname)
L_data_fname.grid(row=5,column=0,columnspan=2)

# ---------------- render ------------------
def render():
   set_srend_vars()
   offset_cotab = c_int( int(V_offset_cotab.get()))
   srend.__srend_MOD_srend_render(byref(nV_in),byref(nV_out),byref(Vdim),
      byref(E),byref(V),byref(U),byref(alpha),byref(beta),byref(eyeRight),
      byref(clipx0),byref(clipx1),byref(clipy0),byref(clipy1),
      byref(clipz0),byref(clipz1),byref(pclip1),byref(pt),byref(pt_r),
      byref(clip0),byref(clip1),byref(nsh),
      byref(perspective),byref(srendtype),
      byref(dt),byref(bytedata),byref(XN),byref(YN),byref(ZN),byref(Bd),
      byref(iNX),byref(iNY),byref(iNZ),
      byref(W),byref(H),byref(nR),byref(offset_cotab),
      filenames,byref(tiles_right),byref(tiles_down),
      byref(TARGid) )

# canvas to display rendered data
Can = Canvas(root,width=400,height=400)
Can.grid(row=6,column=0,columnspan=2)

# --- render button
def render_data():
   Can.delete('all')
   print "render again"
   fout = open("cotab.txt",'w')
   fout.write(Tcotab.get(1.0,END))
   fout.close()
   render()
   new_im = PhotoImage(file='cotabedit.ppm')
   Can.delete("all")
   Can.create_image(200,200,image=new_im)
   Can.save_im = new_im # save ref
B_render_data = Button(root,text="Render",command=render_data)
B_render_data.grid(row=7,column=0,columnspan=2)

# --- quit
def quitter():
   quit()
B_quit = Button(root,text="Quit", command=quitter)
B_quit.grid(row=8,column=0,columnspan=2)

# ************* right widgets ******************

# --- colortable text display for editing
Tcotab = ScrolledText(root,height=28,width=40)
Tcotab.grid(row=6,column=2)

# --- offset cotab
L_offset_cotab = Label(root,text="cotab offset=").grid(row=0,column=2) 
E_offset_cotab = Entry(root,textvariable=V_offset_cotab)
E_offset_cotab.grid(row=1,column=2)

# open cotab file
V_cotab_fname = StringVar()
def open_cotab_file():
   Tcotab.delete(1.0,END)
   fname = askopenfilename()
   V_cotab_fname.set(fname)
   fin = open(fname,'r')
   ftext = fin.read()
   fin.close()
   Tcotab.insert(END,ftext)
B_open_cotab_file = Button(root,text="Open cotab file",command=open_cotab_file)
B_open_cotab_file.grid(row=4,column=2)

# --- display cotab file name
L_cotab_fname = Label(root,textvariable=V_cotab_fname)
L_cotab_fname.grid(row=5,column=2)

# save cotab file
def save_cotab_file():
  cotab_fhandle = asksaveasfile(mode='w')
  save_text = str(Tcotab.get(1.0,END))
  cotab_fhandle.write(save_text)
  cotab_fhandle.close()
B_save_cotab_file = Button(root,text="Save cotab file as",command=save_cotab_file)
B_save_cotab_file.grid(row=7,column=2)

# create cotabedit.txt as a self-contained default color table file
print "Creating a default color table file in Text window."
Tcotab.insert(END,"alpha 1\n")
Tcotab.insert(END,"0   0.0\n")
Tcotab.insert(END,"5   0.0\n")
Tcotab.insert(END,"36  0.0627\n")
Tcotab.insert(END,"72  0.148\n")
Tcotab.insert(END,"105 0.536\n")
Tcotab.insert(END,"133 1.0\n")
Tcotab.insert(END,"158 1.0\n")
Tcotab.insert(END,"196 0.328\n")
Tcotab.insert(END,"236 0.302\n")
Tcotab.insert(END,"244 0.105\n")
Tcotab.insert(END,"250 0.0\n")
Tcotab.insert(END,"255 0.0\n")
Tcotab.insert(END,"\n")
Tcotab.insert(END,"alpha 2\n")
Tcotab.insert(END,"0   0.0\n")
Tcotab.insert(END,"128 0.5\n")
Tcotab.insert(END,"255 1.0\n")
Tcotab.insert(END,"\n")
Tcotab.insert(END,"rgb 1\n")
Tcotab.insert(END,"0   0.0 0.0 0.0\n")
Tcotab.insert(END,"5   0.0 0.0 0.0\n")
Tcotab.insert(END,"36  0.0 0.0 0.2509804\n")
Tcotab.insert(END,"71  0.0 0.1176471 0.3137255\n")
Tcotab.insert(END,"105 0.0 0.7843137 1.0\n")
Tcotab.insert(END,"131 1.0 1.0 1.0\n")
Tcotab.insert(END,"158 1.0 1.0 0.0\n")
Tcotab.insert(END,"196 1.0 0.0 0.0\n")
Tcotab.insert(END,"244 0.5019608 0.0 0.0\n")
Tcotab.insert(END,"255 0.5019608 0.0 0.0\n")
Tcotab.insert(END,"\n")
Tcotab.insert(END,"rgb 2\n")
Tcotab.insert(END,"0   1.0 0.0 0.0\n")
Tcotab.insert(END,"128 0.0 1.0 0.0\n")
Tcotab.insert(END,"255 0.0 0.0 1.0\n")
Tcotab.insert(END,"\n")

# ************************** wait for user requests ************************************
root.mainloop()
