#!/usr/bin/env python

#   ctl.py  2016jul26  wetherbee
'''
! -----------------------------------------------------------------------
! This is free and unencumbered software released into the public domain.
!
! Anyone is free to copy, modify, publish, use, compile, sell, or 
! distribute this software, either in source code form or as a compiled 
! binary, for any purpose, commercial or non-commercial, and by any 
! means.
!
! In jurisdictions that recognize copyright laws, the author or authors 
! of this software dedicate any and all copyright interest in the 
! software to the public domain. We make this dedication for the benefit 
! of the public at large and to the detriment of our heirs and 
! successors. We intend this dedication to be an overt act of 
! relinquishment in perpetuity of all present and future rights to this 
! software under copyright law.
!
! THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
! EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
! MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
! IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR 
! OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, 
! ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
! OTHER DEALINGS IN THE SOFTWARE.
!
! For more information, please refer to http://unlicense.org/
! ----------------------------------------------------------------------
'''

'''
   ********* Directions *********
1. compile Srend to a shared library
   build: gfortran Srend.F90 -O3 -DSREND_NOMPI -DSREND_COTAB_EACH_PASS -DSREND_COTAB_FILENAME="'cotab.txt'" -fPIC -shared -o Srend.so
   names: nm  Srend.so   (callable subroutines are "T" entries)
   "Srend.so" shuld be in the working directory with this
   file "ctl.py".

2. ctl.py opens Grads format data which comes as two files:
     header:  data.ctl
     data  :  data.dat
   CM1 emits these, and this is an easy format to create in simulation
   code where the data is available.  There are many more utilities
   available to convert Grads to something else than something
   else to Grads.  But, again, this is an easy format to code, and
   this tk GUI doesn't need to read much of the header.
   
3. The Python libraries needed below might already be installed.  
   On Linux, tkinter is the one most likely missing beyond a plain
   Python 2.7 install.
   
4. Make sure that ctl.py is executable.  In the working directory,
   with ctl.py, this command will ensure this: chmod 755 ctl.py
   
5. Select .ctl, scan .ctl, process data, and open or write a cotab
   file in the editor before rendering.  Most of the open entry boxes
   can be edited to do something.  (Exception: The "XYZ raw data" boxes 
   are filled in during a .B_get_ctl file scan.)  Edit the scaling function
   to change how the raw 32-bit floating point data (x) is scaled to
   bytes in [0,255].  Edit the RGB and alpha color table entries in The
   editor; the contents of the editor are used for rendering, saved to
   "cotab.txt" then opened by srend_render().  A sample cotab file
   is "cotabedit.txt" which is created on startup if it doesn't
   already exist.
'''

from Tkinter import *
from tkFileDialog   import askopenfilename, asksaveasfile
from ScrolledText import *
from ctypes import *
import os
import string
from math import *

# ----- open the library first
try:
	srend = CDLL("./Srend.so") #load
except (NameError,OSError): print "Srend.so not found"
else: print "loaded Srend.so"

root = Tk()

# ---- Entry variables
def init_V():
   global V_Ex,V_Ey,V_Ez,V_Vx,V_Vy,V_Vz,V_Ux,V_Uy,V_Uz
   V_Ex = StringVar(); V_Ex.set("1.5")
   V_Ey = StringVar(); V_Ey.set("0.5")
   V_Ez = StringVar(); V_Ez.set("0.5")
   V_Vx = StringVar(); V_Vx.set("-1.0")
   V_Vy = StringVar(); V_Vy.set("0.0")
   V_Vz = StringVar(); V_Vz.set("0.0")
   V_Ux = StringVar(); V_Ux.set("0.0")
   V_Uy = StringVar(); V_Uy.set("0.0")
   V_Uz = StringVar(); V_Uz.set("1.0")
   global V_alpha, V_beta
   V_alpha = StringVar(); V_alpha.set("90.0")
   V_beta = StringVar(); V_beta.set("90.0")
   global V_clipx0,V_clipx1,V_clipy0,V_clipy1,V_clipz0,V_clipz1
   V_clipx0 = StringVar(); V_clipx0.set("-10.0")
   V_clipx1 = StringVar(); V_clipx1.set("10.0")
   V_clipy0 = StringVar(); V_clipy0.set("-10.0")
   V_clipy1 = StringVar(); V_clipy1.set("10.0")
   V_clipz0 = StringVar(); V_clipz0.set("-10.0")
   V_clipz1 = StringVar(); V_clipz1.set("10.0")
   global V_clip0, V_clip1, V_pclip1, V_ptx,V_pty,V_ptz, V_pt_r
   V_clip0 = StringVar(); V_clip0.set("0.1")
   V_clip1 = StringVar(); V_clip1.set("2.0")
   V_pclip1 = StringVar(); V_pclip1.set("180.0")
   V_ptx = StringVar(); V_ptx.set("0.5")
   V_pty = StringVar(); V_pty.set("0.5")
   V_ptz = StringVar(); V_ptz.set("0.5")
   V_pt_r = StringVar(); V_pt_r.set("1.0")
   global V_perspective
   V_perspective = StringVar(); V_perspective.set("1")
   global V_dt
   V_dt = StringVar(); V_dt.set("0.25")
   global V_xn, V_yn, V_zn # data dimensions, including Bd=1
   V_xn = StringVar(); V_xn.set("41")
   V_yn = StringVar(); V_yn.set("41")
   V_zn = StringVar(); V_zn.set("41")
   global V_XN,V_YN,V_ZN # data dim.. not including boundaries of 1
   V_XN = StringVar(); V_XN.set("39")
   V_YN = StringVar(); V_YN.set("39")
   V_ZN = StringVar(); V_ZN.set("39")
   global V_Vdim
   V_Vdim = StringVar(); V_Vdim.set("39")
   global V_offset_cotab
   V_offset_cotab = StringVar(); V_offset_cotab.set("1")
   
init_V() # initialize these above

# ---- srend parameters: called during render
def set_srend_vars():
   global nV_in, nV_out
   nV_in = c_int(1)
   nV_out = c_int(1)
   global E,V,U
   VecFloat = c_float*3
   E = VecFloat(float(V_Ex.get()),float(V_Ey.get()),float(V_Ez.get()))
   V = VecFloat(float(V_Vx.get()),float(V_Vy.get()),float(V_Vz.get()))
   U = VecFloat(float(V_Ux.get()),float(V_Uy.get()),float(V_Uz.get()))
   global alpha,beta,eyeRight
   alpha = c_float(float(V_alpha.get()))
   beta = c_float(float(V_beta.get()))
   eyeRight = c_float(0.0)
   global clipx0,clipx1,clipy0,clipy1,clipz0,clipz1,pclip1,pt,pt_r
   clipx0 = c_float(float(V_clipx0.get())); clipx1 = c_float(float(V_clipx1.get()))
   clipy0 = c_float(float(V_clipy0.get())); clipy1 = c_float(float(V_clipy1.get()))
   clipz0 = c_float(float(V_clipz0.get())); clipz1 = c_float(float(V_clipz1.get()))
   pclip1 = c_float(float(V_pclip1.get()))
   pt = VecFloat(float(V_ptx.get()),float(V_pty.get()),float(V_ptz.get()))
   pt_r = c_float(float(V_pt_r.get()))
   global clip0,clip1,nsh
   clip0 = c_float(float(V_clip0.get())); clip1 = c_float(float(V_clip1.get()))
   nsh = c_int(1)
   global perspective,srendtype,dt
   perspective = c_int(int(V_perspective.get()))
   srendtype = c_int(0)
   dt = c_float(float(V_dt.get()))
#   ByteArray = c_byte*( xn*yn*zn ) # set on loading
#   bytedata = ByteArray()          # set on loading
   global XN,YN,ZN,Bd,iNX,iNY,iNZ
   XN = c_int(int(V_XN.get()))
   YN = c_int(int(V_YN.get()))
   ZN = c_int(int(V_ZN.get()))
   Bd = c_int(1)
   iNX = c_int(0);iNY = c_int(0);iNZ = c_int(0)
   global Vdim
#   Vdim = c_int( max(-2+int(V_xn.get()),-2+int(V_yn.get()),-2+int(V_zn.get())) )
   Vdim = c_int( int(V_Vdim.get()) )
   global W,H,nR
   W = c_int(400)
   H = c_int(400)
   nR = c_int(1)
   global offset_cotab
   offset_cotab = c_int(int(V_offset_cotab.get())) #set in render()
   global filenames
   filename_stringin = 'ctl.ppm, '
   filenames = c_char_p(filename_stringin) # c_type pointer for strings, not a byref
   global tiles_right, tiles_down,TARGid
   tiles_right = c_int(1)
   tiles_down = c_int(1)
   TARGid = c_int(0)

# <<<<<<<<<<< begin panels >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
# p1 p2 p3 p4
# p1 p2 |  |
# p5-p5 p3 p4

# ************ panel for hist and cotab: 5 of 5 ***********
panel5 = Frame(root)
panel5.grid(row=1,column=0,columnspan=2)


# ************ left panel 1 of 5 *********************
panel1 = Frame(root)
panel1.grid(row=0,column=0)

V_ctl_fname = StringVar()

# --- open .ctl file: 0,0-3
def get_ctl_fname():
   fname = askopenfilename()
   V_ctl_fname.set(fname)
B_get_ctl_fname = Button(panel1,text="1. Select .ctl File",command=get_ctl_fname,bg="#CCCCFF",font="Verdana 10 bold",width=25)
B_get_ctl_fname.grid(row=0,column=0,columnspan=4)

# --- display data file name: 1,0-3
L_ctl_fname = Label(panel1,textvariable=V_ctl_fname)
L_ctl_fname.grid(row=1,column=0,columnspan=4)

# --- scan .ctl file: 2,0-3
var3d_offset = {}
def scan_ctl():
   global xn,yn,zn,tdef,var3d_offset,toffset
   nvars = 0
   fname = V_ctl_fname.get()
   fname2 = string.replace(fname, '.dat', '.ctl') # make sure .dat is not opened for .ctl
   V_ctl_fname.set(fname2) # replace, just in case
   fin = open(fname2,'r')
   line = fin.readlines()
   fin.close()
   offset = 0
   var3d_offset.clear()
   zn = -999999 # will be replaced, this for entry
   for i in range(len(line)):
      word = line[i].split()
      if nvars == 0:
          if word[0] == 'xdef':
             xn = int(word[1])
             continue
          if word[0] == 'ydef':
             yn = int(word[1])
             continue
          if word[0] == 'zdef':
             zn = int(word[1])
             continue
          if word[0] == 'tdef':
             tdef = int(word[1])
             continue
          if word[0] == 'vars': # skip in case there are zn vars
             nvars = int(word[1])
             continue
      else:
          if len(word)>1 and word[1] == '0':
             offset += xn*yn*4
             continue
          if len(word)>1 and word[1] == str(zn):
             var3d_offset[word[0]] = offset
             offset += xn*yn*zn*4
   toffset = offset
   var_keys =  tuple(sorted(var3d_offset.keys()))
   Lbox_var.config(values=var_keys)
   Ltime_var.config(from_=0)
   Ltime_var.config(to=tdef)
   V_xn.set(str(xn))
   V_yn.set(str(yn))
   V_zn.set(str(zn))
   V_XN.set(str(xn-2))
   V_YN.set(str(yn-2))
   V_ZN.set(str(zn-2))
   V_Vdim.set( str(max(xn-2,yn-2,zn-2)))
   
B_scan_ctl = Button(panel1,text="2. Scan .ctl File.",command=scan_ctl,bg="#CCCCFF",font="Verdana 10 bold",width=25)
B_scan_ctl.grid(row=2,column=0,columnspan=4)

# select ctl var: 3,0 3,1
Lvar = Label(panel1,text="Variable:").grid(row=3,column=0)
#var_keys =  tuple(sorted(var3d_offset.keys()))
Lbox_var = Spinbox(panel1,values=['nothing'],width=10)
Lbox_var.grid(row=3,column=1)

# select time step: 4,0 4,1
Ltime = Label(panel1,text="Time Step:").grid(row=4,column=0)
Ltime_var = Spinbox(panel1,from_=1,to=1,width=10)
Ltime_var.grid(row=4,column=1)

# canvas to display histogram of incoming data: in panel5
Can1 = Canvas(panel5,width=120,height=296)
Can1.grid(row=0,column=0)
L_can1 = Label(panel5,text="Raw Data (x)").grid(row=1,column=0)

# canvas to display histogram of scaled bytes: inpanel5
Can2 = Canvas(panel5,width=120,height=296)
Can2.grid(row=0,column=1)
L_can2 = Label(panel5,text="Scaled Bytes (y)").grid(row=1,column=1)

# process Data: 5,0-3
def process_var():
   data_dim = xn*yn*zn
   data_time = int(Ltime_var.get())
   if data_time == 0: return
   offset = int(var3d_offset[Lbox_var.get()]) + (data_time-1)*toffset
   dfname = string.replace(V_ctl_fname.get(), '.ctl', '.dat')
   
   FloatArray = c_float*data_dim
   rdat = FloatArray()
   
   fdat = open(dfname,"rb")
   fdat.seek(offset)
   fdat.readinto(rdat) # seems to work
   fdat.close()
   
   dmax = rdat[0]
   dmin = rdat[0]
   dsum = 0.0
   for i in range(data_dim): # examinefor: max, min, span, and ave
      dsum += rdat[i]
      if rdat[i]>dmax:dmax = rdat[i]
      if rdat[i]<dmin:dmin = rdat[i]
   dave = dsum / data_dim
   dspan = dmax-dmin
   bval = []
   for i in range(256): bval.append(0)
   if dspan > 0.0: # count data in 256 bins
      for i in range(data_dim): # make histogram
         val = int(floor(255.99 * (rdat[i] - dmin)/dspan))
         bval[val] += 1
   else:
      bval[0] = data_dim
   bval_max = 0
   for i in range(256): # find max in each bin
      if bval[i]>bval_max: bval_max = bval[i]

   Can1.delete('all')
   Can1.create_rectangle(0,0,120,296,fill="white")
   Can1.create_rectangle(0,20,100,256+20,fill="green")# background for hist 
   log_bval_max = log(1.0 + bval_max) # max bin count
   for i in range(256): # hist lines for each bin, log
     xtop = int( floor((100.0*log(1.0+bval[i]))/log_bval_max) )
     Can1.create_line(0,276-i,xtop,276-i)
   for i in range(0,257,32): # small right tic every 32
      Can1.create_line(100,i+20,105,i+20)
   for i in range(0,257,64): # larger right tic every 64
      Can1.create_line(100,i+20,110,i+20)
   dmin_str = "%.6g" % dmin
   dmax_str = "%.6g" % dmax
   Can1.create_text(60,286,text="min="+dmin_str)
   Can1.create_text(60,10,text="max="+dmax_str)
   
   global bytedata
   ByteArray = c_byte*data_dim
   bytedata = ByteArray()
   for i in range(data_dim):
      x = rdat[i]
      y = eval(V_f.get())
      bytedata[i] = int( floor(y))
   for i in range(256):
      bval[i] = 0
   for i in range(data_dim):
      bval[bytedata[i]] += 1
   bval_max = 0
   for i in range(256): # find max in each bin
      if bval[i]>bval_max: bval_max = bval[i]
      
   Can2.delete('all')
   Can2.create_rectangle(0,0,120,296,fill="white")
   Can2.create_rectangle(0,20,100,256+20,fill="yellow")# background for hist 
   log_bval_max = log(1.0 + bval_max) # max bin count
   for i in range(256): # hist lines for each bin, log
     xtop = int( floor((100.0*log(1.0+bval[i]))/log_bval_max) )
     Can2.create_line(0,276-i,xtop,276-i)
   for i in range(0,257,32): # small right tic every 32
      Can2.create_line(100,i+20,105,i+20)
   for i in range(0,257,64): # larger right tic every 64
      Can2.create_line(100,i+20,110,i+20)
   Can2.create_text(60,286,text="min=0")
   Can2.create_text(60,10,text="max=255")
   
B_process_var = Button(panel1,text="3a. Process Data (Python eval)",command=process_var,bg="#CCCCFF",font="Verdana 10 bold",width=25)
B_process_var.grid(row=5,column=0,columnspan=4)

# fprocess Data: 5,0-3 : Fortran
def fprocess_var():
   data_dim = xn*yn*zn
   data_time = int(Ltime_var.get())
   if data_time == 0: return
   offset = int(var3d_offset[Lbox_var.get()]) + (data_time-1)*toffset
   dfname = string.replace(V_ctl_fname.get(), '.ctl', '.dat')
   
   FloatArray = c_float*data_dim
   rdat = FloatArray()
   
   fdat = open(dfname,"rb")
   fdat.seek(offset)
   fdat.readinto(rdat) # seems to work
   fdat.close()
   
   global bytedata
   ByteArray = c_byte*data_dim
   bytedata = ByteArray()
   
   Vn = c_int(data_dim)
   Va = c_float(float(V_a.get()))
   Vb = c_float(float(V_b.get()))
   Vh = c_float(float(V_h.get()))
   Vk = c_float(float(V_k.get()))
   Vdmin = c_float(0)
   Vdmax = c_float(0)
   
   IntArray = c_int*256
   Vhist_rdat = IntArray()
   Vhist_bdat = IntArray()

   srend.__srend_MOD_srend_scale(byref(Vn),rdat,bytedata,byref(Vhist_rdat),
                                 byref(Vhist_bdat),byref(Va),byref(Vb),
                                 byref(Vh),byref(Vk),byref(Vdmin),byref(Vdmax) )

   dmin = Vdmin.value
   dmax = Vdmax.value
   dmin_str = "%.6g" % dmin
   dmax_str = "%.6g" % dmax

   Can1.delete('all')
   Can1.create_rectangle(0,0,120,296,fill="white")
   Can1.create_rectangle(0,20,100,256+20,fill="green")# background for hist 
   for i in range(256): # hist lines for each bin, log
     xtop = Vhist_rdat[i]
     Can1.create_line(0,276-i,xtop,276-i)
   for i in range(0,257,32): # small right tic every 32
      Can1.create_line(100,i+20,105,i+20)
   for i in range(0,257,64): # larger right tic every 64
      Can1.create_line(100,i+20,110,i+20)
   Can1.create_text(60,286,text="min="+dmin_str)
   Can1.create_text(60,10,text="max="+dmax_str)

   Can2.delete('all')
   Can2.create_rectangle(0,0,120,296,fill="white")
   Can2.create_rectangle(0,20,100,256+20,fill="yellow")# background for hist 
   for i in range(256): # hist lines for each bin, log
     xtop = Vhist_bdat[i]
     Can2.create_line(0,276-i,xtop,276-i)
   for i in range(0,257,32): # small right tic every 32
      Can2.create_line(100,i+20,105,i+20)
   for i in range(0,257,64): # larger right tic every 64
      Can2.create_line(100,i+20,110,i+20)
   Can2.create_text(60,286,text="min=0")
   Can2.create_text(60,10,text="max=255")

B_process_var = Button(panel1,text="3b. Process Data (Fortran call)",command=fprocess_var,bg="#CCCCFF",font="Verdana 10 bold",width=25)
B_process_var.grid(row=6,column=0,columnspan=4)


# --- quit: 25,0-3
def quitter():
   quit()
B_quit = Button(panel1,text="Quit", command=quitter,bg="#FF0000",fg="#FFFFFF",font="Verdana 10 bold",width=25)
B_quit.grid(row=25,column=0,columnspan=4)


# ********* panel 2 of 5 ***********************
panel2 = Frame(root)
panel2.grid(row=0,column=1)

#L_data_dim = Label(panel2,text

# --- XYZ dim: 0,4-7
L_xn = Label(panel2,text="XYZ raw data=").grid(row=0,column=0)
E_xn = Entry(panel2,textvariable=V_xn,width=5)
E_xn.grid(row=0,column=1)

E_yn = Entry(panel2,textvariable=V_yn,width=5)
E_yn.grid(row=0,column=2)

E_zn = Entry(panel2,textvariable=V_zn,width=5)
E_zn.grid(row=0,column=3)


L_XN = Label(panel2,text="XYZ rendering=").grid(row=1,column=0)
E_XN = Entry(panel2,textvariable=V_XN,width=5)
E_XN.grid(row=1,column=1)

E_YN = Entry(panel2,textvariable=V_YN,width=5)
E_YN.grid(row=1,column=2)

E_ZN = Entry(panel2,textvariable=V_ZN,width=5)
E_ZN.grid(row=1,column=3)

# --- Vdim: 1,4-5
L_Vdim = Label(panel2,text="Vdim=").grid(row=2,column=0)
E_Vdim = Entry(panel2,textvariable=V_Vdim,width=5)
E_Vdim.grid(row=2,column=1)

# --- Scaling function: 2-4,4-7  --- Python Eval
L_scaling = Label(panel2,text="Python eval Scaling Function f(x): y = f(x)")
L_scaling.grid(row=3,column=0,columnspan=4)

# eval function entry
V_f = StringVar(); V_f.set("128.0 + 127.0 * x/sqrt(x*x + 1.0)")
E_f = Entry(panel2,textvariable=V_f,width=35)
E_f.grid(row=4,column=0,rowspan=2,columnspan=4)


# --- Scaling function: 5, 4-7 -- Fortran Srend call with a,b,c,d,e parameters
V_a = StringVar();V_b = StringVar();V_h = StringVar();V_k = StringVar()
V_a.set("127.0"); V_b.set("1.0"); V_h.set("0.0") ; V_k.set("128.0")
L_scaling = Label(panel2,text="Fortran f(x)=k + a*(x-h) / sqrt((x-h)^2 + b*b)")
L_scaling.grid(row=6,column=0,columnspan=4)

L_a = Label(panel2,text="a=").grid(row=7,column=0)
E_a = Entry(panel2,textvariable=V_a,width=5)
E_a.grid(row=7,column=1)

L_b = Label(panel2,text="b=").grid(row=7,column=2)
E_b = Entry(panel2,textvariable=V_b,width=5)
E_b.grid(row=7,column=3)

L_h = Label(panel2,text="h=").grid(row=8,column=0)
E_h = Entry(panel2,textvariable=V_h,width=5)
E_h.grid(row=8,column=1)

L_k = Label(panel2,text="k=").grid(row=8,column=2)
E_k = Entry(panel2,textvariable=V_k,width=5)
E_k.grid(row=8,column=3)





# ************** panel 5 Canvas for RGB and alpha
# --- canvas to display RGB lines: in panel5
Can3 = Canvas(panel5,width=120,height=296)
Can3.grid(row=0,column=2)
L_can3 = Label(panel5,text="RGB").grid(row=1,column=2)

# --- canvas to display alpha lines: in panel5
Can4 = Canvas(panel5,width=120,height=296)
Can4.grid(row=0,column=3)
L_can4 = Label(panel5,text="Alpha").grid(row=1,column=3)


# ********* panel 3 of 5 *******************

panel3 = Frame(root)
panel3.grid(row=0,column=2,rowspan=2)
# --- colortable text display for editing
Tcotab = ScrolledText(panel3,height=28,width=30)
Tcotab.grid(row=4,column=0,columnspan=20)

# open cotab file
V_cotab_fname = StringVar()
def open_cotab_file():
   Tcotab.delete(1.0,END)
   fname = askopenfilename()
   V_cotab_fname.set(fname)
   fin = open(fname,'r')
   ftext = fin.read()
   fin.close()
   Tcotab.insert(END,ftext)
B_open_cotab_file = Button(panel3,text="1. Open cotab file",command=open_cotab_file,bg="#CCFFCC",font="Verdana 10 bold",width=25)
B_open_cotab_file.grid(row=0,column=0,columnspan=2)

# --- display cotab file name
L_cotab_fname = Label(panel3,textvariable=V_cotab_fname)
L_cotab_fname.grid(row=1,column=0,columnspan=2)

# --- Update color table graphics: 2,8-9
def update_cotab_graphics():
   line = Tcotab.get('1.0', END).splitlines()
   Can3.delete('all')
   Can3.create_rectangle(0,0,120,296,fill="white")
   Can3.create_rectangle(0,20,100,256+20,fill="black")# background for hist
   for i in range(0,257,32): # small right tic every 32
      Can3.create_line(100,i+20,105,i+20)
   for i in range(0,257,64): # larger right tic every 64
      Can3.create_line(100,i+20,110,i+20)
   Can3.create_text(60,286,text="0.0          1.0")
   Can3.create_text(60,10, text="0.0          1.0")
   rgb_string = 'rgb '+V_offset_cotab.get()
   rgb_string.strip()
   for i in range(len(line)):
      if rgb_string in line[i]: # found, say, "rgb 1"
         irgb = i+1 # line where 
         break
   rgb = line[irgb].split()
   v0 = 0; r0 = int(100.0*float(rgb[1])); g0 = int(100.0*float(rgb[2])); b0 = int(100.0*float(rgb[3]))
   while 1:
      irgb += 1
      rgb = line[irgb].split()
      v1 = int(rgb[0]); r1 = int(100.0*float(rgb[1]))
      g1 = int(100.0*float(rgb[2])); b1 = int(100.0*float(rgb[3]))
      Can3.create_line(r0,276-v0,r1,276-v1,fill="red",width=4)
      Can3.create_line(g0,276-v0,g1,276-v1,fill="green",width=2)
      Can3.create_line(b0,276-v0,b1,276-v1,fill="blue",width=1)
      v0=v1; r0=r1; g0=g1; b0=b1
      if v0 == 255:
         break
   
   Can4.delete('all')
   Can4.create_rectangle(0,0,120,296,fill="gray")
   Can4.create_rectangle(0,20,100,256+20,fill="white")# background for hist
   for i in range(0,257,32): # small right tic every 32
      Can4.create_line(100,i+20,105,i+20)
   for i in range(0,257,64): # larger right tic every 64
      Can4.create_line(100,i+20,110,i+20)
   Can4.create_text(60,286,text="0.0          1.0")
   Can4.create_text(60,10, text="0.0          1.0")
   alpha_string = 'alpha '+V_offset_cotab.get()
   alpha_string.strip()
   for i in range(len(line)):
      if alpha_string in line[i]: # found, say, "rgb 1"
         ialp = i+1 # line where 
         break
   alp = line[ialp].split()
   v0 = 0; a0 = int(100.0*float(alp[1]))
   while 1:
      ialp += 1
      alp = line[ialp].split()
      v1 = int(alp[0]); a1 = int(100.0*float(alp[1]))
      Can4.create_line(a0,276-v0,a1,276-v1,fill="black",width=2)
      v0=v1; a0=a1
      if v0 == 255:
         break
   
B_cotab_graphics = Button(panel3,text="Update cotab Graphics",command=update_cotab_graphics,bg="#CCFFCC",font="Verdana 10 bold",width=25)
B_cotab_graphics.grid(row=2,column=0,columnspan=2)

# --- offset cotab: 3,8-9
L_offset_cotab = Label(panel3,text="cotab offset=").grid(row=3,column=0) 

E_offset_cotab = Entry(panel3,textvariable=V_offset_cotab,width=5)
E_offset_cotab.grid(row=3,column=1)

# save cotab file
def save_cotab_file():
  cotab_fhandle = asksaveasfile(mode='w')
  save_text = str(Tcotab.get(1.0,END))
  cotab_fhandle.write(save_text)
  cotab_fhandle.close()
B_save_cotab_file = Button(panel3,text="Save cotab file as",command=save_cotab_file,bg="#CCFFCC",font="Verdana 10 bold",width=25)
B_save_cotab_file.grid(row=25,column=0,columnspan=2)


# ********* panel 4 of 5 *********************

panel4 = Frame(root)
panel4.grid(row=0,column=3,rowspan=2)
# canvas to display rendered data
Can5 = Canvas(panel4,width=400,height=400)
Can5.grid(row=0,column=0,columnspan=4)

def render():
   set_srend_vars()
   offset_cotab = c_int( int(V_offset_cotab.get()))
   srend.__srend_MOD_srend_render(byref(nV_in),byref(nV_out),byref(Vdim),
      byref(E),byref(V),byref(U),byref(alpha),byref(beta),byref(eyeRight),
      byref(clipx0),byref(clipx1),byref(clipy0),byref(clipy1),
      byref(clipz0),byref(clipz1),byref(pclip1),
      byref(pt),byref(pt_r),
      byref(clip0),byref(clip1),byref(nsh),
      byref(perspective),byref(srendtype),
      byref(dt),bytedata,byref(XN),byref(YN),byref(ZN),byref(Bd),
      byref(iNX),byref(iNY),byref(iNZ),
      byref(W),byref(H),byref(nR),byref(offset_cotab),
      filenames,byref(tiles_right),byref(tiles_down),
      byref(TARGid) )

# --- render button
def render_data():
   Can5.delete('all')
   fout = open("cotab.txt",'w')
   fout.write(Tcotab.get(1.0,END))
   fout.close()
   render()
   new_im = PhotoImage(file='ctl.ppm')
   Can5.delete("all")
   Can5.create_image(200,200,image=new_im)
   Can5.save_im = new_im # save ref
B_render_data = Button(panel4,text="Render",command=render_data,bg="#0000FF",fg="#FFFFFF",font="Verdana 10 bold",width=25)
B_render_data.grid(row=1,column=0,columnspan=4)

# --- Srend parameters ----
L_E = Label(panel4,text="Eye(x,y,z)=").grid(row=2,column=0) 
E_Ex = Entry(panel4,textvariable=V_Ex,width=5); E_Ex.grid(row=2,column=1)
E_Ey = Entry(panel4,textvariable=V_Ey,width=5); E_Ey.grid(row=2,column=2)
E_Ez = Entry(panel4,textvariable=V_Ez,width=5); E_Ez.grid(row=2,column=3)

L_V = Label(panel4,text="View<x,y,z>=").grid(row=3,column=0) 
E_Vx = Entry(panel4,textvariable=V_Vx,width=5); E_Vx.grid(row=3,column=1)
E_Vy = Entry(panel4,textvariable=V_Vy,width=5); E_Vy.grid(row=3,column=2)
E_Vz = Entry(panel4,textvariable=V_Vz,width=5); E_Vz.grid(row=3,column=3)

L_U = Label(panel4,text="Up<x,y,z>=").grid(row=4,column=0) 
E_Ux = Entry(panel4,textvariable=V_Ux,width=5); E_Ux.grid(row=4,column=1)
E_Uy = Entry(panel4,textvariable=V_Uy,width=5); E_Uy.grid(row=4,column=2)
E_Uz = Entry(panel4,textvariable=V_Uz,width=5); E_Uz.grid(row=4,column=3)

L_alpha = Label(panel4,text="(horz deg)alpha=").grid(row=5,column=0) 
E_alpha = Entry(panel4,textvariable=V_alpha,width=5); E_alpha.grid(row=5,column=1)
L_beta = Label(panel4,text="(vert deg)beta=").grid(row=5,column=2) 
E_beta = Entry(panel4,textvariable=V_beta,width=5); E_beta.grid(row=5,column=3)

L_clipx0 = Label(panel4,text="xclip near=").grid(row=6,column=0) 
E_clipx0 = Entry(panel4,textvariable=V_clipx0,width=5); E_clipx0.grid(row=6,column=1)
L_clipx1 = Label(panel4,text="xclip far=").grid(row=6,column=2) 
E_clipx1 = Entry(panel4,textvariable=V_clipx1,width=5); E_clipx1.grid(row=6,column=3)

L_clipy0 = Label(panel4,text="yclip near=").grid(row=7,column=0) 
E_clipy0 = Entry(panel4,textvariable=V_clipy0,width=5); E_clipy0.grid(row=7,column=1)
L_clipy1 = Label(panel4,text="yclip far=").grid(row=7,column=2) 
E_clipy1 = Entry(panel4,textvariable=V_clipy1,width=5); E_clipy1.grid(row=7,column=3)

L_clipz0 = Label(panel4,text="zclip near=").grid(row=8,column=0) 
E_clipz0 = Entry(panel4,textvariable=V_clipz0,width=5); E_clipz0.grid(row=8,column=1)
L_clipz1 = Label(panel4,text="zclip far=").grid(row=8,column=2) 
E_clipz1 = Entry(panel4,textvariable=V_clipz1,width=5); E_clipz1.grid(row=8,column=3)

L_clip0 = Label(panel4,text="clip near=").grid(row=9,column=0) 
E_clip0 = Entry(panel4,textvariable=V_clip0,width=5); E_clip0.grid(row=9,column=1)
L_clip1 = Label(panel4,text="clip far=").grid(row=9,column=2) 
E_clip1 = Entry(panel4,textvariable=V_clip1,width=5); E_clip1.grid(row=9,column=3)

L_pclip1 = Label(panel4,text="polar clip far=").grid(row=10,column=0) 
E_pclip1 = Entry(panel4,textvariable=V_pclip1,width=5); E_pclip1.grid(row=10,column=1)
L_pclip2 = Label(panel4,text="(far angle from View vector)").grid(row=10,column=2,columnspan=2)

L_perspective = Label(panel4,text="perspective=").grid(row=11,column=0) 
E_perspective = Entry(panel4,textvariable=V_perspective,width=5); E_perspective.grid(row=11,column=1)
L_perspective2 = Label(panel4,text="(0=spherical, 1=perspective)").grid(row=11,column=2,columnspan=2)

L_dt = Label(panel4,text="dt=").grid(row=12,column=0) 
E_dt = Entry(panel4,textvariable=V_dt,width=5); E_dt.grid(row=12,column=1)
L_dt2 = Label(panel4,text="(sampling increment in cell widths)").grid(row=12,column=2,columnspan=2)

L_pt = Label(panel4,text="pt(x,y,z)=").grid(row=13,column=0) 
E_ptx = Entry(panel4,textvariable=V_ptx,width=5); E_ptx.grid(row=13,column=1)
E_pty = Entry(panel4,textvariable=V_pty,width=5); E_pty.grid(row=13,column=2)
E_ptz = Entry(panel4,textvariable=V_ptz,width=5); E_ptz.grid(row=13,column=3)

L_pt_r = Label(panel4,text="pt_r=").grid(row=14,column=0) 
E_pt_r = Entry(panel4,textvariable=V_pt_r,width=5); E_pt_r.grid(row=14,column=1)
L_pt_r2 = Label(panel4,text="(radius to clip about pt)").grid(row=14,column=2,columnspan=2)

# <<<<<<<<<<< end panels >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>



# utilities ****************************************************************
# create cotabedit.txt as a self-contained default color table file
print "Creating a default color table file in Text window."
Tcotab.insert(END,"alpha 1\n")
Tcotab.insert(END,"0   0.0\n")
Tcotab.insert(END,"5   0.0\n")
Tcotab.insert(END,"36  0.0627\n")
Tcotab.insert(END,"72  0.148\n")
Tcotab.insert(END,"105 0.536\n")
Tcotab.insert(END,"133 1.0\n")
Tcotab.insert(END,"158 1.0\n")
Tcotab.insert(END,"196 0.328\n")
Tcotab.insert(END,"236 0.302\n")
Tcotab.insert(END,"244 0.105\n")
Tcotab.insert(END,"250 0.0\n")
Tcotab.insert(END,"255 0.0\n")
Tcotab.insert(END,"\n")
Tcotab.insert(END,"alpha 2\n")
Tcotab.insert(END,"0   0.0\n")
Tcotab.insert(END,"128 0.5\n")
Tcotab.insert(END,"255 1.0\n")
Tcotab.insert(END,"\n")
Tcotab.insert(END,"rgb 1\n")
Tcotab.insert(END,"0   0.0 0.0 0.0\n")
Tcotab.insert(END,"5   0.0 0.0 0.0\n")
Tcotab.insert(END,"36  0.0 0.0 0.2509804\n")
Tcotab.insert(END,"71  0.0 0.1176471 0.3137255\n")
Tcotab.insert(END,"105 0.0 0.7843137 1.0\n")
Tcotab.insert(END,"131 1.0 1.0 1.0\n")
Tcotab.insert(END,"158 1.0 1.0 0.0\n")
Tcotab.insert(END,"196 1.0 0.0 0.0\n")
Tcotab.insert(END,"244 0.5019608 0.0 0.0\n")
Tcotab.insert(END,"255 0.5019608 0.0 0.0\n")
Tcotab.insert(END,"\n")
Tcotab.insert(END,"rgb 2\n")
Tcotab.insert(END,"0   1.0 0.0 0.0\n")
Tcotab.insert(END,"128 0.0 1.0 0.0\n")
Tcotab.insert(END,"255 0.0 0.0 1.0\n")
Tcotab.insert(END,"\n")

# ************************** wait for user requests ************************************
root.mainloop()
