#!/usr/bin/env python

# this file is srend_all.py

# build        : gfortran Srend.F90 -DSREND_NOMPI -fPIC -shared -o Srend.so
# check names  : nm  Srend.so

from ctypes import *

def call_srend_all(in_Vdim,e1,e2,e3,v1,v2,v3,u1,u2,u3,in_alpha,in_beta,
                  in_clipx0,in_clipx1,in_clipy0,in_clipy1,in_clipz0,in_clipz1,
                  pt1,pt2,pt3,in_pt_r,in_clip0,in_clip1,
                  in_perspective,in_dt,
                  in_bytedata_filename,
                  in_XN,in_YN,in_ZN,in_Bd,in_iNX,in_iNY,in_iNZ,
                  in_W,in_H,in_filename_stringin):

# ----- open the library first

   try: srend = CDLL("./Srend.so") #load
   except (NameError,OSError): print "Srend.so not found"
   else: print "loaded Srend.so" # remove this if annoying, useful for debug

# ----- variables to pass to srend_render
   nV_in = c_int(1)
   nV_out = c_int(1)
   Vdim = c_int(in_Vdim)
   VecFloat = c_float*3
   E = VecFloat(e1,e2,e3)
   V = VecFloat(v1,v2,v3)
   U = VecFloat(u1,u2,u3)

   Alpha = c_float(in_alpha)
   Beta = c_float(in_beta)
   EyeRight = c_float(0.0)
   clipx0 = c_float(in_clipx0)
   clipx1 = c_float(in_clipx1)
   clipy0 = c_float(in_clipy0)
   clipy1 = c_float(in_clipy1)
   clipz0 = c_float(in_clipz0)
   clipz1 = c_float(in_clipz1)
   pclip1 = c_float(180.0)
   pt = VecFloat(pt1,pt2,pt3)
   pt_r = c_float(in_pt_r)
   clip0 = c_float(in_clip0)
   clip1 = c_float(in_clip1)
   nsh = c_int(1)

   perspective = c_int(in_perspective)
   srendtype = c_int(0)
   dt = c_float(in_dt)

   ByteArray = c_byte*( (2*in_Bd+in_XN)*(2*in_Bd+in_YN)*(2*in_Bd+in_ZN) )
   bytedata = ByteArray()

   XN = c_int(in_XN)
   YN = c_int(in_YN)
   ZN = c_int(in_ZN)
   Bd = c_int(in_Bd)
   iNX = c_int(in_iNX)
   iNY = c_int(in_iNY)
   iNZ = c_int(in_iNZ)

   W = c_int(in_W)
   H = c_int(in_H)
   nR = c_int(1)
   offset_cotab = c_int(1)

# note: pass the c_type pointer for strings, not a byref
   filenames = c_char_p(in_filename_stringin)

   tiles_right = c_int(1)
   tiles_down = c_int(1)
   TARGid = c_int(0)

# ---------------- open and read the data file ------------------
   FVhiret = open(in_bytedata_filename,"rb")
   FVhiret.readinto(bytedata)
   FVhiret.close()

# render, a very long parameter list
   srend.__srend_MOD_srend_render(byref(nV_in),byref(nV_out),byref(Vdim),byref(E),
      byref(V),byref(U),byref(Alpha), byref(Beta),byref(EyeRight),
      byref(clipx0),byref(clipx1),byref(clipy0),byref(clipy1),
      byref(clipz0),byref(clipz1),byref(pclip1),byref(pt),byref(pt_r),
      byref(clip0),byref(clip1),byref(nsh),
      byref(perspective),byref(srendtype),byref(dt),
      byref(bytedata),byref(XN),byref(YN),byref(ZN),byref(Bd),byref(iNX),
      byref(iNY),byref(iNZ),byref(W),byref(H),byref(nR),
      byref(offset_cotab),filenames,byref(tiles_right),byref(tiles_down),
      byref(TARGid) )

# done

