/**
 * Declares all the basic functions a vector 
 * should support in order to be used with Matrix
 * @version 19.09.2007
 * @author Michael J. Beer (mibeer@uni-osnabrueck.de)
 * Copyright (C) 2007 Michael Beer 
 */
/*      
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA. */


#ifndef BASEVECTOR_H_
#define BASEVECTOR_H_

#include <cassert>

namespace STAF
{
/**
 * A class that declares all the basic functions that are 
 * needed by a Vector - class for  being used with the 
 * Matrix - class
 * Every vector type that is intended to be used with 
 * Matrix should be derived from that class having the 
 * USE_VIRTUAL_FUNCTIONS option enabled at least during 
 * debugging
 * @see Matrix
 * @see USE_VIRTUAL_FUNCTIONS
 */
template<class storageType> class BaseVector
  {

public:

    /**
     * creates a Vector object with given length
     * @param len desired length
     */
    BaseVector<storageType>(size_t len)
      {
      }
    ;

    /**
     * creates a Vector object with given length and inits all entries
     * @param len desired length
     * @param filling the initial filling of the entries
     */
    BaseVector<storageType>(size_t len, storageType filling)
      {
      }
    ;

    /**
     * Copyconstructor
     */
    BaseVector<storageType>(const BaseVector<storageType> &vec)
      {
      }
    ;

    virtual ~BaseVector<storageType>()
      {
      }
    ;
    /**
     * returns length of the vector
     * @return Length
     */
    virtual size_t size(void) const = 0;

    /** 
     * returns desired entry
     * @param no number of the entry
     * @return the entrie s value
     */
    virtual storageType at(const unsigned int no) const = 0;

    /**
     * sets desired entry to value
     * @param no number of desierd entry
     * @value the new value
     */
    virtual void assign(unsigned int no, storageType value) = 0;
    
    /**
     * compares with another vector entry by entry
     * @param vec the other vector
     */
    virtual bool operator==(const BaseVector<storageType> &vec) const = 0;

protected:

    /**
     * delete actual data structure
     */
    virtual void destroy(void) = 0;

    /**
     * resize vector
     * data structure must have been destroyed before!
     * @param n new length of vector
     */
    virtual void resize(size_t n) = 0;

  };
}
;
#endif /*BASEVECTOR_H_*/
