/* callbacks.h -- prototypes of callbacks for the station-info GUI.
 *
 * Copyright (C) 2001 John Kodis <kodis@jagunet.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gnome.h>
#include <fcc.h>

void fatal_need_for_data(void);
void search_set_widget_state(Search *search, GtkWidget *station_info);

void on_open_activate(GtkMenuItem *menuitem, void *user_data);
void on_save_activate(GtkMenuItem *menuitem, void *user_data);
void on_save_as_activate(GtkMenuItem *menuitem, void *user_data);
void on_exit_activate(GtkMenuItem *menuitem, void *user_data);
void on_preferences_activate(GtkMenuItem *menuitem, void *user_data);
void on_about_activate(GtkMenuItem *menuitem, void *user_data);

void on_search_button_clicked(GtkButton *button, void *user_data);
void on_station_info_destroy(GtkObject *object, void *user_data);

void on_clist_click_column(GtkCList *clist, gint column, void *user_data);
int on_clist_button_release_event(GtkWidget *widget,
  GdkEventButton *event, void *user_data);

void on_strongest_radiobutton_toggled(GtkToggleButton *tb, void *user_data);
void on_highest_radiobutton_toggled(GtkToggleButton *tb, void *user_data);
void on_nearest_radiobutton_toggled(GtkToggleButton *tb, void *user_data);

void on_strongest_toggled(GtkToggleButton *togglebutton, void *user_data);
void on_highest_toggled(GtkToggleButton *togglebutton, void *user_data);
void on_nearest_toggled(GtkToggleButton *togglebutton, void *user_data);

void on_print1_activate(GtkMenuItem *menuitem, void *user_data);
void on_preferences1_activate(GtkMenuItem *menuitem, void *user_data);
void on_print_activate(GtkMenuItem *menuitem, void *user_data);
void on_preferences_activate(GtkMenuItem *menuitem, void *user_data);
void on_details_close_button_clicked(GtkButton *button, void *user_data);
void on_help_activate(GtkMenuItem *menuitem, void *user_data);
