/* station-info-call-loc -- makess callsigns.loc file of station locations.
 *
 * Copyright (C) 2002 John Kodis <kodis@jagunet.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <locale.h>
#include <fcc.h>
#include <stdio.h>
#include <string.h>
#include <utils.h>

typedef struct
{ 
  int n;
  double lat, lon;
}
Cloc;

static void
cloc_print(void *v_key, void *v_cloc, void *unused)
{
  const char *key = v_key;
  const Cloc *cloc = v_cloc;

  if (strlen(key) > 10)
    fatal("Callsign exceeds 10 chars: %s", key);
  printf("%s:%.3f:%.3f\n",
    key, rad2deg(cloc->lat), rad2deg(cloc->lon));
}

static void
callsign_locations(Sinfo **sinfos, int recs, char *band)
{
  int r;
  char *call;
  Cloc *cloc;
  GHashTable *hash = g_hash_table_new(g_str_hash, g_str_equal);

  for (r = 0; r < recs; r++)
    {
      Sinfo *sinfo = sinfos[r];

      if (sinfo->sloc.lat == 0 && sinfo->sloc.lon == 0) continue;
      if (!sinfo->fac || !sinfo->fac->callsign) continue;
      call = sinfo->fac->callsign;
      if (!*call) continue;
      if (strcasecmp(call, "new") == 0) continue;
      if (strcasecmp(call, "none") == 0) continue;
      if (strspn(call, "0123456789") > 2) continue;

      cloc = g_hash_table_lookup(hash, call);
      if (cloc == NULL)
	{
	  cloc = malloc(sizeof(*cloc));
	  g_hash_table_insert(hash, call, cloc);
	  cloc->n = 0;
	}
      cloc->n ++;
      cloc->lat = rot2rad(sinfo->sloc.lat);
      cloc->lon = rot2rad(sinfo->sloc.lon);
    }

  g_hash_table_foreach(hash, cloc_print, NULL);
  //printf("%s: %d callsigns\n", band, g_hash_table_size(hash));
}

/*
 * main -- for the gen-callsigns-loc program.
 */
int
main(int argc, char **argv)
{
  Search unused;
  setlocale(LC_ALL, "");
  fcc_init(&unused, argc, argv);
  fcc_ingest(PKGDATADIR, NULL);

  callsign_locations(am, am_recs, "AM");
  callsign_locations(fm, fm_recs, "FM");
  callsign_locations(tv, tv_recs, "TV");
    
  return EXIT_SUCCESS;
}
