#! /bin/sh

LANG=C
PKGDATADIR="@pkgdatadir@"
CDBS_HOME=http://ftp.fcc.gov/Bureaus/MB/Databases/cdbs

# Create the data file directory if it doesn't already exist.
test -d ${PKGDATADIR} || mkdir ${PKGDATADIR}

# Fetch and de-htmlify the database description file.
cdbs_fetch() { wget -nv -N -P ${PKGDATADIR} $*; }
cdbs_fetch ${CDBS_HOME}/_readme.html
mv -f ${PKGDATADIR}/_readme.html ${PKGDATADIR}/README.html
links -dump ${PKGDATADIR}/README.html | sed 's/^ *//' >${PKGDATADIR}/README

# Fetch all the required FCC database files.
CDBS_FILES="application facility ant_make ant_pattern am_towers \
            am_ant_sys fm_eng_data tv_eng_data"
for FILE in ${CDBS_FILES}
do
  cdbs_fetch ${CDBS_HOME}/${FILE}.zip
  mv -f ${PKGDATADIR}/${FILE}.zip ${PKGDATADIR}/${FILE}.dat.gz &&
  gzip -f -d ${PKGDATADIR}/${FILE}.dat.gz
done

# Generate the station index files used to speed searches.
station-info-gen-index

# Generate the callsigns.loc file used to get the location of a callsign.
station-info-call-loc | sort -f > ${PKGDATADIR}/callsigns.loc

# Fetch the US Census Bureau's zipcode gazetteer, and generate the
# zipcode.loc file used to get the location of a zip code.
wget -nv -O- http://www.census.gov/ftp/pub/tiger/tms/gazetteer/zcta5.zip |
  gzip -dc | cut -c 3-7,137-156 | awk '{printf "%s:%.3f:%.3f\n", $1,$2,$3}' |
  sort -f > ${PKGDATADIR}/zipcodes.loc

# Fetch the US Census Bureau's place name gazetteer, and generate the
# places2k.loc file used to get the location of a town or city in the US.
wget -nv -O- http://www.census.gov/ftp/pub/tiger/tms/gazetteer/places2k.zip |
  gzip -dc | perl -we '
use strict;
my $line = 0;
while (<>) {
    $line ++;
    (my ($state, $city, $pop, $homes, $area, $lat, $lon) =
     m/^(..).{7}(.{64})(.{9})(.{9})(.{14}).{38}(.{10})(.{11}).$/) 
	|| die "Mismatch on line $line, $_";
    $city =~ s/ *$//;
    $city =~ s/ (CDP|city|town|village|borough|municipality)$//;
    $city =~ s/ (\(balance\)|zona urbana|comunidad)$//;
    if ($pop >= 0) {
	printf "%s:%s:%d:%.3f:%.3f\n", $city, $state, $pop, $lat, $lon;
    }
}
' | sort -f > ${PKGDATADIR}/places2k.loc
