#! /usr/bin/perl -w
#
# summary.cgi -- generate a summary web table of all stations.
#
# Copyright (C) 2001-2003, John Kodis <john@kodis.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of version 2 of the GNU General Public License as
# published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

use strict;
use CGI;
use Paths;

print "Content-type: text/html\n\n",
    "<html> <head><title> Station Information Summary Page </title></head>\n",
    "<body> <h1> Summary Page </h1>\n";

my $query = new CGI;
my %param = $query->Vars;

my @bands = ();
my $am    = $param{'am'} && push(@bands, 'am');
my $fm    = $param{'fm'} && push(@bands, 'fm');
my $tv    = $param{'tv'} && push(@bands, 'tv');
my $dist  = $param{'dist'};
my $unit  = $param{'unit'} || "";
my $range = $param{'range'};
my $keep  = $param{'keep'};
my $loc   = $param{'loc'};
my $opts  = $param{'opts'};
my $sort  = $param{'sort'};

my @args = ( "--tsv" );
if (@bands)  { push(@args, "--band=" . join(',', @bands)); }
if ($dist)   { push(@args, "--distance=$dist$unit"); }
if ($keep)   { push(@args, "--keep=$keep"); }
if ($range)  { push(@args, "--range=$range"); }
if ($loc)    { push(@args, "--location=$loc"); }

# print "<p> ", join (' ', @args), "<p>\n";

my $kid = open(CHILD, "-|");
if (! $kid) {
    open(STDERR, ">&STDOUT") || die "can't dup stderr onto stdout";
    exec("$prefix/bin/station-info-cli", @args);
    exit 1;
}

my $first_line = <CHILD>;
if ($first_line !~ /^\d/) {
    print "<p> An error seems to have occurred. <pre>\n";
    print $first_line;
    while (<CHILD>) { print $_; }
    exit 1;
}

my ($found, $kept) = split(' ', $first_line);
print "<p> Showing $kept of $found stations found";
if ($dist) { print " within $dist $unit"; }
if ($loc)  { print " of $loc.\n"; }

print "<p> <table>\n" .
    "<tr><th>Channel<br>or Freq<th>Band<th>Flags<th>Callsign<th>Power<br>kW" .
    "<th>Distance<th span=2>Heading<th>Location</tr>\n";
while (<CHILD>) {
    my ($band, $fac_off, $eng_off,
	$corf, $service, $flags, $call, $power,
	$dist, $unit, $point, $heading, $state, $city) = split(/\t/, $_);
    print "<tr> <td> $corf </td><td> $service </td><td> $flags",
    "</td><td> <a href='$details_url?off=$band,$fac_off,$eng_off'> $call </a>",
    "</td><td> $power </td><td> $dist $unit",
    "</td><td> $point $heading </td><td> $state $city </td></tr>\n";
}
print "</table> </body> </html>\n";

# print "<pre>\n"; system "printenv";
# while (my ($k,$v) = each %param) { print "$k = $v\n"; }

exit 0;
