#!/usr/bin/perl -w

# Stopper    Executes a copy if a file contains " nan " in its last line
# 
# Version:   0.91  (2001-02-19)
#
# Copyright  (C) 2001 Francesco Poli, <e-frx@libero.it>
#                     Via Amici 19 50131 Firenze, Italy
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
# Note: This script should be usable under any Unix system with a Perl
#       interpreter. At least, I hope so...
# 
#

# parse command line arguments
if ( (@ARGV == 1) && ($ARGV[0] eq "--help") )
{
    print
    "Usage: stopper.pl TEXT SOURCE DEST [ IDLE TRIALS ]\n",
    "  or:  stopper.pl --help\n\n",
    'Periodically check text file TEXT for the presence of string " nan "'."\n",
    "in its last line.\n",
    "If the string is found, copy SOURCE to DEST and exit successfully.\n",
    "If TEXT length doesn't change for TRIALS periods, exit unsuccessfully.\n",
    "IDLE is the idle time in each period and must be specified in seconds.\n",
    "If IDLE and TRIALS are not specified, default values (1000 and 2) are",
    " used.\n\n",
    "With the option --help, display this help and exit.\n\n",
    "Stopper version 0.91, Copyright (C) 2001 Francesco Poli\n",
    "Stopper comes with ABSOLUTELY NO WARRANTY.\n",
    "This is free software, and you are welcome to redistribute it\n",
    "under certain conditions; read file `COPYING' for details.\n";
    exit 0;
}
elsif ( (@ARGV != 3) && (@ARGV != 5) )
{
    print "stopper.pl: wrong number of arguments\n";
    print "Try `stopper.pl --help' for more information.\n";
    exit 1;
}
else
{
    ($text, $source, $dest, $idle, $trials) = @ARGV;
    # default values of IDLE and TRIALS
    $idle   = 1000 unless $idle;
    $trials = 2    unless $trials;
}

# save TEXT length (in byte)
$oldlen = -s "$text";

$count = 0;

while ( $count < $trials )
{

    # do nothing for IDLE seconds
    sleep $idle;

    # extract last line from file TEXT
    $line = `tail -1 $text`;

    # check last line for the presence of the string " nan "
    if ( $line =~ / nan / )
    {
        `cp $source $dest`;
        exit 0;
    } 

    # save TEXT new length 
    $newlen = -s "$text";

    # check length changes
    if ( $newlen eq $oldlen )
    {
        $count++;
    }
    else
    {
        $count  = 0;
        $oldlen = $newlen;
    }

}

exit 1;

