#! /usr/bin/perl

#
#   Copyright (C) Heinz-Josef Claes (2009-2012)
#                 hjclaes@web.de
#
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.

#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

use Fcntl;
use Digest::MD5 qw(md5_hex);


# $0 comprProg fileToRead fileToSave md5RetFile
# ret:
#   0 ok
#   1 cannot open fileToRead
#   2 cannot exec comprProg
#   3 cannot write md5sum


my ($comprProg, $fileToRead, $fileToSave, $md5RetFile,
    @comprProgFlags) = @ARGV;


unless (sysopen(IN, $fileToRead, O_RDONLY))
{
    print STDERR "cannot open <$fileToRead> (", __FILE__, " ", __LINE__,  ")\n";
    exit 1;
}

unless (pipe_to_fork('COMP', $fileToSave, [$comprProg, @comprProgFlags]))
{
    print STDERR "cannot exec <$comprProg> (", __FILE__, " ", __LINE__,  ")\n";
    exit 2;
}
chmod 0700, $fileToSave;

my $md5 = Digest::MD5->new();
my ($buffer, $n, $size);
$size = 0;
while ($n = sysread(IN, $buffer, 4096))
{
    syswrite COMP, $buffer;
    $md5->add($buffer);
    $size += $n;
}
close(COMP);
close(IN);

open(MD5, '>', $md5RetFile)
    or exit 3;
print MD5 $md5->hexdigest(), "\n$size\n";
close(MD5);

exit 0;


########################################
sub pipe_to_fork
{
    my $parent = shift;
    my $stdout = shift;
    my $execProc = shift;   # proc + params in []

    my $child;
    pipe $child, $parent or die "pipe failed: $!";
    my $pid = fork();
    die "fork() failed: $!" unless defined $pid;
    if ($pid) # in the parent
    {
	close $child;
    }
    else  # in the client
    {
	close $parent;
	open(STDIN, "<&=" . fileno($child))
	    or die "cannot open STDIN";
	open(STDOUT, ">", $stdout)
	    or die "cannot open STDOUT";

	exec @$execProc;
    }
    $pid;
}
