import straw

class FeedDataRouter(object):
    def __init__(self, feed):
        straw.ImageCache.cache.signal_connect(straw.ImageUpdatedSignal,
                                              self.image_updated)
        self._feed = feed

        # stuff we are potentially waiting for
        self._wait_data = 0
        self._wait_images = {}

    # public parts
    def start_polling(self):
        self._wait_data = 1
        self.update_process_status()

    def route_no_data(self):
        self._wait_data = 0
        self._feed.error = None
        self.update_process_status()

    def route_all(self, header, parsed):
        self.route_data(header, parsed)
        self.route_extras()

    def route_data(self, header, parsed):
        if header:
            etag = header.getheader('etag')
            if etag is not None:
                etag = etag.strip()
                if etag != "":
                    self._feed.previous_etag = etag
        self._feed.channel_title = parsed.title
        self._feed.channel_description = parsed.description
        self._feed.channel_copyright = parsed.copyright
        self._feed.channel_link = parsed.link
        self._feed.channel_creator = parsed.creator
        parsed.items.reverse()
        self._feed.add_items(parsed.items)
        self._feed.error = None
        self._wait_data = 0
        self._feed.poll_done()

    def route_extras(self):
        try:
            for i in self._feed.items:
                for name in i.image_keys():
                    image = i.get_image(name)
                    if image.status == image.WAITING:
                        self._wait_images[image.url] = 1
        except Exception, ex:
            # if we don't get the images, we can probably still show
            # the text
            pass
        self.update_process_status()

    def set_error(self, error):
        self._wait_data = 0
        self._feed.error = error
        self.update_process_status()
        return

    # private parts

    def image_updated(self, signal):
        if signal.url in self._wait_images:
            del self._wait_images[signal.url]
        self.update_process_status()

    def update_process_status(self):
        length_images = len(self._wait_images)
        if self._wait_data or length_images:
            self._feed.process_status = self._feed.STATUS_POLLING
        else:
            self._feed.process_status = self._feed.STATUS_IDLE
