cvs_id = "$Id: SubscribeDialog.py,v 1.35 2003/11/30 00:49:34 juri Exp $"

import gobject
import gtk
import traceback 
import straw
from error import log
from xml.sax import saxutils

class AuthException(Exception):
    pass

class SubscribeDialog:
    COLUMN_SUBSCRIBE = 0
    COLUMN_TITLE = 1
    COLUMN_FEED = 2
    COLUMN_PARSEDSUMMARY = 3
    COLUMN_STATUS_FLAG = 4
    COLUMN_URL = 5

    def __init__(self, xml):
        self._window = xml.get_widget("subscribe_dialog")
        self._window.set_transient_for(straw.main_window.get_window())

        self._find_assistant = xml.get_widget("find_assistant")
        self._start_page = xml.get_widget("start_page")
        self._location_page = xml.get_widget("location_page")
        self._last_page = xml.get_widget("last_page")
        self._subscribe_site_entry = xml.get_widget("subscribe_site_entry")
        self._multiple_feed_page = xml.get_widget("multiple_feed_page")
        self._authentication_page = xml.get_widget("authentication_page")
        self._authentication_username_entry = xml.get_widget("subscribe_username_entry")
        self._authentication_password_entry = xml.get_widget("subscribe_password_entry")
        self._authentication_failure_label = xml.get_widget("subscribe_authentication_failure_label")
        self._subscribe_multiple_match_view = xml.get_widget("subscribe_multiple_match_view")

        nameFuncMap = {}

        for key in dir(self.__class__):
            if key[:3] == 'on_':
                nameFuncMap[key] = getattr(self, key)

        xml.signal_autoconnect(nameFuncMap)

        model = gtk.ListStore(gobject.TYPE_OBJECT, gobject.TYPE_STRING,
                              gobject.TYPE_PYOBJECT, gobject.TYPE_PYOBJECT, 
                              gobject.TYPE_BOOLEAN, gobject.TYPE_STRING)

        self._subscribe_multiple_match_view.set_model(model)
        self.create_columns(self._subscribe_multiple_match_view)

        self._feeds = {}
        self.reset_fields()

    def on_start_page_prepare(self, *args):
        self._start_page.emit_stop_by_name("prepare")
        self._find_assistant.set_buttons_sensitive(gtk.FALSE, gtk.TRUE, gtk.TRUE, gtk.TRUE)
    
    def on_start_page_next(self, *args):
        self._find_assistant.set_page(self._location_page)
        return gtk.TRUE

    def on_start_page_cancel(self, *args):
        self.hide()

    def on_location_page_prepare(self, *args):
        self._location_page.emit_stop_by_name("prepare")
        if not self._url:
            self._url = ""
        self._subscribe_site_entry.set_text(self._url)
        self._subscribe_site_entry.grab_focus()
        self._find_assistant.set_buttons_sensitive(gtk.TRUE, gtk.FALSE, gtk.TRUE, gtk.TRUE)
        if self._url and not self._err:
            self._find_assistant.set_buttons_sensitive(gtk.TRUE, gtk.TRUE, gtk.TRUE, gtk.TRUE)
            
    def on_location_page_next(self, widget, data):
        gtk.timeout_add(1, self.location_page_forward)
        return gtk.TRUE

    def on_location_page_cancel(self, *args):
        self.hide()

    def on_multiple_feed_page_cancel(self, *args):
        self.hide()
  
    def on_multiple_feed_page_prepare(self, *args):
        self._multiple_feed_page.emit_stop_by_name("prepare")
        self.display_feed_choices()
        next = gtk.TRUE
        if len(self._feeds) == 0:
          next = gtk.FALSE
        self._find_assistant.set_buttons_sensitive(gtk.TRUE, next, gtk.TRUE, gtk.TRUE)
    
    def on_multiple_feed_page_next(self, *args):
        self._find_assistant.set_page(self._last_page)
        return gtk.TRUE

    def on_authentication_page_next(self, *args):
        username = self._authentication_username_entry.get_text()
        password = self._authentication_password_entry.get_text()
        gtk.timeout_add(1, lambda: self.location_page_forward(username, password))
        return

    def on_authentication_page_cancel(self, *args):
        self.hide()

    def on_authentication_page_prepare(self, *args):
        self._authentication_page.emit_stop_by_name("prepare")
        self._authentication_username_entry.grab_focus()

    def on_last_page_prepare(self, *args):
        self._find_assistant.set_buttons_sensitive(gtk.TRUE, gtk.TRUE, gtk.TRUE, gtk.TRUE)
        if self._err:
            self._find_assistant.back.grab_focus()
        else:
            self._find_assistant.finish.grab_focus()

    def last_page_fill(self, *args):
        title = ""
        text = ""
        if self._err:
            title, text = self._err
        else:
            title = _("Feed Found")
            if (len(self._feeds) == 1):
                for f in self._feeds:
                    feed, ps = self._feeds[f]

                text = _("Press the Apply button if you want to subscribe to the feed below.\n\n")
                text += _("Title: %s \n") % feed.title

                if feed.channel_description != "":
                    text += _("Description: %s \n") % feed.channel_description
            else:
                text = _("Press the Apply button if you want to subscribe to the following feeds:\n\n")
                iter = self._feeds.itervalues()
                for f in self._feeds:
                    text += _("\t%s\n") % iter.next()[0].title

        self._last_page.set_title(title)
        self._last_page.set_text(text)
        self._find_assistant.set_show_finish(gtk.TRUE)
        if self._err:
            self._find_assistant.finish.hide()
        else:
            self._find_assistant.finish.show()

    def on_last_page_back(self, widget, data):
        self._find_assistant.set_show_finish(gtk.FALSE)
        if (not self._err) and (len(self._found_feeds) > 1):
            self._find_assistant.set_page(self._multiple_feed_page)
        else:
            self._find_assistant.set_page(self._location_page)
            self._authentication_failure_label.hide()
            self._authentication_times = 0
        return gtk.TRUE

    def on_last_page_finish(self, *args):
        self._find_assistant.set_show_finish(gtk.FALSE)
        for feed, ps in self._feeds.itervalues():
            straw.FeedList.get_instance().append(None, feed)
            feed.router.route_all(None, ps)
            feed.poll_done()
        self.hide()

    def on_last_page_cancel(self, *args):
        self._find_assistant.set_show_finish(gtk.FALSE)
        self.hide()

    def on_subscribe_site_entry_changed(self, *args):
        gtk.timeout_add(1, self.location_entry_changed)

    def location_entry_changed(self):
        text = self._subscribe_site_entry.get_text().strip()
        if text == "":
            self._find_assistant.set_buttons_sensitive(gtk.TRUE, gtk.FALSE, gtk.TRUE, gtk.TRUE)
        else:
            self._find_assistant.set_buttons_sensitive(gtk.TRUE, gtk.TRUE, gtk.TRUE, gtk.TRUE)

    def on_subscribe_site_entry_key_press_event(self, widget, event):
        if event.keyval == gtk.keysyms.Return:
            gtk.timeout_add(1, self.location_page_forward)
            return gtk.TRUE

    def on_subscribe_username_entry_changed(self, *args):
        gtk.timeout_add(1, self.authentication_entry_changed)

    def authentication_entry_changed(self):
        username = self._authentication_username_entry.get_text().strip()
        password = self._authentication_password_entry.get_text().strip()
        if username == "":
            self._find_assistant.set_buttons_sensitive(gtk.TRUE, gtk.FALSE, gtk.TRUE, gtk.TRUE)
        else:
            self._find_assistant.set_buttons_sensitive(gtk.TRUE, gtk.TRUE, gtk.TRUE, gtk.TRUE)

    def on_subscribe_username_entry_key_press_event(self, widget, event):
        if event.keyval == gtk.keysyms.Return:
            gtk.timeout_add(1, self.auth_forward)
            return gtk.TRUE

    def on_subscribe_password_entry_key_press_event(self, widget, event):
        if event.keyval == gtk.keysyms.Return:
            gtk.timeout_add(1, self.auth_forward)
            return gtk.TRUE

    def auth_forward(self):
        username = self._authentication_username_entry.get_text()
        password = self._authentication_password_entry.get_text()
        gtk.timeout_add(1, lambda: self.location_page_forward(
            username, password))

    def location_page_forward(self, username=None, password=None):
        url = self._subscribe_site_entry.get_text().strip()
        if self._url != url or (len(self._found_feeds) < 1 and not self._err):
            self._find_assistant.set_buttons_sensitive(gtk.FALSE, gtk.FALSE, gtk.FALSE, gtk.FALSE)
            self._feeds.clear()
            try:
                self._found_feeds = self.find_site(url, username, password)
            except AuthException:
                self._find_assistant.set_page(self._authentication_page)
                self._find_assistant.set_buttons_sensitive(
                    gtk.TRUE, username is not None, gtk.TRUE, gtk.TRUE)
                self._find_assistant.set_show_finish(gtk.FALSE)
                if self._authentication_times > 0:
                    self._authentication_failure_label.show()
                self._authentication_times += 1
                return
            self._authentication_username_entry.set_text("")
            self._authentication_password_entry.set_text("")
            self._url = url

        num_found = len(self._found_feeds)

        if num_found > 1:
            self._find_assistant.set_page(self._multiple_feed_page)
            return
        elif num_found == 1:
            feed = self._found_feeds[0][0]
            summary = self._found_feeds[0][1]
            self.add_feed(feed, summary)

        self._find_assistant.set_page(self._last_page)
        self.last_page_fill()

    def on_subscribe_dialog_delete_event(self, *args):
        self.hide()
        return gtk.TRUE

    def show(self, url=""):
        self._url = url
        self._start_page.show()
        self._last_page.show()
        self._window.show()
        self._find_assistant.next.grab_focus()

    def hide(self):
        self._find_assistant.set_page(self._start_page)
        self.reset_fields()
        self._window.hide()
        self._start_page.hide()
        self._last_page.hide()

    def reset_fields(self):
        self._url = ""
        self._feeds.clear()
        self._err = None
        self._found_feeds = []
        self._authentication_times = 0

    def create_columns(self, treeview):
        renderer = gtk.CellRendererToggle()
        column = gtk.TreeViewColumn(_('Subscribe'), renderer,
                                    active=self.COLUMN_STATUS_FLAG)
        treeview.append_column(column)
        renderer.connect('toggled', self.sticky_toggled)

        cname= _('Title')
        cnum = self.COLUMN_TITLE
        renderer = gtk.CellRendererText()
        column = gtk.TreeViewColumn(cname, renderer, markup = cnum)
        treeview.append_column(column)

    def sticky_toggled(self, cell, path):
        model = self._subscribe_multiple_match_view.get_model()
        iter = model.get_iter((int(path),))
        feed = model.get_value(iter, self.COLUMN_FEED)
        ps = model.get_value(iter, self.COLUMN_PARSEDSUMMARY)
        sticky = not model.get_value(iter, self.COLUMN_STATUS_FLAG)
        model.set(iter, self.COLUMN_STATUS_FLAG, sticky)

        next = gtk.TRUE
        if feed.id in self._feeds:
            self.remove_feed(feed.id)
            if len(self._feeds) < 1:
                next = gtk.FALSE
        else:
            self.add_feed(feed, ps)

        self._find_assistant.set_buttons_sensitive(gtk.TRUE, next, gtk.TRUE, gtk.TRUE)
        return gtk.TRUE


    def add_feed(self, feed, summary):
        self._feeds[feed.id] = (feed, summary)

    def remove_feed(self, id):
        del self._feeds[id]

    def parse_feed(self, data, feed):
        parsed = straw.SummaryParser.parse(data, feed)
        return parsed

    def display_feed_choices(self):
        model = self._subscribe_multiple_match_view.get_model()
        model.clear()
        for feed, ps in self._found_feeds:
            iter = model.append()
            escaped_text = "<b>%s</b>\n%s" % (saxutils.escape(feed.title), saxutils.escape(feed.channel_description))
            escaped_text = "%s\n%s" % (escaped_text.strip(), saxutils.escape(feed.access_info[0]))
            model.set(iter, self.COLUMN_TITLE, escaped_text,
                      self.COLUMN_FEED, feed, self.COLUMN_PARSEDSUMMARY, ps,
                      self.COLUMN_STATUS_FLAG, feed.id in self._feeds,
                      self.COLUMN_URL, feed.access_info[0])

    def find_site(self, site, username, password):
        self._err = None
        found = []

        try:
            found = straw.rssfinder.getFeeds(site, username, password)
        except IOError, e:
            if type(e.args) == type(()) and len(e.args) == 4:
                if e.args[0] == 'http error' and e.args[1] == 401:
                    raise AuthException()

            self._err = (_("Feed Not Found"),
                         (_("No feed was found in %s. Please make sure you typed the correct location.") % site))

        except Exception, e:
            log("caught an exception: ", e)
            traceback.print_exc()
            self._err = (_("Fatal Error"),
                         _("A fatal error occurred while processing this operation. Please report it to the maintainer. Error: %s") % e)

        if self._err: return []

        if len(found) < 1:
            self._err = (_("Feed Not Found"),
                        (_("No feed was found in %s. Please make sure you typed the correct location.") % site))
            return []

        try:
            feeds = []
            for url, data in found:
                feed = straw.create_new_feed("temporary feed", url, username, password)
                ps = self.parse_feed(data, feed)
                feed.title = straw.utils.convert_entities(ps.title).strip()
                feed.channel_description = straw.utils.convert_entities(ps.description).strip()
                feeds.append((feed, ps))
            return feeds
        except Exception, e:
            log("parse_feed: caught exception ", e)
            traceback.print_exc()
            self._err = (_("Fatal Error"),
                         _("A fatal error occurred while processing this operation. Please report it to the maintainer. Error: %s") % e)
            return []

