cvs_id = "$Id: LookupManager.py,v 1.11 2003/11/08 16:50:17 juri Exp $"

import time
import socket
import random
from error import log
try:
    import adns, ADNS
    _have_adns = True
except ImportError:
    log("No ADNS library found, using synchronous name lookups.")
    _have_adns = False

MAX_TIMES = 3

class NameFormatException(Exception):
    pass

if _have_adns:
    class MyQE(ADNS.QueryEngine):
        def lookup_a_record(self, name, callback, extra):
            self.submit(name, adns.rr.A, callback = callback, extra = extra)

    class LookupManager:
        namecache = {}
        queryengine = MyQE()

        def __init__(self, mintime=86400, maxtime=259200):
            self.mintime = mintime
            self.maxtime = maxtime

        def _lookup(self, name, callback, cbw):
            try:
                name = name.encode('ascii')
            except UnicodeError:
                raise NameFormatException, "Host names must be ASCII"
            now = time.time()
            ip = self.namecache.get(name, None)
            expiretime = 0
            if ip is not None:
                ip, expiretime = ip
                if now < expiretime:
                    cbw.cb(ip)
                    return
            self.queryengine.lookup_a_record(name, callback, cbw)

        def lookup(self, name, callback, data=None):
            cbw = CBWrapper(name, callback, data)
            self._lookup(name, self.adns_callback, cbw)
        
        def adns_callback(self, answer, qname, rr, flags, cbwrapper):
            now = int(time.time())
            ips = answer[3]
            ip = None
            if answer[1] and not ips:
                # we got a cname even though we asked for an a record
                self._lookup(answer[1], self.adns_callback, cbwrapper)
                return
            elif ips:
                ip = ips[0]
                self.namecache[qname] = (ip, now+random.randint(self.mintime,
                                                                self.maxtime))
            else:
                # try again
                if cbwrapper.times < MAX_TIMES:
                    cbwrapper.times += 1
                    self._lookup(cbwrapper.name, self.adns_callback, cbwrapper)
                    return
            cbwrapper.cb(ip)

        def poll(self, timeout=0.1):
            self.queryengine.run(timeout)

    class CBWrapper:
        def __init__(self, name, callback, data, times = 0):
            self.name = name
            self.data = data
            self.callback = callback
            self.times = 0

        def cb(self, ip):
            self.callback(self.name, ip, self.data)

else:
    class LookupManager:
        NameFormatException = NameFormatException
        namecache = {}

        def __init__(self, mintime=86400, maxtime=259200):
            self.mintime = mintime
            self.maxtime = maxtime

        def _lookup(self, name):
            now = time.time()
            ip = self.namecache.get(name, None)
            expiretime = 0
            if ip is not None:
                ip, expiretime = ip
                if now < expiretime:
                    return ip
            try:
                ip = socket.gethostbyname(name)
            except socket.error:
                ip = None
            now = int(time.time())
            self.namecache[name] = (ip, now + random.randint(self.mintime,
                                                             self.maxtime))
            return ip

        def lookup(self, name, callback, data=None):
            try:
                name = name.encode('ascii')
            except UnicodeError:
                raise NameFormatException, "Host names must be ASCII"
            ip = self._lookup(name)
            callback(name, ip, data)

        def poll(self, timeout=0.1):
            pass

lookupmanager_instance = None

def get_instance():
    global lookupmanager_instance
    if lookupmanager_instance is None:
        lookupmanager_instance = LookupManager()
    return lookupmanager_instance

