cvs_id = "$Id: MainWindow.py,v 1.107 2003/11/30 10:00:56 juri Exp $"

import StringIO

import gobject
import gtk
import gnome
import gtkhtml2
import gnome.ui
import pango
from gtk import glade
from xml.sax import saxutils

import straw
from error import log, logparam, logtb


class ExceptionView:
    def __init__(self, frame, label):
        self._frame = frame
        self._label = label

    def show_exception(self, exception):
        self._label.set_text(
            _("<b>An error occurred while reading this feed:</b>\n%s") %
              str(exception))
        self._label.set_property("use_markup", True)
        self._frame.show()
        return

    def hide(self):
        self._frame.hide()
        return

class DummyDocStream(StringIO.StringIO):
    def write_stream(self, s):
        self.write(s)

class ItemView:
    def __init__(self, item_view_container):
        self._item = None
        self._date_format = '%A, %d %B %Y %H:%M'
        self._encoding = straw.utils.get_locale(enc=True)
        self._mmgr = straw.MessageManager.get_instance()

        widget_tree = glade.get_widget_tree(item_view_container)
        self._scrolled_window = widget_tree.get_widget('html_scrolled_window')
        self._href_widget = gnome.ui.HRef(url='', text='')
        self._htmlview = gtkhtml2.View()
        self._document = gtkhtml2.Document()
        self._document.clear()

        self._document.connect("link-clicked", self.link_clicked)
        self._htmlview.connect("on_url", self.on_url)
        self._document.connect("request-url", self.request_url)
        self._htmlview.get_vadjustment().set_value(0)
        self._scrolled_window.set_hadjustment(self._htmlview.get_hadjustment())
        self._scrolled_window.set_vadjustment(self._htmlview.get_vadjustment())
        self._htmlview.set_document(self._document)
        self._scrolled_window.add(self._htmlview)
        self._scrolled_window.show_all()

        self._item_source_vbox = widget_tree.get_widget('item_source_vbox')
        widget_tree.get_widget('item_subscribe_hbox').pack_start(self._href_widget, expand=False, fill=False)

        widget_tree.signal_connect('on_source_subscribe_button_clicked',
                                   self.on_source_subscribe_button_clicked)

    def on_url(self, view, url):
        if url is not None:
            feed = straw.main.get_visible_feed()
            url = straw.utils.complete_url(url, feed.location)
            self._mmgr.post_message(url)
        return

    def link_clicked(self, document, link):
        link = link.strip()
        feed = straw.main.get_visible_feed()
        link = straw.utils.complete_url(link, feed.location)

        try:
            gnome.url_show(link)
        except Exception, ex:
            straw.hig_alert.reportError(_("Error Loading Browser"),
                                        _("Straw cannot find a browser to view this item. Please check your browser settings and try again."))
        return

    def request_url(self, document, url, stream):
        try:
            feed = straw.main.get_visible_feed()
            url = straw.utils.complete_url(url, feed.location)
            image = straw.ImageCache.cache[url]
            stream.write(image.get_data())
        except Exception, ex:
            log(ex)

        stream.close()
        return

    def on_source_subscribe_button_clicked(self, button, *data):
        f = straw.create_new_feed(self._item.source['text'],
                                  location = self._item.source['url'])
        category = straw.main.get_visible_category()
        fl = straw.FeedList.get_instance()
        if (category is not None) and (category not in straw.FeedCategoryList.get_instance().pseudo_categories):
            fl.append(category, f)
        else:
            fl.append(None, f)
        straw.main.poll([f])
        return

    def display_item(self, item):
        self._item = item
        self._document.clear()
        self._document.open_stream("text/html")
        html = (
            """<html><head>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <style type="text/css">
            q { font-style: italic;}
            blockquote { display: block; font-style: italic; }
            .stitle {background-color:transparent;font-size:small;font-weight:bold;}
            .sdate {font-size:small}
            .content {padding-left:10px;margin-top:10px;padding-bottom:10px;}
            </style>
            <title>title</title></head><body>""" +
                self.htmlify_item(item) +
                "</body></html>")
        html = html.encode('utf-8')
	self._document.write_stream(html)
        self._document.close_stream()
        va = self._scrolled_window.get_vadjustment()
        va.set_value(va.lower)
        if item.source is not None:
            self.show_item_source(item.source)
        else:
            self.hide_item_source()
        return

    def display_empty_feed(self, feed):
        self._document.clear()
        self._document.open_stream("text/html")
        self._document.write_stream(self.htmlify_empty_feed(feed))
        self._document.close_stream()
        self._item = None
        self.hide_item_source()
        return

    def htmlify_empty_feed(self, feed):
        return ("<html><head><title>title</title></head><body><p>" +
                   _("No data yet, need to poll first.") +
                "</p></body></html>")

    def htmlify_item(self, item):
        ret = []
        if item.title is not None:
            ret.append('<div class="stitle">%s</div>' % item.title)
        if item.pub_date is not None:
            timestr = straw.utils.format_date(item.pub_date,
                                              self._date_format, self._encoding)
            ret.append('<div class="sdate">%s</div>' % timestr)
        ret.append('<div class="content">')
        if item.description is not None:
            ret.append('%s ' % item.description)
        if item.fm_license != '' and item.fm_license is not None:
            ret.append('<p><b>%s:</b> %s</p>' % (_("Software license"), item.fm_license))
        if item.fm_changes != '' and item.fm_changes is not None:
            ret.append('<p><b>%s:</b> %s</p>' % (_("Changes"), item.fm_changes))
        if item.license_urls is not None:
            ret.append("<p>")
            for l in item.license_urls:
                ret.append('<a href="%s">%s</a> ' % (l, _("License")))
            ret.append('</p>')
        if item.publication_name is not None:
            ret.append('<p>')
            ret.append('<b>%s:</b> %s ' % (_("Publication"),
                                           item.publication_name))
            if item.publication_volume is not None:
                ret.append('%s' % item.publication_volume)
                if item.publication_number is not None:
                    ret.append('(%s)' % item.publication_number)
            if item.publication_section is not None:
                ret.append(' %s' % item.publication_section)
            if item.publication_starting_page is not None:
                ret.append(', %s %s' % (_("Page"),
                                        item.publication_starting_page))
            ret.append('</p>')
        ret.append('</div>')
        if item.creator is not None:
            ret.append('<p>%s: %s</p>' % (_("Posted by"), item.creator))
        if (item.link is not None):
            ret.append('<a href="%s">%s &gt;&gt;</a><br />' %
                       (item.link,_("Complete story")))
        if (item.guid is not None) and item.guidislink:
            ret.append('<a href="%s">%s &gt;&gt;</a><br />' %
                       (item.guid,_("Permalink")))

        return "".join(ret)

    def scroll_down(self):
        va = self._scrolled_window.get_vadjustment()
        old_value = va.get_value()
        new_value = old_value + va.page_increment
        limit = va.upper - va.page_size
        if new_value > limit:
            new_value = limit
        va.set_value(new_value)
        return new_value > old_value

    def show_item_source(self, source):
        url = straw.utils.get_url_location(source['url'])
        text = saxutils.escape(url)
        self._href_widget.set_text(text)
        self._href_widget.set_url(url)
        self._href_widget.show()
        self._item_source_vbox.show()

    def hide_item_source(self):
        self._href_widget.hide()
        self._item_source_vbox.hide()

class ItemList:
    COLUMN_TITLE = 0
    COLUMN_STICKY = 1
    COLUMN_ITEM = 2
    COLUMN_BOLD = 3
    COLUMN_STICKY_FLAG = 4
    COLUMN_POPUP = 5

    def __init__(self, widget):
        self._widget = widget

        model = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_OBJECT,
                              gobject.TYPE_PYOBJECT, gobject.TYPE_INT,
                              gobject.TYPE_BOOLEAN, gobject.TYPE_OBJECT)

        item_popup_menu_items = (
            (_("/Mark as _Unread"), None, self.on_menu_mark_as_unread_activate, 0, "<Item>"),)
        self._item_factory = gtk.ItemFactory(gtk.Menu, '<item_list_popup>')
        self._item_factory.create_items(item_popup_menu_items)
        self._item_popup = self._item_factory.get_widget('<item_list_popup>')
        self._widget.connect("popup-menu", self.on_popup_menu)
        self._widget.connect("button_press_event", self.on_button_press_event)

        widget.set_model(model)
        widget.set_rules_hint(False)

        self.create_item_selection_columns(self._widget)

        widget.get_selection().connect("changed", self.item_selection_changed)
        self._feed = None
        return

    def create_item_selection_columns(self, item_list_view):
        renderer = gtk.CellRendererToggle()
        column = gtk.TreeViewColumn(_('Keep'), renderer,
                                    active=self.COLUMN_STICKY_FLAG)
        column.set_resizable(gtk.TRUE)
        column.set_reorderable(gtk.TRUE)
        item_list_view.append_column(column)
        renderer.connect('toggled', self.sticky_toggled)

        renderer = gtk.CellRendererText()
        column = gtk.TreeViewColumn(_('Title'), renderer,
                                    text=self.COLUMN_TITLE,
                                    weight=self.COLUMN_BOLD)
        column.set_resizable(gtk.TRUE)
        column.set_reorderable(gtk.TRUE)
        item_list_view.append_column(column)

        return

    def sticky_toggled(self, cell, path):
        model = self._widget.get_model()
        iter = model.get_iter((int(path),))
        item = model.get_value(iter, self.COLUMN_ITEM)
        item.sticky = not item.sticky
        model.set(iter, self.COLUMN_STICKY_FLAG, item.sticky)

    def render_feed(self, feed):
        vitem = straw.main.get_visible_item()
        model = self._widget.get_model()
        selection = self._widget.get_selection()
        selection.unselect_all()
        model.clear()
        count = 0
        visible_iter = None
        for item in feed.items:
            if (not item.title_converted):
                item.title = straw.utils.convert_title(item.title, item.description)
                item.title_converted = True

            if item.seen:
                bold = pango.WEIGHT_NORMAL
            else:
                bold = pango.WEIGHT_BOLD

            iter = model.append()
            model.set(iter, self.COLUMN_TITLE, item.title,
                      self.COLUMN_ITEM, item,
                      self.COLUMN_BOLD, bold,
                      self.COLUMN_STICKY_FLAG, item.sticky,
                      self.COLUMN_POPUP, self._item_popup)
            if item is vitem:
                visible_iter = iter
        if visible_iter:
            self._widget.get_selection().select_iter(visible_iter)
        return len(feed.items)

    def display_feed(self, feed, select_first = 1):
        redisplay = self._feed is feed
        first_time = self._feed is None
        if not (first_time or redisplay):
            self._feed.signal_disconnect(straw.RefreshFeedDisplaySignal,
                                         self.feed_order_changed)
        self._feed = feed
        count = self.render_feed(feed)
        if (not redisplay) and count and select_first:
            self._widget.get_selection().select_path((0,))
        if not redisplay:
            feed.signal_connect(straw.RefreshFeedDisplaySignal,
                                self.feed_order_changed)
        return

    def feed_order_changed(self, event):
        if event.sender is self._feed:
            selection = self._widget.get_selection()
            liststore, iter = selection.get_selected()
            path = liststore.get_path(iter)
            item = self._widget.get_model()[path[0]][self.COLUMN_ITEM]
            self.render_feed(event.sender)
            selection.select_path(event.sender.get_item_index(item))

    def display_empty_feed(self, feed):
        self._widget.get_model().clear()

    def item_selection_changed(self, selection):
        s = selection.get_selected()
        if s:
            model, iter = s
            if iter is None:
                return
            path = model.get_path(iter)
            index = path[0]
            item = model[index][self.COLUMN_ITEM]
            if not straw.main.is_visible_item(item):
                self.display_item(item)

    def mark_item(self, item, index = None):
        if index is None:
            index = item.feed.get_item_index(item)
        model = self._widget.get_model()
        path = (index,)
        try:
            iter = model.get_iter(path)
        except ValueError:
            return
        if item.seen:
            weight = pango.WEIGHT_NORMAL
        else:
            weight = pango.WEIGHT_BOLD
        model.set_value(iter, self.COLUMN_BOLD, weight)
        return

    def select_item(self, item):
        index = item.feed.get_item_index(item)
        path = (index,)
        self._widget.get_selection().select_path(path)
        self._widget.set_cursor(path, None, 0)
        self._widget.scroll_to_cell(path, None, 0, 0.5, 0)

    def display_item(self, item):
        self.mark_item(item)
        straw.main.display_item(item)

    def on_popup_menu(self, *args):
        model, iter = self._widget.get_selection().get_selected()
        popup = model[model.get_path(iter)][self.COLUMN_POPUP]
        popup.popup(None, None, None, 0, 0)
        return 1

    def on_button_press_event(self, treeview, event):
        if event.button == 3:
            x = int(event.x)
            y = int(event.y)
            time = gtk.get_current_event_time()
            path = treeview.get_path_at_pos(x, y)
            if path is None:
                return 1
            path, col, cellx, celly = path
            treeview.grab_focus()
            treeview.set_cursor( path, col, 0)
            model, iter = treeview.get_selection().get_selected()
            popup = model[model.get_path(iter)][self.COLUMN_POPUP]
            popup.popup(None, None, None, event.button, time)
            return 1

    def on_menu_mark_as_unread_activate(self, *args):
        straw.main.get_visible_item().seen = False

class OfflineToggle:
    def __init__(self, widget):
        self._widget = widget
        widget_tree = glade.get_widget_tree(widget)
        for key in dir(self.__class__):
            if key[:3] == 'on_':
                widget_tree.signal_connect(key, getattr(self, key))
        self._widget.remove(self._widget.get_child())
        self._widget.add(gtk.Image())
        self._tooltips = gtk.Tooltips()

        self._config = straw.Config.get_instance()
        self._config.signal_connect(
            straw.OfflineModeChangedSignal, self.mode_changed)

    def show(self):
        if self._config.offline:
            imagename = "offline"
            tooltip = _("Straw is currently offline. Click to go online.")
            self._widget.set_active(1)
        else:
            imagename = "online"
            tooltip = _("Straw is currently online. Click to go offline.")
            self._widget.set_active(0)
        straw.main.show_image(self._widget.get_child(), imagename)
        self._tooltips.set_tip(self._widget, tooltip, tooltip)
        self._tooltips.enable()
        self._widget.show_all()

    def on_offline_toggle_toggled(self, *args):
        active = self._widget.get_active()
        if active != self._config.offline:
            self._config.offline = not self._config.offline

    def mode_changed(self, signal):
        self.show()

class Toolbar:
    def __init__(self,widget):
        widget_tree = glade.get_widget_tree(widget)
        self._widget = widget
        self._poll = widget_tree.get_widget('toolbar_poll_button')
        self._new = widget_tree.get_widget('toolbar_add_button')
        self._tooltips = gtk.Tooltips()

    def show_tips(self):
        poll = _("Refresh this category")
        new =  _("Subscribe")

        self._tooltips.set_tip(self._poll, poll, poll)
        self._tooltips.set_tip(self._new, new, new)
        self._tooltips.enable()

class FeedInfoDisplay:
    def __init__(self, widget):
        widget_tree = glade.get_widget_tree(widget)
        self._widget = widget
        self._title_hbox = widget_tree.get_widget('feed_info_title_hbox')
        self._link_display = gnome.ui.HRef(url='', text='')
        self._description_display = widget_tree.get_widget('feed_info_description')
        self._description_display.set_redraw_on_allocate(True)
        self._copyright_display = widget_tree.get_widget('feed_info_copyright')

        self._tooltips = gtk.Tooltips()
        self._title_hbox.pack_start(self._link_display,expand=gtk.FALSE,fill=gtk.FALSE,padding=6)

        self._config = straw.Config.get_instance()

    def show(self):
        self._widget.show()
        self.set_visibility(True)

    def hide(self):
        self._widget.hide()
        self.set_visibility(False)

    def set_visibility(self, mode):
        self._config.feed_info_visibility = mode

    def display_feed(self, feed):
        title = straw.utils.convert_entities(feed.channel_title)
        link = feed.channel_link
        if len(title) == 0:
            title = feed.title
        if len(title) == 0:
            title = feed.channel_url
        title = title.strip()
        if len(title) > 0:
            self._link_display.set_text(saxutils.escape(title))
            self._link_display.set_url(link)
            self._link_display.show()
        else:
            self._link_display.hide()

        description = feed.channel_description.strip()
        size = len(description)
        if size and description != title:
            if straw.utils.is_html(description):
                description = straw.utils.read_text(description, size)
            self._description_display.set_text(straw.utils.convert_entities(description))
            self._description_display.show()
        else:
            self._description_display.hide()

        copyright = feed.channel_copyright
        self._copyright_display.set_text(copyright)
        if len(copyright):
            self._copyright_display.show()
        else:
            self._copyright_display.hide()

    def set_size(self, size):
        w = max(size - 10, 0)
        window_height = self._config.main_window_size[1]
        max_height = window_height / 4
        for widget in (self._description_display,
                       self._copyright_display):
            widget.set_size_request(w, -1)
            if widget.size_request()[1] > max_height:
                widget.set_size_request(w, max_height)

class FindResultList:
    COLUMN_TITLE = 0
    COLUMN_FEED = 1
    COLUMN_ITEM = 2

    def __init__(self, widget):
        widget_tree = glade.get_widget_tree(widget)
        self._treeview = widget_tree.get_widget('find_results_treeview')
        self._countlabel = widget_tree.get_widget('find_results_count_display')
        model = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_STRING,
                              gobject.TYPE_PYOBJECT)
        self._treeview.set_model(model)
        self._treeview.set_rules_hint(gtk.TRUE)
        renderer = gtk.CellRendererText()
        column = gtk.TreeViewColumn('Title', renderer, text=self.COLUMN_TITLE)
        self._treeview.append_column(column)
        renderer = gtk.CellRendererText()
        column = gtk.TreeViewColumn('Feed', renderer, text=self.COLUMN_FEED)
        self._treeview.append_column(column)
        self._treeview.get_selection().connect("changed", self.item_selection_changed)
        self._find_interrupted = 0

    def render_results(self, items):
        model = self._treeview.get_model()
        model.clear()
        self._countlabel.set_text(_('%d items found') % len(items))
        i = 0
        for item in items:
            if self._find_interrupted:
                self._find_interrupted = 0
                break
            i += 1
            iter = model.append()
            title = ""
            if item.title is not None:
                title = item.title[:50]
            if title == "":
                title = straw.utils.read_text(item.description, 50) + "..."
            model.set(iter, self.COLUMN_TITLE, title,
                      self.COLUMN_FEED, item.feed.title,
                      self.COLUMN_ITEM, item)
            if i % 10 == 0:
                while gtk.events_pending():
                    gtk.mainiteration(gtk.FALSE)

    def item_selection_changed(self, selection):
        s = selection.get_selected()
        if s:
            model, iter = s
            if iter is None:
                return
            path = model.get_path(iter)
            index = path[0]
            item = model[index][self.COLUMN_ITEM]
            straw.main.display_item_unselected(item)

    def interrupt_find(self, signal):
        self._find_interrupted = 42

    def register_find_dialog(self, fd):
        fd.signal_connect(straw.FindInterruptSignal, self.interrupt_find)

class CategorySelector:
    def __init__(self, widget, func):
        # A function callback is required 
        self._widget = widget
        self.item_factory = gtk.ItemFactory(gtk.Menu, "<category_menu>")
        self._menu = None
        self._entries = None
        self.callback = func

    def display_categories(self):
        fclist = straw.FeedCategoryList.get_instance()
        selection = None
        if self._entries is not None:
            selection = self._entries[self._widget.get_history()][2].category
            for e in self._entries:
                self.item_factory.delete_item(e[0])
        self._entries = []
        class _catselhelper:
            def __init__(self, cat, fun):
                self.category = cat
                self.fun = fun

            def __call__(self, *a):
                self.fun(self.category, *a)

        selection_index = -1
        count = -1
        for cat in fclist:
            count += 1
            helper = _catselhelper(cat, self.callback)
            self._entries.append(("/" + cat.title, None, helper, 0, "<Item>"))
            if cat is selection:
                selection_index = count
        self.item_factory.create_items(self._entries)
        self._menu = self.item_factory.get_widget("<category_menu>")
        self._widget.set_menu(self._menu)
        if selection_index < 0:
            selection = fclist.all_category
            selection_index = count

        self._widget.set_history(selection_index)
        self.callback(selection)

    def set_selected(self, category):
        fclist = straw.FeedCategoryList.get_instance()
        allcats = fclist.user_categories + list(fclist.pseudo_categories)
        self._widget.set_history(allcats.index(category))

    def is_focused(self):
        return self._widget.is_focus()

    def popup(self):
        self._menu.popup(None, None, self.position, 0, gtk.get_current_event_time())

    def position(self, menu, *data): #menu, x, y, push_in, user_data):
        requisition = menu.get_child_requisition()
        log(str(requisition))
        menu_width = requisition[0]
        active = self._menu.get_active()

        alloc = self._widget.allocation
        log("widget allocation: %d, %d (%dx%d)" % (alloc.x, alloc.y,
                                                   alloc.width, alloc.height))
        alloc = self._widget.get_parent_window().get_position()
        log("window position: ", alloc)
        menu_xpos = self._widget.allocation.x + alloc[0]
        menu_ypos = self._widget.allocation.y + alloc[1]

        if active:
            requisition = active.get_child_requisition()
            menu_ypos -= requisition[1] / 2

        children = self._menu.children()

        for child in children:
            if active == child:
                break

            if child.flags() & gtk.VISIBLE:
                requisition = child.get_child_requisition()
                menu_ypos -= requisition[1]

        if self._widget.get_direction == gtk.TEXT_DIR_RTL:
            menu_xpos = menu_xpos + self._widget.allocation.width - menu_width

        #screen_width = self._widget.get_parent_window().screen.get_screen_width()

        if menu_xpos < 0:
            menu_xpos = 0
##         elif menu_xpos + menu_width > screen_width:
##             menu_xpos -= menu_xpos + menu_width - screen_width
        logparam(locals(), "menu_xpos", "menu_ypos")
        return menu_xpos, menu_ypos, True

#######################
# displayadapters for feeds and categories
class DisplayAdapter(object, straw.SignalEmitter):
    def __init__(self, ob):
        self._ob = ob
        straw.SignalEmitter.__init__(self)
        self.initialize_slots(straw.ItemReadSignal,
                              straw.ItemsAddedSignal,
                              straw.AllItemsReadSignal,
                              straw.FeedPolledSignal,
                              straw.FeedStatusChangedSignal)

    def equals(self, ob):
        return self._ob is ob

class FeedDisplayAdapter(DisplayAdapter):
    """Adapter for displaying Feed objects in the tree"""
    def __init__(self, ob):
        DisplayAdapter.__init__(self, ob)
        ob.signal_connect(straw.ItemReadSignal, self.resend_signal)
        ob.signal_connect(straw.ItemsAddedSignal, self.resend_signal)
        ob.signal_connect(straw.AllItemsReadSignal, self.resend_signal)
        ob.signal_connect(straw.FeedPolledSignal, self.resend_signal)
        ob.signal_connect(straw.FeedStatusChangedSignal, self.resend_signal)

    def disconnect(self):
        self._ob.signal_disconnect(
            straw.ItemReadSignal, self.resend_signal)
        self._ob.signal_disconnect(
            straw.ItemsAddedSignal, self.resend_signal)
        self._ob.signal_disconnect(
            straw.AllItemsReadSignal, self.resend_signal)
        self._ob.signal_disconnect(
            straw.FeedPolledSignal, self.resend_signal)
        self._ob.signal_disconnect(
            straw.FeedStatusChangedSignal, self.resend_signal)

    def resend_signal(self, signal):
        signal.sender = self
        self.emit_signal(signal)

    def get_title(self):
        return self._ob.title

    def get_unread(self):
        nu = self._ob.number_of_unread
        if nu != 0:
            return ("(%s)" % nu, nu)
        else:
            return (" ", nu)

    def get_status_icon(self):
        if self._ob.process_status is not straw.Feed.STATUS_IDLE:
            return (1, gtk.STOCK_EXECUTE)
        elif self._ob.error:
            return (1, gtk.STOCK_DIALOG_ERROR)
        return (0, None)

    def is_visible(self):
        return self._ob is straw.main.get_visible_feed()

    def get_feed(self):
        return self._ob

    title = property(get_title)
    unread = property(get_unread)
    contents = property(lambda x: None)
    status_icon = property(get_status_icon)
    visible = property(is_visible)
    feed = property(get_feed)
    open = property(lambda x: None)

def create_adapter(ob):
    if isinstance(ob, straw.Feed):
        return FeedDisplayAdapter(ob)

class FeedListView:
    COLUMN_NAME = 0
    COLUMN_UNREAD = 1
    COLUMN_BOLD = 2
    COLUMN_STATUS_FLAG = 3
    COLUMN_STATUS_PIXBUF = 4
    COLUMN_OBJECT = 5
    COLUMN_ALLOW_CHILDREN = 6
    COLUMN_POPUP = 7
    
    def __init__(self, widget):
        widget_tree = glade.get_widget_tree(widget)
        self._widget = widget
        model = gtk.TreeStore(
            gobject.TYPE_STRING, gobject.TYPE_STRING, 
            gobject.TYPE_INT, gobject.TYPE_BOOLEAN,
            gobject.TYPE_STRING, gobject.TYPE_PYOBJECT,
            gobject.TYPE_BOOLEAN, gobject.TYPE_OBJECT)
        self._widget.set_model(model)
        self._widget.set_rules_hint(False)
        self._widget.set_search_column(0)
        self.create_feed_selection_columns(widget)

        feed_popup_menu_items = (
            (_("/_Refresh"), None, self.on_menu_poll_selected_activate, 0, "<Item>"),
            (_("/_Mark as Read"), None, self.on_menu_mark_all_as_read_activate, 0, "<Item>"),
            (_("/sep"), None, None, 0, "<Separator>"),
            (_("/_Remove"), None, self.remove_selected_feed, 0, "<Item>"),
            ("/sep", None, None, 0, "<Separator>"),
            (_("/P_roperties"), None, self.display_properties_feed, 0, "<Item>"))

        self._item_factory = gtk.ItemFactory(gtk.Menu, '<feed_list_popup>')
        self._item_factory.create_items(feed_popup_menu_items)
        self._feed_popup = self._item_factory.get_widget('<feed_list_popup>')

        self._widget.connect("popup-menu", self.on_popup_menu)
        self._widget.connect("button_press_event", self.on_button_press_event)
        self._widget.get_selection().connect(
            "changed", self.feed_selection_changed, self.COLUMN_OBJECT)
        self.setup_dnd()

    def get_widget(self):
        return self._widget

    def create_feed_selection_columns(self, feed_list_view):
        column = gtk.TreeViewColumn()
        column.set_title("_Subscriptions")

        status_renderer = gtk.CellRendererPixbuf()
        column.pack_start(status_renderer, gtk.FALSE)
        column.add_attribute(status_renderer, "stock_id", self.COLUMN_STATUS_PIXBUF)
        column.add_attribute(status_renderer, "visible", self.COLUMN_STATUS_FLAG)

        title_renderer = gtk.CellRendererText()
        column.pack_start(title_renderer, gtk.TRUE)
        column.add_attribute(title_renderer, "text", self.COLUMN_NAME)
        column.add_attribute(title_renderer, "weight", self.COLUMN_BOLD)

        unread_renderer = gtk.CellRendererText()
        column.pack_end(unread_renderer, gtk.FALSE)
        column.add_attribute(unread_renderer, "text", self.COLUMN_UNREAD)
        column.add_attribute(unread_renderer, "weight", self.COLUMN_BOLD)

        feed_list_view.append_column(column)

    def block_row_signals(self):
        self.row_signals_blocked = True

    def unblock_row_signals(self):
        self.row_signals_blocked = False
        
    def on_popup_menu(self, *args):
        model, iter = self._widget.get_selection().get_selected()
        popup = model[model.get_path(iter)][self.COLUMN_POPUP]
        popup.popup(None, None, None, 0, 0)
        return 1

    def on_button_press_event(self, treeview, event):
        if event.button == 3:
            x = int(event.x)
            y = int(event.y)
            time = gtk.get_current_event_time()
            path = treeview.get_path_at_pos(x, y)
            if path is None:
                return 1
            path, col, cellx, celly = path
            treeview.grab_focus()
            treeview.set_cursor( path, col, 0)
            model, iter = treeview.get_selection().get_selected()
            popup = model[model.get_path(iter)][self.COLUMN_POPUP]
            popup.popup(None, None, None, event.button, time)
            return 1

    def on_menu_poll_selected_activate(self, *args):
        feed = [straw.main.get_visible_feed()]
        straw.main.poll(feed)

    def on_menu_mark_all_as_read_activate(self, *args):
        straw.main.mark_as_read()

    def display_properties_feed(self, *args):
        straw.main.show_feed_properties(straw.main.get_visible_feed())

    def get_location(self):
        selection = self._widget.get_selection()
        model, iter = selection.get_selected()
        if iter is None:
            return None
        return model.get_path(iter)

    def remove_selected_feed(self, *args):
        response = straw.hig_alert.confirmDelete(_("Delete subscription?"),
                    _("Deleting a subscription will remove it from your subscription list."))
        if (response == gtk.RESPONSE_YES):
           selection = self._widget.get_selection()
           model, iter = selection.get_selected()
           if iter:
               path = model.get_path(iter)
               adapter = model.get_value(iter, self.COLUMN_OBJECT)
               feedlist = straw.FeedList.get_instance()
               del feedlist[feedlist.index(adapter.feed)]

        return

    def feed_selection_changed(self, selection, column):
        model, iter = selection.get_selected()
        if iter is None:
            return
        adapter = model.get_value(iter, column)
        if adapter is not None and adapter.feed is not None:
            straw.main.display_feed(adapter.feed)
        return

    def display_feed_unselected(self, feed):
        self._first_selection_done = True
        path = straw.main.get_visible_category().index(feed)
        self._widget.set_cursor(
            path, self._widget.get_column(0), 0)
        self._widget.get_selection().select_path(path)

    def _display_feeds(self, feeds, parent):
        #logtb("enter")
        model = self._widget.get_model()
        for f in feeds:
            adapter = create_adapter(f)

            iter = model.append(parent)
            model.set(iter,
                      self.COLUMN_NAME, adapter.title,
                      self.COLUMN_OBJECT, adapter,
                      self.COLUMN_ALLOW_CHILDREN, False)
            adapter.signal_connect(straw.ItemReadSignal,
                                straw.main_window.item_read, iter)
            adapter.signal_connect(straw.AllItemsReadSignal,
                                straw.main_window.all_items_read, iter)
            adapter.signal_connect(straw.ItemsAddedSignal,
                                   straw.main_window.feed_updated, iter)
            adapter.signal_connect(straw.FeedPolledSignal,
                                   straw.main_window.feed_updated, iter)
            adapter.signal_connect(straw.FeedStatusChangedSignal,
                                   straw.main_window.feed_updated, iter)
            new_string, new = adapter.unread
            weight = (pango.WEIGHT_NORMAL, pango.WEIGHT_BOLD)[new > 0]
            status, pixbuf = adapter.status_icon
            model.set(iter,
                      self.COLUMN_UNREAD, new_string,
                      self.COLUMN_BOLD, weight,
                      self.COLUMN_STATUS_FLAG, status,
                      self.COLUMN_STATUS_PIXBUF, pixbuf,
                      self.COLUMN_POPUP, self._feed_popup)

            if adapter.visible:
                self._widget.get_selection().select_iter(iter)

    def display_feeds(self, feeds, visible_feed):
        self.block_row_signals()
        model = self._widget.get_model()
        for row in model:
            row[self.COLUMN_OBJECT].disconnect()
        model.clear()
        self._display_feeds(feeds, None)
        self._widget.columns_autosize()
        self.unblock_row_signals()

    def all_items_read(self, signal, feed_index):
        model = self._widget.get_model()
        new = signal.sender.unread
        weight = (pango.WEIGHT_NORMAL, pango.WEIGHT_BOLD)[new[1] > 0]
        model[feed_index][self.COLUMN_UNREAD] = new[0]
        model[feed_index][self.COLUMN_BOLD] = weight
        self._widget.queue_draw()

    def item_read(self, signal, iter):
        model = self._widget.get_model()
        feed_index = model.get_path(iter)
        new = signal.sender.unread
        weight = (pango.WEIGHT_NORMAL, pango.WEIGHT_BOLD)[new[1] > 0]
        model[feed_index][self.COLUMN_UNREAD] = new[0]
        model[feed_index][self.COLUMN_BOLD] = weight
        self._widget.queue_draw()

    def feed_updated(self, signal, feed_index):
        model = self._widget.get_model()
        new = signal.sender.unread
        #logtb("new for %s (%s): %s" % (str(signal.sender.title), model.get_path(feed_index), new))
        weight = (pango.WEIGHT_NORMAL, pango.WEIGHT_BOLD)[new[1] > 0]
        model[feed_index][self.COLUMN_UNREAD] = new[0]
        model[feed_index][self.COLUMN_BOLD] = weight
        status, pixbuf = signal.sender.status_icon
        model[feed_index][self.COLUMN_STATUS_FLAG] = status
        if pixbuf:
            model[feed_index][self.COLUMN_STATUS_PIXBUF] = pixbuf
        self._widget.queue_draw()

    def disable_feed_selection(self):
        self._widget.set_sensitive(0)

    def enable_feed_selection(self):
        self._widget.set_sensitive(1)

    def row_expanded(self, widget, iter, path, *data):
        #logparam(locals(), "path")
        self._widget.get_model()[path][self.COLUMN_OBJECT].open = True

    def row_collapsed(self, widget, iter, path, *data):
        #logparam(locals(), "path")
        self._widget.get_model()[path][self.COLUMN_OBJECT].open = False

        
###############################
## DnD
## this code has been copied more or less straight from examples by
## Walter Anger and Doug Quale on the pygtk mailing list,
## see the thread starting at
## http://www.daa.com.au/pipermail/pygtk/2003-November/006304.html
###############################
    
    drop_yes = ("drop_yes", gtk.TARGET_SAME_WIDGET, 0)
    drop_no = ("drop_no", gtk.TARGET_SAME_WIDGET, 0)

    def setup_dnd(self):
        """Setup a treeview to move rows using drag and drop.  """
        self._widget.enable_model_drag_source(
            gtk.gdk.BUTTON1_MASK, [self.drop_yes], gtk.gdk.ACTION_MOVE)
        self._widget.enable_model_drag_dest(
            [self.drop_yes], gtk.gdk.ACTION_MOVE)
        self._widget.connect('drag-data-received', self.on_drag_data_received)
        self._widget.connect('drag-motion', self.on_drag_motion)

    def expand_to_path(self, path):
        """Expand row at path, expanding any ancestors as needed.
        
        This function is provided by gtk+ >=2.2, but it is not yet wrapped
        by pygtk 2.0.0."""
        for i in range(len(path)):
            self._widget.expand_row(path[:i+1], open_all=False)

    def check_sanity(self, model, source, target):
        source_path = model.get_path(source)
        target_path = model.get_path(target)
        return target_path[0:len(source_path)] != source_path

    def check_parentability(self, model, target, drop_position):
        return not ((drop_position == gtk.TREE_VIEW_DROP_INTO_OR_BEFORE
                    or drop_position == gtk.TREE_VIEW_DROP_INTO_OR_AFTER)
                    and model.get_value(target,
                                        self.COLUMN_ALLOW_CHILDREN) == False)

    def copy_row(self, source, target, drop_position):
        """Copy tree model rows from treeiter source into, before or
        after treeiter target.

        All children of the source row are also copied and the
        expanded/collapsed status of each row is maintained."""

        model = self._widget.get_model()
        source_row = model[source]
        if drop_position == gtk.TREE_VIEW_DROP_INTO_OR_BEFORE:
            new = model.prepend(parent=target, row=source_row)
        elif drop_position == gtk.TREE_VIEW_DROP_INTO_OR_AFTER:
            new = model.append(parent=target, row=source_row)
        elif drop_position == gtk.TREE_VIEW_DROP_BEFORE:
            new = model.insert_before(
                parent=None, sibling=target, row=source_row)
        elif drop_position == gtk.TREE_VIEW_DROP_AFTER:
            new = model.insert_after(
                parent=None, sibling=target, row=source_row)

        # Copy any children of the source row.
        for n in range(model.iter_n_children(source)):
            child = model.iter_nth_child(source, n)
            self.copy_row(child, new, gtk.TREE_VIEW_DROP_INTO_OR_BEFORE)

        # If the source row is expanded, expand the newly copied row
        # also.  We must add at least one child before we can expand,
        # so we expand here after the children have been copied.
        source_is_expanded = self._widget.row_expanded(model.get_path(source))
        if source_is_expanded:
            self.expand_to_path(model.get_path(new))

    def on_drag_data_received(self, widget, drag_context, x, y,
                              selection_data, info, eventtime):
        """Handler for 'drag-data-received' that moves dropped
        TreeView rows.  """
        target_path, drop_position = self._widget.get_dest_row_at_pos(x, y)
        model, source = self._widget.get_selection().get_selected()
        target = model.get_iter(target_path)
        sidx = model.get_path(source)[0]
        is_sane = self.check_sanity(model, source, target)
        is_parentable = self.check_parentability(model, target, drop_position)
        if is_sane and is_parentable:
            self.copy_row(source, target, drop_position)
            # If the drop has created a new child (drop into), expand
            # the parent so the user can see the newly copied row.
            if (drop_position == gtk.TREE_VIEW_DROP_INTO_OR_BEFORE
                or drop_position == gtk.TREE_VIEW_DROP_INTO_OR_AFTER):
                self._widget.expand_row(target_path, open_all=False)
            # Finish the drag and have gtk+ delete the drag source rows.
            drag_context.finish(success=True, del_=True, time=eventtime)

            tidx = target_path[0]
            if drop_position == gtk.TREE_VIEW_DROP_AFTER:
                tidx += 1
            straw.main.get_visible_category().move_feed(sidx, tidx)
#             self.move_feeds_in_category(source_path, target_path,
#                                         drop_position)
        else:
            drag_context.finish(success=False, del_=False, time=eventtime)
        
    def on_drag_motion(self, widget, drag_context, x, y, eventtime):
        try:
            target_path, drop_position = widget.get_dest_row_at_pos(x, y)
            model, source = widget.get_selection().get_selected()
            target = model.get_iter(target_path)
        except:
            return
        if source is None:
            return
        is_sane = self.check_sanity(model, source, target)
        is_parentable = self.check_parentability(model, target, drop_position)
        if is_sane and is_parentable:
            widget.enable_model_drag_dest([self.drop_yes], gtk.gdk.ACTION_MOVE)
        else:
            widget.enable_model_drag_dest([self.drop_no], gtk.gdk.ACTION_MOVE)

    def get_item_with_path(self, fl, path):
        if len(path) == 1:
            return fl[path[0]]
        head, tail = path[0], path[1:]
        logparam(locals(), "head", "tail")
        return self.get_item_with_path(fl[head], tail)

    def get_parent_with_path(self, fl, path):
        if len(path) > 1:
            return self.get_item_with_path(fl, path[:-1]), path[-1]
        return None, path[0]

    def move_feeds_in_feedlist(self, source_path, target_path, drop_position):
        assert False, "don't come here"
        if drop_position in (gtk.TREE_VIEW_DROP_INTO_OR_AFTER,
                             gtk.TREE_VIEW_DROP_INTO_OR_BEFORE):
            target_path = target_path + (0,)
        elif drop_position == gtk.TREE_VIEW_DROP_AFTER:
            target_path = target_path[:-1] + (target_path[-1] + 1,)
        feedlist = straw.FeedList.get_instance()
        sparent, sppath = self.get_parent_with_path(feedlist, source_path)
        tparent, tppath = self.get_parent_with_path(feedlist, target_path)
        feedlist.move(sppath, sparent, tppath, tparent)

    def get_location(self):
        model, iter = self._widget.get_selection().get_selected()
        if iter is None:
            return (None, None)
        path = model.get_path(iter)
        return self.get_parent_with_path(straw.FeedList.get_instance(), path)

class MainWindow:
    def __init__(self, xml):

        self._config = straw.Config.get_instance()

        self._item_view = ItemView(
            xml.get_widget('item_view_container'))
        self._exception_view = ExceptionView(
            xml.get_widget('feed_exception_frame'),
            xml.get_widget('feed_exception_label'))
        self._feed_info_view = FeedInfoDisplay(
            xml.get_widget('feed_info_container'))
        self._find_results_view = FindResultList(
            xml.get_widget('find_results_treeview'))
        self._offline_toggle = OfflineToggle(
            xml.get_widget('offline_toggle'))
        self._feed_list_view = FeedListView(
            xml.get_widget('feed_selection_treeview'))
        self._category_selector = CategorySelector(
            xml.get_widget('category_menu'), self.category_select)
        self._item_list_view = ItemList(
            xml.get_widget('item_selection_treeview'))
        self._toolbar = Toolbar(
            xml.get_widget('toolbar_default'))

        self._window = xml.get_widget('straw_main')
        self._window.set_default_size(*self._config.main_window_size)
        xml.get_widget('main_main_pane').set_position(self._config.main_pane_position)
        xml.get_widget('main_sub_pane').set_position(self._config.sub_pane_position)
        self._feed_info_view.set_size(self._config.main_pane_position)

        self._mode_view_notebook = xml.get_widget('mode_view_notebook')
        self._feed_selection_vbox = xml.get_widget('feed_selection_vbox')

        self._status_view = xml.get_widget("main_statusbar")

        self._window.drag_dest_set(
            gtk.DEST_DEFAULT_ALL,
            [('_NETSCAPE_URL', 0, 0), ('text/uri-list ', 0, 1),
             ('x-url/http', 0, 2)],
            gtk.gdk.ACTION_COPY | gtk.gdk.ACTION_MOVE)

        self._menu_feed_properties = xml.get_widget('menu_feed_properties')
        self._menu_feed_properties.set_sensitive(False)
        self._menu_feed_info = glade.get_widget_tree(xml.get_widget('menubar_default')).get_widget('menu_feed_information')
        if self._config.feed_info_visibility:
            self._menu_feed_info.set_active(gtk.TRUE)
            self._feed_info_view.show()
        else:
            self._menu_feed_info.set_active(gtk.FALSE)
            self._feed_info_view.hide()

        self._toolbar.show_tips()
        self._offline_toggle.show()

        for key in dir(self.__class__):
            if key[:3] == 'on_':
                xml.signal_connect(key, getattr(self, key))

        self._dashboard = straw.DashboardFrontend.get_instance()
        self._mmgr = straw.MessageManager.get_instance()
        self._mmgr.signal_connect(straw.StatusDisplaySignal,
                                  self.display_status_messages)

        self._feedlist = straw.FeedList.get_instance()

    def category_select(self, category, *args):
        straw.main.set_visible_category(category)
        self.display_feeds(
            category, straw.main.get_visible_feed())

    def get_find_results_view(self):
        return self._find_results_view

    def on_straw_main_destroy_event(self, *args):
        return straw.main.quit()

    def on_straw_main_delete_event(self, *args):
        return straw.main.quit()

    def on_straw_main_configure_event(self, widget, event, *args):
        def check_size((width, height, widget)):
            if width == widget.allocation.width and height == widget.allocation.height:
                self._config.main_window_size = (width, height)
        if event.width != widget.allocation.width or event.height != widget.allocation.height:
            gtk.timeout_add(1000, check_size, (
                (event.width, event.height, widget)))
        return gtk.FALSE

    def on_main_main_pane_size_allocate(self, widget, *args):
        config = straw.Config.get_instance()
        def check_position((position, widget)):
            if position == widget.get_position():
                self._feed_info_view.set_size(position)
                config.main_pane_position = position
        pos = widget.get_position()
        if pos != config.main_pane_position:
            gtk.timeout_add(1000, check_position, (pos, widget))

    def on_main_sub_pane_size_allocate(self, widget, *args):
        config = straw.Config.get_instance()
        def check_position((position, widget)):
            if position == widget.get_position():
                config.sub_pane_position = position
        pos = widget.get_position()
        if pos != config.sub_pane_position:
            gtk.timeout_add(1000, check_position, (pos, widget))

    def on_menu_about_activate(self, menuitem, *args):
        description = _("Straw is a desktop news aggregator for GNOME")
        about = gnome.ui.About(
            straw.APPNAME, straw.VERSION, "Copyright (c) 2002-2003 Juri Pakaste", description,
            ["Juri Pakaste <juri@iki.fi>",
             "Jan Alonzo <jmalonzo@unpluggable.com>",
             "Scott Douglas-Watson <sdouglaswatson@yahoo.co.uk>",
             u"Terje R\xf8sten <terjeros@phys.ntnu.no>",
             "feedparser.py and rssfinder.py by Mark Pilgrim",
             "Icons by Jakub 'jimmac' Steiner and Juri Pakaste"],
            [],
            "Juri Pakaste <juri@iki.fi>\n"
            "Martin Steldinger <tribble@hanfplantage.de>\n"
            "David Rousseau <boiteaflood@wanadoo.fr>\n"
            "Sergei Vavinov <svv@cmc.msu.ru>\n"
            u"Terje R\xf8sten <terjeros@phys.ntnu.no>\n"
            "Francisco J. Fernandez <franciscojavier.fernandez.serrador@hispalinux.es>\n"
            "Elros Cyriatan (Dutch)",
            gtk.gdk.pixbuf_new_from_file(straw.main.get_icon()))
        about.set_icon(gtk.gdk.pixbuf_new_from_file(straw.main.get_icon()))
        about.show()

    def on_menu_quit_activate(self, *args):
        straw.main.quit()

    def on_menu_preferences_activate(self, *args):
        straw.main.show_preferences_dialog()

    def on_menu_feed_properties_activate(self, *args):
        straw.main.show_feed_properties(straw.main.get_visible_feed())

    def on_menu_refresh_all_activate(self, *args):
        feeds = self._feedlist.flatten_list()
        straw.main.poll(feeds)

    def on_menu_refresh_selected_activate(self, *args):
        feed = straw.main.get_visible_feed()
        straw.main.poll([feed])

    def on_menu_refresh_category_activate(self, *args):
        category = straw.main.get_visible_category()
        straw.main.poll(category)

    def on_toolbar_poll_button_clicked(self, *args):
        category = straw.main.get_visible_category()
        straw.main.poll(category)

    def on_toolbar_add_button_clicked(self, *args):
        straw.main.show_subscribe_dialog()

    def on_menu_next_activate(self, *args):
        straw.main.display_next_item()

    def on_menu_previous_activate(self, *args):
        straw.main.display_previous_item()

    def on_menu_scroll_next_activate(self, *args):
        if self._category_selector.is_focused():
            self._category_selector.popup()
            return
        if not self._item_view.scroll_down():
            straw.main.display_next_unread_item()

    def on_menu_next_feed_activate(self, *args):
        straw.main.display_next_feed()
        return

    def on_menu_previous_feed_activate(self, *args):
        straw.main.display_previous_feed()
        return

    def on_menu_next_feed_unread_activate(self, *args):
        straw.main.display_next_unread_feed()
        return

    def on_menu_feed_information_activate(self, *args):
        if self._menu_feed_info.get_active():
            self._feed_info_view.show()
        else:
            self._feed_info_view.hide()

    def on_menu_find_activate(self, *args):
        self.show_find_mode()

    def on_menu_remove_selected_feed_activate(self, *args):
        self._feed_list_view.remove_selected_feed()

    def on_menu_add_activate(self, *args):
        straw.main.show_subscribe_dialog()

    def on_menu_import_subscriptions_activate(self, *args):
        straw.file_selector.subscriptions_import()

    def on_menu_export_subscriptions_activate(self, *args):
        straw.file_selector.subscriptions_export()

    def on_menu_mark_all_as_read_activate(self, *args):
        straw.main.mark_as_read()

    def on_menu_next_category_activate(self, *args):
        straw.main.display_next_category()

    def on_menu_previous_category_activate(self, *args):
        straw.main.display_previous_category()

    def on_menu_next_category_activate(self, *args):
        straw.main.display_next_category()

    def on_menu_previous_category_activate(self, *args):
        straw.main.display_previous_category()

    def on_straw_main_focus_in_event(self, *args):
        self._dashboard.focus_in()

    def on_straw_main_focus_out_event(self, *args):
        self._dashboard.focus_out()

    def on_feed_selection_treeview_row_expanded(self, *args):
        self._feed_list_view.row_expanded(*args)

    def on_feed_selection_treeview_row_collapsed(self, *args):
        self._feed_list_view.row_collapsed(*args)

    def show_find_mode(self):
        self._mode_view_notebook.set_current_page(1)
        self._feed_selection_vbox.hide()
        straw.main.show_find_dialog()

    def hide_find_mode(self):
        self._mode_view_notebook.set_current_page(0)
        self._feed_selection_vbox.show()

    def show_find_results(self, items):
        self._find_results_view.render_results(items)

    def display_feed(self, feed, select_first = 1):
        if feed.error is None:
            self._exception_view.hide()
        else:
            self._exception_view.show_exception(feed.error)
        self._item_list_view.display_feed(feed, select_first)
        self._feed_info_view.display_feed(feed)
        self._menu_feed_properties.set_sensitive(True)

    def display_feed_unselected(self, feed):
        self._feed_list_view.display_feed_unselected(feed)
        self._menu_feed_properties.set_sensitive(True)

    def display_empty_feed(self, feed):
        if feed.error is None:
            self._exception_view.hide()
        else:
            self._exception_view.show_exception(feed.error)
        self._item_list_view.display_empty_feed(feed)
        self._item_view.display_empty_feed(feed)

    def display_no_feed(self):
        self._exception_view.hide()
        self._item_list_view.display_empty_feed(None)
        self._item_view.display_empty_feed(None)
        self._menu_feed_properties.set_sensitive(False)

    def display_item_unselected(self, item):
        self._item_list_view.select_item(item)

    def display_item(self, item):
        self._item_view.display_item(item)

    def display_status_messages(self, signal):
        cid = self._status_view.get_context_id("straw_main")
        self._status_view.pop(cid)
        m = self._mmgr.read_message()
        self._status_view.push(cid, m)

    def update_total_unread_indicator(self):
        uritems = urfeeds = 0
        for ur in [f.number_of_unread for f in self._feedlist.flatten_list()]:
            if ur:
                uritems += ur
                urfeeds += 1
        map = {'uritems': uritems, 'urfeeds': urfeeds}
        self._window.set_title(('%s - ' % straw.APPNAME) +
                               _('%(uritems)d unread in %(urfeeds)d feeds') %
                               map )

    def all_items_read(self, signal, feed_index):
        self._feed_list_view.all_items_read(signal, feed_index)
        for index, item in signal.changed:
            self._item_list_view.mark_item(item, index)
        self.update_total_unread_indicator()

    def item_read(self, signal, feed_index):
        self._feed_list_view.item_read(signal, feed_index)
        self._item_list_view.mark_item(signal.item)
        self.update_total_unread_indicator()

    def feed_updated(self, signal, feed_index):
        self._feed_list_view.feed_updated(signal, feed_index)
        if signal.sender.feed is straw.main.get_visible_feed():
            self.display_feed(signal.sender.feed)
        self.update_total_unread_indicator()

    def display_feeds(self, category, visible_feed):
        self._category_selector.set_selected(category)
        self._feed_list_view.display_feeds(category, visible_feed)
        self._feed_list_view.get_widget().get_selection().select_path((0,))
        self.update_total_unread_indicator()

    def display_categories(self):
        self._category_selector.display_categories()

    def get_window(self):
        return self._window

    def on_straw_main_drag_data_received(self, w, context, x, y, data, info, time):
        if data and data.format == 8:
            straw.main.show_subscribe_dialog(data.data.split("\n")[0])
            context.finish(gtk.TRUE, gtk.FALSE, time)
        else:
            context.finish(gtk.FALSE, gtk.FALSE, time)

    def disable_feed_selection(self):
        self._feed_list_view.disable_feed_selection()

    def enable_feed_selection(self):
        self._feed_list_view.enable_feed_selection()

