#! /usr/bin/env python
#
# setup.py for Straw
#
# 

import imp
import sys
import glob
import os.path

from tools.straw_distutils import setup

name = 'straw'
version = '0.23'

# Check for Python < 2.2
if sys.version < '2.2':
    sys.exit('Error: Python-2.2 or newer is required. Current version:\n %s'
             % sys.version)

def modules_check():
    '''Check if necessary modules is installed.
    The function is executed by distutils (by the install command).'''
    try:
        import pygtk
        pygtk.require('2.0')
        imp.find_module('gtk')
    except:
        sys.exit('Error: PyGTK-1.99.13 or newer is required.')

    mod_list = [
        ('ORBit', 'pyorbit', 0),
        ('gnome', 'gnome-python', 0),
        ('gnome.vfs', "gnome-python's gnomevfs", 0),
        ('gtkhtml2', "gnome-python's gtkhtml2", 1),
        ('gconf', "gnome-python's gconf", 0)]

    if sys.version < '2.3':
        mod_list.append(('bsddb3.db', 'bsddb3', 0))

    ok = 1
    for m, w, x in mod_list:
        try:
            if not x:
                exec('import %s' % m)
            else:
                imp.find_module(m)
        except ImportError:
            ok = False
            print 'Error: %s Python module is required to install %s' \
                  % (w, name.title())
    try:
        import adns, ADNS
    except ImportError:
        print 'Warning: adns Python module not found, will continue without.'

    # gtk.glade needs special care (ugly...)
    if ok:
        path = imp.find_module('gtk')
        if not os.path.exists(path[1] + '/glade.so'):
            ok = False
            print 'Error: %s Python module is required to install %s' \
                  % ("PyGTK's glade", name.title())
    if not ok:
        sys.exit(1)

def translations():
    '''Build mo-po mapping from po directory'''
    trans = []
    dest = 'share/locale/%s/LC_MESSAGES/%s.mo'
    for po in glob.glob('po/*.po'):
        lang = os.path.splitext(os.path.basename(po))[0]
        trans.append((dest % (lang , name), po))
    return trans

def translation_files():
    '''Files for translation...'''
    potfile = './po/POTFILES.in'

    if not os.path.exists(potfile):
        sys.exit("No such file, '%s'. Please file a bug report.." % potfile)

    f = open(potfile)
    files = []

    for line in f:
        # ignore comments and newline
        if line.startswith('#') or line.startswith('\n'):
            continue
        else: files.append(line.strip())

    f.close()
    return files

def data_files():
    '''Build list of data files to be installed'''
    images = glob.glob('images/*.png')
    files = [
        ('share/pixmaps', ['images/straw.png']),
        ('share/straw', images + ['data/default_subscriptions.opml', 'glade/straw.glade'])]
    return files

long_desc = '''\
Straw is a desktop news aggregator for the GNOME environment.
Its aim is to be a faster, easier and more accessible way to read
news and blogs than the traditional browser.'''

# Let distutils do the work
setup(name             = name,
      version          = version,
      description      = 'Desktop news aggregator for GNOME',
      long_description = long_desc,
      author           = 'Juri Pakaste',
      author_email     = 'juri@iki.fi',
      url              = 'http://www.nongnu.org/straw/',
      license          = 'GPL',
      data_files       = data_files(),
      pot_file         = 'po/straw.pot',
      translations     = translations(),
      config_files     = [('gconf/schemas',['data/straw.schemas'],
                           'with-gconf-schema-file-dir')],
      scripts          = ['src/straw'],
      modules_check    = modules_check,
      packages         = ['straw'],
      package_dir      = {'straw' : 'src/lib'},
      msg_sources      = translation_files(),
      desktop_file     = ['straw.desktop.in'])

