/*
 * $Id: st-browser-tab.h,v 1.27 2004/01/30 16:26:40 jylefort Exp $
 *
 * Copyright (c) 2003, 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ST_BROWSER_TAB_H
#define _ST_BROWSER_TAB_H

#include <gtk/gtk.h>
#include "st-category.h"
#include "st-handler.h"
#include "st-thread.h"

#define ST_TYPE_BROWSER_TAB			(st_browser_tab_get_type())
#define ST_BROWSER_TAB(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), ST_TYPE_BROWSER_TAB, STBrowserTab))
#define ST_BROWSER_TAB_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), ST_TYPE_BROWSER_TAB, STBrowserTabClass))
#define ST_IS_BROWSER_TAB(obj)			(G_TYPE_CHECK_INSTANCE_TYPE((obj), ST_TYPE_BROWSER_TAB))
#define ST_IS_BROWSER_TAB_CLASS(klass)		(G_TYPE_CHECK_CLASS_TYPE((klass), ST_TYPE_BROWSER_TAB))
#define ST_BROWSER_TAB_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS((obj), ST_TYPE_BROWSER_TAB, STBrowserTabClass))

typedef struct
{
  GtkHPaned			paned;
  
  GtkWidget			*window;		/* our parent STBrowserWindow */

  GSList			*labels;		/* a list of tab labels */

  STHandler			*handler;		/* public */
  GtkWidget			*statusbar;		/* public */
  int				statusbar_depth;

  gboolean			refreshing;
  GMutex			*refreshing_mutex;

  STThread			*thread;

  GtkWidget			*category_scrolled;
  GtkWidget			*category_view;		/* public */

  GtkWidget			*stream_scrolled;
  GtkWidget			*stream_view;		/* public */
} STBrowserTab;

typedef struct
{
  GtkHPanedClass	parent_class;
} STBrowserTabClass;

GType		st_browser_tab_get_type		(void);
GtkWidget	*st_browser_tab_new		(GtkWidget	*window,
						 STHandler	*handler);
GtkWidget	*st_browser_tab_get_label	(STBrowserTab	*tab);
void		st_browser_tab_set_label_icon_visible (STBrowserTab *tab,
						       gboolean     visible);

void		st_browser_tab_update_sensitivity (STBrowserTab	*tab);

gboolean	st_browser_tab_is_empty		(STBrowserTab	*tab);
gboolean	st_browser_tab_is_refreshing	(STBrowserTab	*tab);

void		st_browser_tab_refresh		(STBrowserTab	*tab);
void		st_browser_tab_update		(STBrowserTab	*tab);
void		st_browser_tab_abort		(STBrowserTab	*tab);
gboolean	st_browser_tab_can_stop		(STBrowserTab	*tab);
void		st_browser_tab_stop		(STBrowserTab	*tab);

void		st_browser_tab_category_selected	(STBrowserTab	*tab);
void		st_browser_tab_streams_selected		(STBrowserTab	*tab);

#endif /* _ST_BROWSER_TAB_H */
