/*
 * $Id: streamtuner.c,v 1.78 2004/01/27 14:16:42 jylefort Exp $
 *
 * Copyright (c) 2002, 2003, 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include <glib.h>
#include <unistd.h>
#include <stdlib.h>
#include "gettext.h"
#include "st-handlers.h"
#include "st-action.h"
#include "st-session.h"
#include "st-settings.h"
#include "st-stock.h"
#include "st-thread.h"
#include "st-shell.h"

/*** variable declarations ***************************************************/

static char *custom_private_dir = NULL;

/*** function declarations ***************************************************/

static void parse_args		(int argc, char **argv);
static void print_help		(void);
static void print_version	(void);

/*** implementation **********************************************************/

int
main (int argc, char **argv)
{
#ifdef ENABLE_NLS
  bindtextdomain(GETTEXT_PACKAGE, LOCALEDIR);
  bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
  textdomain(GETTEXT_PACKAGE);
#endif

  parse_args(argc, argv);

  st_thread_init();
  gtk_init(&argc, &argv);
  st_stock_init();

  st_settings_init(custom_private_dir);
  st_action_init();
  st_session_init();
  
  st_handlers_load_static();

  st_shell_load_plugins();
  st_shell_load_session();
  st_shell_main();

  return 0;			/* to avoid compiler warning */
}

static void
parse_args (int argc, char **argv)
{
  int c;

  while ((c = getopt(argc, argv, "d:thv")) != -1)
    switch (c)
      {
      case 'd':
	custom_private_dir = g_strdup(optarg);
	break;
      case 'h':
	print_help();
	exit(0);
      case 'v':
	print_version();
	exit(0);
      case '?':
	exit(1);
      default:
	abort();
      }
}

static void
print_help (void)
{
  g_print(_("Usage: streamtuner [OPTIONS]\n"));
  g_print("\n");
  g_print(_("Options:\n"));
  g_print(_("  -d DIR   Specify a configuration directory (default is ~/.streamtuner)\n"));
  g_print(_("  -h       Show this help and exit\n"));
  g_print(_("  -v       Show version information and exit\n"));
}

static void
print_version (void)
{
  g_print(_("%s version %s\n"), PACKAGE, VERSION);
  g_print(COPYRIGHT "\n");

#ifdef WITH_STATIC_SHOUTCAST
  g_print("\n");
  g_print(_("The SHOUTcast plugin has been built into streamtuner.\n"));
#endif
}
