# $Id: acinclude.m4,v 1.21 2004/01/31 14:51:35 jylefort Exp $
#
# Copyright (c) 2002, 2003 Jean-Yves Lefort.
#
# This file is part of streamtuner.
# It may be distributed under the same terms as streamtuner.

dnl AC_ARG_G_ASSERTIONS
dnl
AC_DEFUN(AC_ARG_G_ASSERTIONS,
[AC_ARG_ENABLE(assertions,
AC_HELP_STRING([--disable-assertions],
[disable GLib assertions (not recommended)]),
[case "$enableval" in
	yes|no) enable_assertions=$enableval ;;
	*) AC_MSG_ERROR([bad value $enableval for --enable-assertions]) ;;
esac], [enable_assertions=yes])

if test $enable_assertions = no; then
	G_ASSERTIONS="-DG_DISABLE_ASSERT"
else
	G_ASSERTIONS=""
fi

AC_SUBST(G_ASSERTIONS)])

dnl AC_ARG_COMPILE_WARNINGS
dnl (only works with gcc)
dnl
AC_DEFUN(AC_ARG_COMPILE_WARNINGS,
[AC_ARG_ENABLE(compile-warnings,
AC_HELP_STRING([--enable-compile-warnings=no|yes|error],
[enable compiler warnings [[no]]]),
[case "$enableval" in
	yes|no|error) enable_compile_warnings=$enableval ;;
	*) AC_MSG_ERROR([bad value $enableval for --enable-compile-warnings]) ;;
esac], [enable_compile_warnings=no])

if test $enable_compile_warnings = no; then
	WARN_CFLAGS=
else
	WARN_CFLAGS="-Wall -Wshadow -Wcast-qual -Wcast-align -Wredundant-decls -Wnested-externs -Winline"
	test $enable_compile_warnings = error && WARN_CFLAGS="$WARN_CFLAGS -Werror"
fi

AC_SUBST(WARN_CFLAGS)])

dnl AC_FUNC_GMODULE_2_0_SUPPORTED([ACTION-IF-SUPPORTED], [ACTION-IF-NOT-SUPPORTED])
dnl
AC_DEFUN(AC_FUNC_GMODULE_2_0_SUPPORTED,
[AC_ARG_ENABLE(gmoduletest,
AC_HELP_STRING(--disable-gmoduletest,
[do not try to compile and run a test GModule program]),
[case "$enableval" in
	yes|no) enable_gmoduletest=$enableval ;;
	*) AC_MSG_ERROR([bad value $enableval for --enable-gmoduletest]) ;;
esac], [enable_gmoduletest=yes])

supported=no

if test $enable_gmoduletest = yes; then
	ac_save_CFLAGS="$CFLAGS"
	ac_save_LIBS="$LIBS"
	CFLAGS="$CFLAGS $GMODULE_CFLAGS"
	LIBS="$LIBS $GMODULE_LIBS"

	AC_MSG_CHECKING([if modules are supported by GModule])

	AC_TRY_RUN([
#include <glib.h>
#include <gmodule.h>

int main () {
	exit(g_module_supported() ? 0 : 1);
}
], [supported=yes],, [supported=yes])

	AC_MSG_RESULT($supported)

	CFLAGS="$ac_save_CFLAGS"
	LIBS="$ac_save_LIBS"

	if test $supported = yes; then
		ifelse([$1],, :, [$1])
	else
		ifelse([$2],, :, [$2])
	fi
fi])
