/*
 * $Id: sg-printable.c,v 1.7 2004/01/05 19:44:09 jylefort Exp $
 *
 * Copyright (c) 2003 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdarg.h>
#include "sg-printable.h"

/*** implementation **********************************************************/

GType
sg_printable_get_type (void)
{
  static GType printable_type = 0;
  
  if (! printable_type)
    {
      static const GTypeInfo printable_info = {
	sizeof(SGPrintableIface),
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	0,
	0,
	NULL
      };
      
      printable_type = g_type_register_static(G_TYPE_INTERFACE,
					      "SGPrintable",
					      &printable_info,
					      0);
    }

  return printable_type;
}

void
sg_printable_print (SGPrintable *printable, const char *str)
{
  SGPrintableIface *iface;

  g_return_if_fail(SG_IS_PRINTABLE(printable));

  iface = SG_PRINTABLE_GET_IFACE(printable);

  g_return_if_fail(iface != NULL);
  g_return_if_fail(iface->print != NULL);
  
  (*iface->print)(printable, str);
}

void
sg_printable_printf (SGPrintable *printable, const char *format, ...)
{
  va_list args;
  char *str;

  g_return_if_fail(SG_IS_PRINTABLE(printable));
  g_return_if_fail(format != NULL);

  va_start(args, format);
  str = g_strdup_vprintf(format, args);
  va_end(args);

  sg_printable_print(printable, str);
  g_free(str);
}
